/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprisePaymentScheme.IUmcEnterprisePaymentSchemeModel;
import com.tydic.dyc.umc.model.enterprisePaymentScheme.UmcEnterprisePaymentSchemeDo;
import com.tydic.dyc.umc.model.enterprisePaymentScheme.qrybo.UmcEnterprisePaymentSchemeQryBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterprisePaymentSchemeListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterprisePaymentSchemeBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterprisePaymentSchemeListReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterprisePaymentSchemeListRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcQryEnterprisePaymentSchemeListService"})
public class UmcQryEnterprisePaymentSchemeListServiceImpl
implements UmcQryEnterprisePaymentSchemeListService {
    private static final Logger log = LoggerFactory.getLogger(UmcQryEnterprisePaymentSchemeListServiceImpl.class);
    @Autowired
    private IUmcEnterprisePaymentSchemeModel iUmcEnterprisePaymentSchemeModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"qryEnterprisePaymentSchemeList"})
    public UmcQryEnterprisePaymentSchemeListRspBo qryEnterprisePaymentSchemeList(@RequestBody UmcQryEnterprisePaymentSchemeListReqBo reqBo) {
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("201006", "\u5165\u53c2\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcEnterprisePaymentSchemeQryBo qryBo = new UmcEnterprisePaymentSchemeQryBo();
        qryBo.setOrgId(reqBo.getOrgId());
        qryBo.setOrderBy("sort,create_time desc");
        List<UmcEnterprisePaymentSchemeDo> umcEnterprisePaymentSchemeDoList = this.iUmcEnterprisePaymentSchemeModel.getList(qryBo);
        ArrayList<UmcEnterprisePaymentSchemeBo> enterprisePaymentSchemeBoList = new ArrayList<UmcEnterprisePaymentSchemeBo>();
        if (!CollectionUtils.isEmpty(umcEnterprisePaymentSchemeDoList)) {
            Map paymentCategoryMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "UMC_ENTERPRISE_PAYMENT_CATEGORY")).getMap();
            for (UmcEnterprisePaymentSchemeDo each : umcEnterprisePaymentSchemeDoList) {
                UmcEnterprisePaymentSchemeBo umcEnterprisePaymentSchemeBo = (UmcEnterprisePaymentSchemeBo)UmcRu.js((Object)each, UmcEnterprisePaymentSchemeBo.class);
                if (StringUtils.isNotBlank((String)umcEnterprisePaymentSchemeBo.getPaymentCategory())) {
                    umcEnterprisePaymentSchemeBo.setPaymentCategoryStr((String)paymentCategoryMap.get(umcEnterprisePaymentSchemeBo.getPaymentCategory()));
                }
                enterprisePaymentSchemeBoList.add(umcEnterprisePaymentSchemeBo);
            }
        }
        UmcQryEnterprisePaymentSchemeListRspBo rspBo = new UmcQryEnterprisePaymentSchemeListRspBo();
        if (!CollectionUtils.isEmpty(enterprisePaymentSchemeBoList)) {
            StringBuilder paymentScheme = new StringBuilder();
            int i = 1;
            for (UmcEnterprisePaymentSchemeBo umcEnterprisePaymentSchemeBo : enterprisePaymentSchemeBoList) {
                String paymentTermsStr;
                if (i > 1) {
                    paymentScheme.append("</br>");
                }
                if (StringUtils.isBlank((String)(paymentTermsStr = umcEnterprisePaymentSchemeBo.getPaymentTerms()))) {
                    paymentTermsStr = "\u8ba2\u5355\u751f\u6210\u4ed8\u9884\u4ed8\u6b3e";
                }
                if (!StringUtils.isEmpty((String)paymentTermsStr) && umcEnterprisePaymentSchemeBo.getPaymentDays() != null) {
                    paymentTermsStr = paymentTermsStr.replace("N", umcEnterprisePaymentSchemeBo.getPaymentDays().toString());
                }
                paymentScheme.append(umcEnterprisePaymentSchemeBo.getPaymentCategoryStr()).append("-").append(paymentTermsStr).append(",").append("\u4ed8\u6b3e\u6bd4\u4f8b").append(umcEnterprisePaymentSchemeBo.getPaymentRatio()).append("%");
                if (i == enterprisePaymentSchemeBoList.size()) {
                    paymentScheme.append("\u3002");
                } else {
                    paymentScheme.append("\uff1b");
                }
                ++i;
            }
            rspBo.setPaymentScheme(paymentScheme.toString());
        }
        rspBo.setEnterprisePaymentSchemeBoList(enterprisePaymentSchemeBoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

