/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.service.enterprise.UmcUpdateEnterpriseBaseInfoListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcUpdateEnterpriseBaseInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcUpdateEnterpriseBaseInfoListReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcUpdateEnterpriseBaseInfoListRspBo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enterprise.UmcUpdateEnterpriseBaseInfoListService"})
public class UmcUpdateEnterpriseBaseInfoListServiceImpl
implements UmcUpdateEnterpriseBaseInfoListService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateEnterpriseBaseInfoListServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"updateEnterpriseInfoList"})
    public UmcUpdateEnterpriseBaseInfoListRspBo updateEnterpriseInfoList(@RequestBody UmcUpdateEnterpriseBaseInfoListReqBo reqBo) {
        UmcUpdateEnterpriseBaseInfoListRspBo rspBo = (UmcUpdateEnterpriseBaseInfoListRspBo)UmcRu.success(UmcUpdateEnterpriseBaseInfoListRspBo.class);
        this.validateParams(reqBo);
        for (UmcUpdateEnterpriseBaseInfoBo umcUpdateEnterpriseBaseInfoBo : reqBo.getUmcUpdateEnterpriseBaseInfoBos()) {
            if (umcUpdateEnterpriseBaseInfoBo.getOrgId() == null) {
                throw new BaseBusinessException("200001", "\u5165\u53c2\u3010\u673a\u6784id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            UmcEnterpriseInfoDo setInfo = (UmcEnterpriseInfoDo)UmcRu.js((Object)umcUpdateEnterpriseBaseInfoBo, UmcEnterpriseInfoDo.class);
            StrUtil.noNullStringAttr((Object)setInfo);
            setInfo.setUpdateTime(new Date());
            setInfo.setUpdateOperId(reqBo.getUserId());
            setInfo.setUpdateOperName(reqBo.getName());
            setInfo.setOrgId(umcUpdateEnterpriseBaseInfoBo.getOrgId());
            try {
                this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(setInfo);
            }
            catch (Exception e) {
                log.debug("\u4fee\u6539\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new BaseBusinessException("100001", "\u4fee\u6539\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            }
        }
        return rspBo;
    }

    private void validateParams(UmcUpdateEnterpriseBaseInfoListReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u3010reqBo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcUpdateEnterpriseBaseInfoBos())) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u3010umcUpdateEnterpriseBaseInfoBos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

