/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.freight;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.freight.IUmcFreightConfigModel;
import com.tydic.dyc.umc.model.freight.UmcFreightConfigDo;
import com.tydic.dyc.umc.model.freight.qrybo.UmcFreightConfigQryBo;
import com.tydic.dyc.umc.service.freight.bo.UmcAddFreightConfigReqBo;
import com.tydic.dyc.umc.service.freight.bo.UmcAddFreightConfigRspBo;
import com.tydic.dyc.umc.service.freight.service.UmcAddFreightConfigService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.freight.service.UmcAddFreightConfigService"})
public class UmcAddFreightConfigServiceImpl
implements UmcAddFreightConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcAddFreightConfigServiceImpl.class);
    public static final String DEL_FLAG = "0";
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcFreightConfigModel iUmcFreightConfigModel;

    @PostMapping(value={"addFreightConfig"})
    public UmcAddFreightConfigRspBo addFreightConfig(@RequestBody UmcAddFreightConfigReqBo reqBo) {
        UmcAddFreightConfigRspBo rspBo = (UmcAddFreightConfigRspBo)UmcRu.success(UmcAddFreightConfigRspBo.class);
        this.checkParam(reqBo);
        if (DEL_FLAG.equals(reqBo.getIsDefault())) {
            this.checkOrg(reqBo);
            this.checkExists(reqBo);
        }
        try {
            UmcFreightConfigDo umcFreightConfigDo = (UmcFreightConfigDo)UmcRu.js((Object)reqBo, UmcFreightConfigDo.class);
            umcFreightConfigDo.setFreightConfigId(IdUtil.nextId());
            umcFreightConfigDo.setCreatedId(reqBo.getUserId());
            umcFreightConfigDo.setCreatedName(reqBo.getUserName());
            umcFreightConfigDo.setCreatedTime(new Date());
            umcFreightConfigDo.setUpdatedId(reqBo.getUserId());
            umcFreightConfigDo.setUpdatedName(reqBo.getUserName());
            umcFreightConfigDo.setUpdatedTime(new Date());
            umcFreightConfigDo.setIsDefault(DEL_FLAG);
            umcFreightConfigDo.setDelFlag(DEL_FLAG);
            this.iUmcFreightConfigModel.addFreightConfig(umcFreightConfigDo);
        }
        catch (Exception e) {
            log.debug("\u65b0\u589e\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u65b0\u589e\u5931\u8d25!");
        }
        return rspBo;
    }

    private void checkExists(UmcAddFreightConfigReqBo reqBo) {
        UmcFreightConfigQryBo qryUmcFreightConfigQryBo = new UmcFreightConfigQryBo();
        qryUmcFreightConfigQryBo.setEnterpriseId(reqBo.getEnterpriseId());
        qryUmcFreightConfigQryBo.setFreightType(reqBo.getFreightType());
        UmcFreightConfigDo umcFreightConfigDo = this.iUmcFreightConfigModel.qryFreightConfig(qryUmcFreightConfigQryBo);
        if (umcFreightConfigDo != null) {
            throw new BaseBusinessException("100001", "\u8be5\u673a\u6784\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u8fd0\u8d39\u89c4\u5219!");
        }
    }

    private void checkOrg(UmcAddFreightConfigReqBo reqBo) {
        UmcOrgInfoQryBo umcOrgInfoQryBo = new UmcOrgInfoQryBo();
        umcOrgInfoQryBo.setOrgId(reqBo.getEnterpriseId());
        Integer result = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(umcOrgInfoQryBo).getNumber();
        if (result == null || result < 1) {
            throw new BaseBusinessException("100001", "\u8be5\u673a\u6784\u4e0d\u5b58\u5728!");
        }
    }

    private void checkParam(UmcAddFreightConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getIsDefault())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u662f\u5426\u9ed8\u8ba4]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (DEL_FLAG.equals(reqBo.getIsDefault()) && reqBo.getEnterpriseId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u673a\u6784id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getEnterpriseName() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u673a\u6784\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getFreightAmount() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8fd0\u8d39\u6536\u8d39\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getFreightThreshold() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8fd0\u8d39\u6536\u8d39\u95e8\u69db]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getFreightType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8fd0\u8d39\u914d\u7f6e\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

