/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.freight;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.freight.IUmcFreightConfigModel;
import com.tydic.dyc.umc.model.freight.UmcFreightConfigDo;
import com.tydic.dyc.umc.model.freight.qrybo.UmcFreightConfigQryBo;
import com.tydic.dyc.umc.service.freight.bo.UmcDealTrilateralFreightConfigReqBo;
import com.tydic.dyc.umc.service.freight.bo.UmcDealTrilateralFreightConfigRspBo;
import com.tydic.dyc.umc.service.freight.service.UmcDealTrilateralFreightConfigService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.freight.service.UmcDealTrilateralFreightConfigService"})
public class UmcDealTrilateralFreightConfigServiceImpl
implements UmcDealTrilateralFreightConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcDealTrilateralFreightConfigServiceImpl.class);
    public static final String DEL_FLAG = "0";
    public static final String DEFAULT_NAME = "\u9ed8\u8ba4\u89c4\u5219";
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcFreightConfigModel iUmcFreightConfigModel;

    @PostMapping(value={"dealTrilateralFreightConfig"})
    public UmcDealTrilateralFreightConfigRspBo dealTrilateralFreightConfig(@RequestBody UmcDealTrilateralFreightConfigReqBo reqBo) {
        UmcDealTrilateralFreightConfigRspBo rspBo = (UmcDealTrilateralFreightConfigRspBo)UmcRu.success(UmcDealTrilateralFreightConfigRspBo.class);
        this.checkParam(reqBo);
        this.checkOrg(reqBo);
        UmcFreightConfigDo umcFreightConfigDo = (UmcFreightConfigDo)UmcRu.js((Object)reqBo, UmcFreightConfigDo.class);
        umcFreightConfigDo.setEnterpriseId(reqBo.getCompanyId());
        umcFreightConfigDo.setEnterpriseName(DEFAULT_NAME);
        umcFreightConfigDo.setFreightType("3");
        UmcFreightConfigQryBo qryUmcFreightConfigQryBo = new UmcFreightConfigQryBo();
        qryUmcFreightConfigQryBo.setEnterpriseId(reqBo.getCompanyId());
        qryUmcFreightConfigQryBo.setFreightType("3");
        UmcFreightConfigDo umcFreightConfigResultDo = this.iUmcFreightConfigModel.qryFreightConfig(qryUmcFreightConfigQryBo);
        if (umcFreightConfigResultDo == null) {
            try {
                umcFreightConfigDo.setFreightConfigId(IdUtil.nextId());
                umcFreightConfigDo.setCreatedId(reqBo.getUserId());
                umcFreightConfigDo.setCreatedName(reqBo.getUserName());
                umcFreightConfigDo.setCreatedTime(new Date());
                umcFreightConfigDo.setUpdatedId(reqBo.getUserId());
                umcFreightConfigDo.setUpdatedName(reqBo.getUserName());
                umcFreightConfigDo.setUpdatedTime(new Date());
                umcFreightConfigDo.setIsDefault(DEL_FLAG);
                umcFreightConfigDo.setDelFlag(DEL_FLAG);
                this.iUmcFreightConfigModel.addFreightConfig(umcFreightConfigDo);
            }
            catch (Exception e) {
                log.debug("\u65b0\u589e\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25{}", (Object)e.getMessage());
                throw new BaseBusinessException("100001", "\u65b0\u589e\u4e09\u65b9\u4ea4\u6613\u8ba2\u5355\u95e8\u69db\u8bbe\u7f6e\u5931\u8d25!");
            }
        }
        try {
            umcFreightConfigDo.setFreightConfigId(umcFreightConfigResultDo.getFreightConfigId());
            umcFreightConfigDo.setUpdatedId(reqBo.getUserId());
            umcFreightConfigDo.setUpdatedName(reqBo.getUserName());
            umcFreightConfigDo.setUpdatedTime(new Date());
            this.iUmcFreightConfigModel.updateFreightConfig(umcFreightConfigDo);
        }
        catch (Exception e) {
            log.debug("\u4fee\u6539\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fee\u6539\u4e09\u65b9\u4ea4\u6613\u8ba2\u5355\u95e8\u69db\u8bbe\u7f6e\u5931\u8d25!");
        }
        return rspBo;
    }

    private void checkOrg(UmcDealTrilateralFreightConfigReqBo reqBo) {
        UmcOrgInfoQryBo umcOrgInfoQryBo = new UmcOrgInfoQryBo();
        umcOrgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
        Integer result = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(umcOrgInfoQryBo).getNumber();
        if (result == null || result < 1) {
            throw new BaseBusinessException("100001", "\u8be5\u673a\u6784\u4e0d\u5b58\u5728!");
        }
    }

    private void checkParam(UmcDealTrilateralFreightConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getFreightAmount() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8fd0\u8d39\u6536\u8d39\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getFreightThreshold() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8fd0\u8d39\u6536\u8d39\u95e8\u69db]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

