/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.freight;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.freight.IUmcFreightConfigModel;
import com.tydic.dyc.umc.model.freight.UmcFreightConfigDo;
import com.tydic.dyc.umc.model.freight.qrybo.UmcFreightConfigQryBo;
import com.tydic.dyc.umc.service.freight.bo.UmcDelFreightConfigReqBo;
import com.tydic.dyc.umc.service.freight.bo.UmcDelFreightConfigRspBo;
import com.tydic.dyc.umc.service.freight.service.UmcDelFreightConfigService;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.freight.service.UmcDelFreightConfigService"})
public class UmcDelFreightConfigServiceImpl
implements UmcDelFreightConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcDelFreightConfigServiceImpl.class);
    public static final String DEL_FLAG = "1";
    @Autowired
    private IUmcFreightConfigModel iUmcFreightConfigModel;

    @PostMapping(value={"delFreightConfig"})
    public UmcDelFreightConfigRspBo delFreightConfig(@RequestBody UmcDelFreightConfigReqBo reqBo) {
        UmcDelFreightConfigRspBo rspBo = (UmcDelFreightConfigRspBo)UmcRu.success(UmcDelFreightConfigRspBo.class);
        this.checkParam(reqBo);
        UmcFreightConfigQryBo qryUmcFreightConfigQryBo = new UmcFreightConfigQryBo();
        qryUmcFreightConfigQryBo.setFreightConfigId(reqBo.getFreightConfigId());
        UmcFreightConfigDo umcFreightConfigDo = this.iUmcFreightConfigModel.qryFreightConfig(qryUmcFreightConfigQryBo);
        if (umcFreightConfigDo == null) {
            throw new BaseBusinessException("100001", "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        if (DEL_FLAG.equals(umcFreightConfigDo.getIsDefault())) {
            throw new BaseBusinessException("100001", "\u9ed8\u8ba4\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u88ab\u5220\u9664");
        }
        try {
            UmcFreightConfigDo updateUmcFreightConfigDo = new UmcFreightConfigDo();
            updateUmcFreightConfigDo.setFreightConfigId(reqBo.getFreightConfigId());
            updateUmcFreightConfigDo.setDelFlag(DEL_FLAG);
            updateUmcFreightConfigDo.setUpdatedId(reqBo.getUserId());
            updateUmcFreightConfigDo.setUpdatedName(reqBo.getUserName());
            updateUmcFreightConfigDo.setUpdatedTime(new Date());
            this.iUmcFreightConfigModel.updateFreightConfig(updateUmcFreightConfigDo);
        }
        catch (Exception e) {
            log.debug("\u4fee\u6539\u95e8\u69db\u8fd0\u8d39\u8bbe\u7f6e\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fee\u6539\u5931\u8d25!");
        }
        return rspBo;
    }

    private void checkParam(UmcDelFreightConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getFreightConfigId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8fd0\u8d39\u914d\u7f6eId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

