/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoice;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterpriseacount.IUmcEnterpriseAccountModel;
import com.tydic.dyc.umc.model.enterpriseacount.UmcEnterpriseAccountDo;
import com.tydic.dyc.umc.model.enterpriseacount.qrybo.UmcEnterpriseAccountDoRspBo;
import com.tydic.dyc.umc.model.enterpriseacount.qrybo.UmcEnterpriseAccountQryBo;
import com.tydic.dyc.umc.model.invoice.IUmcInvoiceInfoModel;
import com.tydic.dyc.umc.model.invoice.UmcInvoiceInfoDo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoListRspBo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoQryBo;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressListRspBo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.model.ldUser.IUmcLdUserInfoModel;
import com.tydic.dyc.umc.model.ldUser.qrybo.UmcGetInvoiceCheckQryBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcCreateOperateInvoiceInfoReqBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcCreateOperateInvoiceInfoRspBo;
import com.tydic.dyc.umc.service.invoice.service.UmcCreateOperateInvoiceInfoService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoice.service.UmcCreateOperateInvoiceInfoService"})
public class UmcCreateOperateInvoiceInfoServiceImpl
implements UmcCreateOperateInvoiceInfoService {
    public static final String INVOICE_ADDRESS_TYPE = "02";
    @Autowired
    private IUmcLdUserInfoModel iUmcLdUserInfoModel;
    @Autowired
    private IUmcInvoiceInfoModel iUmcInvoiceInfoModel;
    @Autowired
    private IUmcEnterpriseAccountModel iUmcEnterpriseAccountModel;
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;

    @PostMapping(value={"createOperateInvoiceInfo"})
    public UmcCreateOperateInvoiceInfoRspBo createOperateInvoiceInfo(@RequestBody UmcCreateOperateInvoiceInfoReqBo reqBo) {
        UmcCreateOperateInvoiceInfoRspBo rspBo = (UmcCreateOperateInvoiceInfoRspBo)UmcRu.success(UmcCreateOperateInvoiceInfoRspBo.class);
        this.validationParams(reqBo);
        this.checkSameInvoice(reqBo);
        if (reqBo.getAccountId() == null && reqBo.getOrgIdWeb() != null) {
            UmcEnterpriseAccountQryBo accountQryBo = new UmcEnterpriseAccountQryBo();
            accountQryBo.setOrgIdWeb(reqBo.getOrgIdWeb());
            UmcEnterpriseAccountDoRspBo enterpriseAccountPage = this.iUmcEnterpriseAccountModel.getEnterpriseAccountPage(accountQryBo);
            if (!CollectionUtils.isEmpty((Collection)enterpriseAccountPage.getRows())) {
                reqBo.setAccountId(((UmcEnterpriseAccountDo)enterpriseAccountPage.getRows().get(0)).getAccountId());
            }
        }
        UmcInvoiceInfoDo invoiceInfoDo = (UmcInvoiceInfoDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqBo, UmcInvoiceInfoDo.class));
        invoiceInfoDo.setCreateTime(new Date());
        invoiceInfoDo.setDelFlag("0");
        invoiceInfoDo.setOrgId(reqBo.getOrgIdWeb());
        List<UmcInvoiceInfoDo> invoiceInfoDoList = this.qryInvByAccountId(reqBo.getAccountId());
        if (CollectionUtils.isEmpty(invoiceInfoDoList)) {
            invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.YES);
        } else if (!ObjectUtils.isEmpty((Object)reqBo.getMainFlag()) && reqBo.getMainFlag().equals(UmcCommConstant.EntInvMainFlag.YES)) {
            this.cancleMainFlagAddr(invoiceInfoDoList);
        } else {
            invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.NO);
        }
        UmcInvoiceInfoDo invoiceInfo = this.iUmcInvoiceInfoModel.createInvoiceInfo(invoiceInfoDo);
        this.addCheckSameAddr(reqBo);
        rspBo.setInvoiceId(invoiceInfo.getInvoiceId());
        return rspBo;
    }

    private void addCheckSameAddr(UmcCreateOperateInvoiceInfoReqBo reqBo) {
        UmcInvoiceAddressQryBo umcInvoiceAddressQryBo = new UmcInvoiceAddressQryBo();
        umcInvoiceAddressQryBo.setAccountId(reqBo.getAccountId());
        umcInvoiceAddressQryBo.setOrgId(reqBo.getOrgIdWeb());
        if (StringUtils.isBlank((CharSequence)reqBo.getContact())) {
            umcInvoiceAddressQryBo.setName(reqBo.getInvoiceTitle());
        } else {
            umcInvoiceAddressQryBo.setName(reqBo.getContact());
        }
        umcInvoiceAddressQryBo.setElcInvoiceEmail(reqBo.getContactMail());
        umcInvoiceAddressQryBo.setExtField1(INVOICE_ADDRESS_TYPE);
        UmcInvoiceAddressQryBo qryBo = (UmcInvoiceAddressQryBo)StrUtil.noNullStringAttr((Object)umcInvoiceAddressQryBo);
        UmcInvoiceAddressDo invoiceAddressCheck = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        if (invoiceAddressCheck.getCount() == 0) {
            UmcInvoiceAddressDo invoiceAddressDo = (UmcInvoiceAddressDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)umcInvoiceAddressQryBo, UmcInvoiceAddressDo.class));
            List<UmcInvoiceAddressDo> invoiceAddressDoList = null != umcInvoiceAddressQryBo.getAccountId() ? this.qryAddrByAccountId(umcInvoiceAddressQryBo.getAccountId()) : this.qryAddrByOrgId(umcInvoiceAddressQryBo.getOrgId());
            if (CollectionUtils.isEmpty(invoiceAddressDoList)) {
                invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
            } else {
                invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            }
            invoiceAddressDo.setInvoiceAddrId(Long.valueOf(IdUtil.nextId()));
            invoiceAddressDo.setAddrStatus("01");
            invoiceAddressDo.setDelFlag("0");
            invoiceAddressDo.setCreateOperName(reqBo.getCreateOperName());
            invoiceAddressDo.setCreateTime(new Date());
            invoiceAddressDo.setCreateOperId(reqBo.getCreateOperId());
            invoiceAddressDo.setUpdateOperId(reqBo.getCreateOperId());
            invoiceAddressDo.setUpdateOperName(reqBo.getCreateOperName());
            invoiceAddressDo.setUpdateTime(new Date());
            UmcInvoiceAddressDo umcInvoiceAddressDo = this.iUmcInvoiceAddressModel.createInvoiceAddress(invoiceAddressDo);
        }
    }

    private List<UmcInvoiceAddressDo> qryAddrByAccountId(Long accountId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private List<UmcInvoiceAddressDo> qryAddrByOrgId(Long orgId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setOrgId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private List<UmcInvoiceInfoDo> qryInvByAccountId(Long accountId) {
        UmcInvoiceInfoQryBo qryBo = new UmcInvoiceInfoQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceInfoListRspBo umcInvoiceInfoListRspBo = this.iUmcInvoiceInfoModel.getInvoiceInfoList(qryBo);
        return umcInvoiceInfoListRspBo.getRows();
    }

    private void cancleMainFlagAddr(List<UmcInvoiceInfoDo> invoiceInfoDoList) {
        for (UmcInvoiceInfoDo invoiceInfoDo : invoiceInfoDoList) {
            UmcInvoiceInfoDo invoiceInfoDo1 = new UmcInvoiceInfoDo();
            invoiceInfoDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            invoiceInfoDo1.setInvoiceId(invoiceInfoDo.getInvoiceId());
            invoiceInfoDo1.setDelFlag("0");
            this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo1);
        }
    }

    private void validationParams(UmcCreateOperateInvoiceInfoReqBo reqBo) {
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getTaxpayerId())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getContactMail())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u63a5\u6536\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkSameInvoice(UmcCreateOperateInvoiceInfoReqBo reqBo) {
        UmcGetInvoiceCheckQryBo qryBo = new UmcGetInvoiceCheckQryBo();
        qryBo.setInvoiceType(reqBo.getInvoiceType());
        qryBo.setInvoiceClass(reqBo.getInvoiceClass());
        qryBo.setInvoiceTitle(reqBo.getInvoiceTitle());
        qryBo.setTaxpayerId(reqBo.getTaxpayerId());
        qryBo.setOrgId(reqBo.getOrgIdWeb());
        Integer count = this.iUmcLdUserInfoModel.getInvoiceCheck(qryBo);
        if (count != null && count > 0) {
            throw new ZTBusinessException("\u5df2\u6709\u76f8\u540c\u7684\u53d1\u7968\u4fe1\u606f");
        }
    }
}

