/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterpriseacount.IUmcEnterpriseAccountModel;
import com.tydic.dyc.umc.model.enterpriseacount.UmcEnterpriseAccountDo;
import com.tydic.dyc.umc.model.enterpriseacount.qrybo.UmcEnterpriseAccountDoRspBo;
import com.tydic.dyc.umc.model.enterpriseacount.qrybo.UmcEnterpriseAccountQryBo;
import com.tydic.dyc.umc.model.invoice.IUmcInvoiceInfoModel;
import com.tydic.dyc.umc.model.invoice.UmcInvoiceInfoDo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoListRspBo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoQryBo;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressListRspBo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcUpdateOperateInvoiceInfoReqBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcUpdateOperateInvoiceInfoRspBo;
import com.tydic.dyc.umc.service.invoice.service.UmcUpdateOperateInvoiceInfoService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.invoice.service.UmcUpdateOperateInvoiceInfoService"})
public class UmcUpdateOperateInvoiceInfoServiceImpl
implements UmcUpdateOperateInvoiceInfoService {
    public static final String INVOICE_ADDRESS_TYPE = "02";
    @Autowired
    private IUmcInvoiceInfoModel iUmcInvoiceInfoModel;
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;
    @Autowired
    private IUmcEnterpriseAccountModel iUmcEnterpriseAccountModel;

    @PostMapping(value={"updateOperateInvoiceInfo"})
    public UmcUpdateOperateInvoiceInfoRspBo updateOperateInvoiceInfo(@RequestBody UmcUpdateOperateInvoiceInfoReqBo reqBo) {
        List<UmcInvoiceInfoDo> invoiceInfoDoList;
        UmcUpdateOperateInvoiceInfoRspBo rspBo = (UmcUpdateOperateInvoiceInfoRspBo)UmcRu.success(UmcUpdateOperateInvoiceInfoRspBo.class);
        this.validationParams(reqBo);
        if (reqBo.getAccountId() == null && reqBo.getOrgIdWeb() != null) {
            UmcEnterpriseAccountQryBo accountQryBo = new UmcEnterpriseAccountQryBo();
            accountQryBo.setOrgIdWeb(reqBo.getOrgIdWeb());
            UmcEnterpriseAccountDoRspBo enterpriseAccountPage = this.iUmcEnterpriseAccountModel.getEnterpriseAccountPage(accountQryBo);
            if (!CollectionUtils.isEmpty((Collection)enterpriseAccountPage.getRows())) {
                reqBo.setAccountId(((UmcEnterpriseAccountDo)enterpriseAccountPage.getRows().get(0)).getAccountId());
            }
        }
        UmcInvoiceInfoDo invoiceInfoDo = (UmcInvoiceInfoDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqBo, UmcInvoiceInfoDo.class));
        invoiceInfoDo.setUpdateTime(new Date());
        invoiceInfoDo.setExtinvoiceStatus(reqBo.getExtInvoiceStatus());
        if (reqBo.getMainFlag().equals(UmcCommConstant.EntInvMainFlag.YES) && !CollectionUtils.isEmpty(invoiceInfoDoList = this.qryInvByAccountId(reqBo.getAccountId()))) {
            this.cancleMainFlagAddr(invoiceInfoDoList);
        }
        this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo);
        this.addCheckSameAddr(reqBo);
        return rspBo;
    }

    private void addCheckSameAddr(UmcUpdateOperateInvoiceInfoReqBo reqBo) {
        UmcInvoiceAddressQryBo umcInvoiceAddressQryBo = new UmcInvoiceAddressQryBo();
        umcInvoiceAddressQryBo.setAccountId(reqBo.getAccountId());
        umcInvoiceAddressQryBo.setOrgId(reqBo.getOrgIdWeb());
        if (StringUtils.isBlank((CharSequence)reqBo.getContact())) {
            umcInvoiceAddressQryBo.setName(reqBo.getInvoiceTitle());
        } else {
            umcInvoiceAddressQryBo.setName(reqBo.getContact());
        }
        umcInvoiceAddressQryBo.setElcInvoiceEmail(reqBo.getContactMail());
        umcInvoiceAddressQryBo.setExtField1(INVOICE_ADDRESS_TYPE);
        UmcInvoiceAddressQryBo qryBo = (UmcInvoiceAddressQryBo)StrUtil.noNullStringAttr((Object)umcInvoiceAddressQryBo);
        UmcInvoiceAddressDo invoiceAddressCheck = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        if (invoiceAddressCheck.getCount() == 0) {
            UmcInvoiceAddressDo invoiceAddressDo = (UmcInvoiceAddressDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)umcInvoiceAddressQryBo, UmcInvoiceAddressDo.class));
            List<UmcInvoiceAddressDo> invoiceAddressDoList = null != umcInvoiceAddressQryBo.getAccountId() ? this.qryAddrByAccountId(umcInvoiceAddressQryBo.getAccountId()) : this.qryAddrByOrgId(umcInvoiceAddressQryBo.getOrgId());
            if (CollectionUtils.isEmpty(invoiceAddressDoList)) {
                invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
            } else {
                invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            }
            invoiceAddressDo.setInvoiceAddrId(Long.valueOf(IdUtil.nextId()));
            invoiceAddressDo.setAddrStatus("01");
            invoiceAddressDo.setDelFlag("0");
            invoiceAddressDo.setCreateOperName(reqBo.getUpdateOperName());
            invoiceAddressDo.setCreateTime(new Date());
            invoiceAddressDo.setCreateOperId(reqBo.getUpdateOperId());
            invoiceAddressDo.setUpdateOperId(reqBo.getUpdateOperId());
            invoiceAddressDo.setUpdateOperName(reqBo.getUpdateOperName());
            invoiceAddressDo.setUpdateTime(new Date());
            UmcInvoiceAddressDo umcInvoiceAddressDo = this.iUmcInvoiceAddressModel.createInvoiceAddress(invoiceAddressDo);
        }
    }

    private List<UmcInvoiceAddressDo> qryAddrByAccountId(Long accountId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private List<UmcInvoiceAddressDo> qryAddrByOrgId(Long orgId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setOrgId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private void validationParams(UmcUpdateOperateInvoiceInfoReqBo reqBo) {
        if (null == reqBo.getInvoiceId()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u53d1\u7968id[accountId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getTaxpayerId())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getContactMail())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u53d1\u7968\u63a5\u6536\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<UmcInvoiceInfoDo> qryInvByAccountId(Long accountId) {
        UmcInvoiceInfoQryBo qryBo = new UmcInvoiceInfoQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceInfoListRspBo umcInvoiceInfoListRspBo = this.iUmcInvoiceInfoModel.getInvoiceInfoList(qryBo);
        return umcInvoiceInfoListRspBo.getRows();
    }

    private void cancleMainFlagAddr(List<UmcInvoiceInfoDo> invoiceInfoDoList) {
        for (UmcInvoiceInfoDo invoiceInfoDo : invoiceInfoDoList) {
            UmcInvoiceInfoDo invoiceInfoDo1 = new UmcInvoiceInfoDo();
            invoiceInfoDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            invoiceInfoDo1.setInvoiceId(invoiceInfoDo.getInvoiceId());
            invoiceInfoDo1.setDelFlag("0");
            this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo1);
        }
    }
}

