/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.ldOrganization;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.umc.constants.UmcExtCommConstants;
import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.model.ldOrganization.sub.UmcLdCustSubDo;
import com.tydic.dyc.umc.service.ldOrganization.UmcDealSynchronizeCustService;
import com.tydic.dyc.umc.service.ldOrganization.bo.LdCustListReqBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.LdCustListRspBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcDealSynchronizeCustBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcDealSynchronizeCustReqBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcDealSynchronizeCustRspBO;
import com.tydic.dyc.umc.utils.HttpClientUtil;
import com.tydic.dyc.umc.utils.UmcBusinessException;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.ldOrganization.UmcDealSynchronizeCustService"})
public class UmcDealSynchronizeCustServiceImpl
implements UmcDealSynchronizeCustService {
    private static final Logger log = LogManager.getLogger(UmcDealSynchronizeCustServiceImpl.class);
    @Value(value="${SYN_CUST:http://10.0.11.60:8001/OSN/api/syncData/v1}")
    private String SYN_CUST;
    @Value(value="${SYN_CUST_PAGE_SIZE:500}")
    private int SYN_CUST_PAGE_SIZE;
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;

    @PostMapping(value={"dealSynchronizeCust"})
    public UmcDealSynchronizeCustRspBO dealSynchronizeCust(@RequestBody UmcDealSynchronizeCustReqBO reqBO) {
        UmcDealSynchronizeCustRspBO rspBO = new UmcDealSynchronizeCustRspBO();
        ThreadPoolExecutor threadService = new ThreadPoolExecutor(UmcExtCommConstants.CPU, 2 * UmcExtCommConstants.CPU, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        String uri = this.SYN_CUST;
        int page = 1;
        int pageSize = this.SYN_CUST_PAGE_SIZE;
        while (true) {
            LdCustListReqBO ldReqBO = new LdCustListReqBO();
            ldReqBO.setPageNum(Integer.valueOf(page));
            ldReqBO.setPageSize(Integer.valueOf(pageSize));
            ldReqBO.setBusinessCode("2001");
            ldReqBO.setEnterpriseId(Integer.valueOf(107));
            JSONObject jsonParam = JSONObject.parseObject((String)JSON.toJSONString((Object)ldReqBO));
            log.debug("\u8c03\u7528\u8054\u4e1c\u63a5\u53e3\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u63a5\u53e3URL\uff1a{}", (Object)uri);
            log.debug("\u8c03\u7528\u8054\u4e1c\u63a5\u53e3\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)jsonParam);
            JSONObject jsonObject = HttpClientUtil.httpPost(uri, jsonParam);
            LdCustListRspBO ldRspBO = (LdCustListRspBO)JSONObject.toJavaObject((JSON)jsonObject, LdCustListRspBO.class);
            if (!"200".equals(ldRspBO.getStatus())) {
                throw new UmcBusinessException("8888", ldRspBO.getMessage());
            }
            if (ldRspBO.getData() != null && !CollectionUtils.isEmpty((Collection)ldRspBO.getData())) {
                threadService.execute(() -> {
                    List rows = JSONObject.parseArray((String)JSON.toJSONString((Object)ldRspBO.getData()), UmcDealSynchronizeCustBO.class);
                    ArrayList<UmcLdCustSubDo> dealData = new ArrayList<UmcLdCustSubDo>(rows.size());
                    for (UmcDealSynchronizeCustBO each : rows) {
                        UmcLdCustSubDo umcLdCustDo = (UmcLdCustSubDo)UmcRu.js((Object)each, UmcLdCustSubDo.class);
                        dealData.add(umcLdCustDo);
                    }
                    try {
                        if (!CollectionUtils.isEmpty(dealData)) {
                            int n = this.iUmcLdOrganizationInfoModel.synchronizeCust(dealData);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u8054\u4e1c\u7ec4\u6570\u636e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                        throw new UmcBusinessException("8888", "\u540c\u6b65\u8054\u4e1c\u7ec4\u6570\u636e\u5931\u8d25!");
                    }
                });
            }
            if (ldRspBO.getPages().equals(ldRspBO.getPageNum())) break;
            ++page;
        }
        threadService.shutdown();
        this.iUmcLdOrganizationInfoModel.synchronizeOwnerIdExt();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

