/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.ldOrganization;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.LdUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.LdUmcEnterpriseOrgQryBo;
import com.tydic.dyc.umc.service.ldOrganization.UmcPushCustomerBatchInfoService;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcPushCustomerBatchInfoReqBo;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcPushCustomerBatchInfoRspBo;
import com.tydic.dyc.umc.service.ldUser.bo.UmcLdCustomerInfoReqBo;
import com.tydic.dyc.umc.service.ldUser.bo.UmcLdCustomerInfoRspBo;
import com.tydic.dyc.umc.utils.HttpClientUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.ldOrganization.UmcPushCustomerBatchInfoService"})
public class UmcPushCustomerBatchInfoServiceImpl
implements UmcPushCustomerBatchInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcPushCustomerBatchInfoServiceImpl.class);
    public static final String PUSH_REVENUE_CENTER = "1";
    @Autowired
    private LdUmcEnterpriseInfoModel ldUmcEnterpriseInfoModel;
    public static final String STATUS = "200";
    @Value(value="${PUSH_ADD_CUSTOMER_INFO_URL:http://10.0.11.60:8001/OSN/api/addCustomer/v1}")
    private String pushAddCustomerInfoUrl;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"pushCustomerBatchInfo"})
    public UmcPushCustomerBatchInfoRspBo pushCustomerBatchInfo(@RequestBody UmcPushCustomerBatchInfoReqBo reqBO) {
        LdUmcEnterpriseOrgQryBo qryBo = new LdUmcEnterpriseOrgQryBo();
        qryBo.setOrgClass("2");
        qryBo.setPageNo(-1);
        qryBo.setPageSize(-1);
        qryBo.setPushRevenueCenter(PUSH_REVENUE_CENTER);
        BasePageRspBo<UmcEnterpriseInfoDo> enterpriseOrgInfoListPage = this.ldUmcEnterpriseInfoModel.getEnterpriseOrgInfoListPage(qryBo);
        if (!CollectionUtils.isEmpty((Collection)enterpriseOrgInfoListPage.getRows())) {
            for (UmcEnterpriseInfoDo row : enterpriseOrgInfoListPage.getRows()) {
                if (StringUtils.isBlank((CharSequence)row.getCreditNo()) || StringUtils.isBlank((CharSequence)row.getOrgName())) continue;
                UmcLdCustomerInfoReqBo umcCustomerInfoBo = new UmcLdCustomerInfoReqBo();
                umcCustomerInfoBo.setEnterpriseId(Integer.valueOf(107));
                umcCustomerInfoBo.setOwnerName(row.getOrgName());
                umcCustomerInfoBo.setOwnerType(PUSH_REVENUE_CENTER);
                umcCustomerInfoBo.setCertificateType("20");
                umcCustomerInfoBo.setCertificate(row.getCreditNo());
                umcCustomerInfoBo.setIsInternalStaff(Integer.valueOf(0));
                JSONObject jsonParam = JSONObject.parseObject((String)JSON.toJSONString((Object)umcCustomerInfoBo));
                log.debug("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u5ba2\u6237\u4fe1\u606f\u65b0\u589e\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)jsonParam.toJSONString());
                JSONObject jsonObject = HttpClientUtil.httpPost(this.pushAddCustomerInfoUrl, jsonParam);
                log.debug("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u5ba2\u6237\u4fe1\u606f\u65b0\u589e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)jsonObject);
                UmcLdCustomerInfoRspBo umcLdCustomerInfoRspBo = (UmcLdCustomerInfoRspBo)JSONObject.toJavaObject((JSON)jsonObject, UmcLdCustomerInfoRspBo.class);
                if (!STATUS.equals(umcLdCustomerInfoRspBo.getStatus()) || umcLdCustomerInfoRspBo.getOwnerId() == null) continue;
                UmcEnterpriseInfoDo umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
                umcEnterpriseInfoDo.setExtField9(umcLdCustomerInfoRspBo.getOwnerId().toString());
                umcEnterpriseInfoDo.setOrgId(row.getOrgId());
                this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(umcEnterpriseInfoDo);
            }
        }
        UmcPushCustomerBatchInfoRspBo rspBo = (UmcPushCustomerBatchInfoRspBo)UmcRu.success(UmcPushCustomerBatchInfoRspBo.class);
        return rspBo;
    }
}

