/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.ldOrganization;

import com.tydic.dyc.umc.model.ldOrganization.IUmcLdOrganizationInfoModel;
import com.tydic.dyc.umc.model.ldOrganization.UmcLdOrganizationInfoQryDo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoQryBo;
import com.tydic.dyc.umc.service.ldOrganization.UmcSelectLdOrgInfoListTreeService;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcSelectLdOrgInfoListTreeReqBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcSelectLdOrgInfoListTreeRspBO;
import com.tydic.dyc.umc.service.ldOrganization.bo.UmcSelectProjectInfoBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.ldOrganization.UmcSelectLdOrgInfoListTreeService"})
public class UmcSelectLdOrgInfoListTreeServiceImpl
implements UmcSelectLdOrgInfoListTreeService {
    private static final Logger log = LogManager.getLogger(UmcSelectLdOrgInfoListTreeServiceImpl.class);
    @Autowired
    private IUmcLdOrganizationInfoModel iUmcLdOrganizationInfoModel;

    @PostMapping(value={"selectLdOrgInfoListTree"})
    public UmcSelectLdOrgInfoListTreeRspBO selectLdOrgInfoListTree(@RequestBody UmcSelectLdOrgInfoListTreeReqBO reqBO) {
        UmcSelectLdOrgInfoListTreeRspBO rspBO = new UmcSelectLdOrgInfoListTreeRspBO();
        UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo = new UmcLdOrganizationInfoQryBo();
        umcLdOrganizationInfoQryBo.setOrgNameFullPath(reqBO.getOrgNameFullPath());
        umcLdOrganizationInfoQryBo.setOrgShortName(reqBO.getOrgShortName());
        List<UmcLdOrganizationInfoQryDo> umcLdOrganizationInfoQryDos = this.iUmcLdOrganizationInfoModel.selectLdOrgInfoListTree(umcLdOrganizationInfoQryBo);
        if (!CollectionUtils.isEmpty(umcLdOrganizationInfoQryDos)) {
            LinkedList<UmcSelectProjectInfoBO> umcSelectProjectInfoList = new LinkedList<UmcSelectProjectInfoBO>();
            for (UmcLdOrganizationInfoQryDo each : umcLdOrganizationInfoQryDos) {
                UmcSelectProjectInfoBO jsl = (UmcSelectProjectInfoBO)UmcRu.js((Object)each, UmcSelectProjectInfoBO.class);
                jsl.setLabel(each.getOrgShortName());
                umcSelectProjectInfoList.add(jsl);
            }
            List<UmcSelectProjectInfoBO> umcSelectProjectInfoBOS = this.buildByRecursive(umcSelectProjectInfoList);
            rspBO.setRows(umcSelectProjectInfoBOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UmcSelectProjectInfoBO> buildByRecursive(List<UmcSelectProjectInfoBO> treeNodes) {
        ArrayList<UmcSelectProjectInfoBO> trees = new ArrayList<UmcSelectProjectInfoBO>();
        for (UmcSelectProjectInfoBO treeNode : treeNodes) {
            treeNode.setLabel(treeNode.getOrgShortName());
            if (!"0".equals(treeNode.getParentOrgId())) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        return trees;
    }

    private UmcSelectProjectInfoBO findChildren(UmcSelectProjectInfoBO root, List<UmcSelectProjectInfoBO> allData) {
        for (UmcSelectProjectInfoBO it : allData) {
            if (!root.getOrgDepId().equals(it.getParentOrgId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            root.getChildren().add(this.findChildren(it, allData));
        }
        return root;
    }
}

