/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.ldProject;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.umc.constants.UmcExtCommConstants;
import com.tydic.dyc.umc.model.ldProject.IUmcLdProjectInfoModel;
import com.tydic.dyc.umc.model.ldProject.qrybo.UmcLdProjectQryBo;
import com.tydic.dyc.umc.service.ldProject.UmcSyncLdProjectInfoService;
import com.tydic.dyc.umc.service.ldProject.bo.LdProjectInfoRspBo;
import com.tydic.dyc.umc.service.ldProject.bo.UmcSyncLdProjectBo;
import com.tydic.dyc.umc.service.ldProject.bo.UmcSyncLdProjectInfoReqBo;
import com.tydic.dyc.umc.service.ldProject.bo.UmcSyncLdProjectInfoRspBo;
import com.tydic.dyc.umc.utils.HttpClientUtil;
import com.tydic.dyc.umc.utils.UmcBusinessException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.ldProject.UmcSyncLdProjectInfoService"})
public class UmcSyncLdProjectInfoServiceImpl
implements UmcSyncLdProjectInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcSyncLdProjectInfoServiceImpl.class);
    @Value(value="${SYN_LD_PROJECT:http://10.0.11.60:8001/OSN/api/projectList/v1}")
    private String SYN_LD_PROJECT;
    @Autowired
    private IUmcLdProjectInfoModel iUmcLdProjectInfoModel;

    @PostMapping(value={"syncLdProjectInfo"})
    public UmcSyncLdProjectInfoRspBo syncLdProjectInfo(@RequestBody UmcSyncLdProjectInfoReqBo reqBO) {
        UmcSyncLdProjectInfoRspBo rspBO = new UmcSyncLdProjectInfoRspBo();
        ThreadPoolExecutor threadService = new ThreadPoolExecutor(UmcExtCommConstants.CPU, 2 * UmcExtCommConstants.CPU, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        String uri = this.SYN_LD_PROJECT;
        int page = 1;
        int pageSize = 500;
        while (true) {
            JSONObject jsonParam = new JSONObject();
            jsonParam.put("pageNum", (Object)page);
            jsonParam.put("pageSize", (Object)pageSize);
            log.debug("\u8c03\u7528\u8054\u4e1cPROD\u9879\u76ee\u4e3b\u6570\u636e\u63a5\u53e3URL\uff1a{}", (Object)uri);
            log.debug("\u8c03\u7528\u8054\u4e1cPROD\u9879\u76ee\u4e3b\u6570\u636e\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)jsonParam);
            JSONObject jsonObject = HttpClientUtil.httpPost(uri, jsonParam);
            log.debug("\u8c03\u7528\u8054\u4e1cPROD\u9879\u76ee\u4e3b\u6570\u636e\u63a5\u53e3\u51fa\u53c2:{}", (Object)jsonObject.toJSONString());
            LdProjectInfoRspBo ldRspBO = (LdProjectInfoRspBo)JSONObject.toJavaObject((JSON)jsonObject, LdProjectInfoRspBo.class);
            if (!"2000".equals(ldRspBO.getCode())) {
                throw new UmcBusinessException("8888", "\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
            }
            if (ldRspBO.getData() != null && !CollectionUtils.isEmpty((Collection)ldRspBO.getData().getContent())) {
                threadService.execute(() -> {
                    List rows = JSONObject.parseArray((String)JSON.toJSONString((Object)ldRspBO.getData().getContent()), UmcSyncLdProjectBo.class);
                    ArrayList<UmcLdProjectQryBo> dealData = new ArrayList<UmcLdProjectQryBo>(rows.size());
                    for (UmcSyncLdProjectBo each : rows) {
                        Date date;
                        SimpleDateFormat sdf;
                        UmcLdProjectQryBo umcLdProjectBo = new UmcLdProjectQryBo();
                        umcLdProjectBo.setSn(each.getSn());
                        umcLdProjectBo.setProjectVersionId(each.getProjectVersionId());
                        umcLdProjectBo.setProjectCode(each.getProjectCode());
                        umcLdProjectBo.setDverType(each.getDver_type());
                        umcLdProjectBo.setCreatedBy(each.getCreated_by());
                        if (!StringUtils.isBlank((CharSequence)each.getCreated_date())) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                date = sdf.parse(each.getCreated_date());
                                umcLdProjectBo.setCreatedDate(date);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                        umcLdProjectBo.setUpdatedBy(each.getUpdated_by());
                        if (!StringUtils.isBlank((CharSequence)each.getUpdated_date())) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                date = sdf.parse(each.getUpdated_date());
                                umcLdProjectBo.setUpdatedDate(date);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                        umcLdProjectBo.setCompanyCode(each.getCompanyCode());
                        umcLdProjectBo.setPhase(each.getPhase());
                        umcLdProjectBo.setPhaseName(each.getPhaseName());
                        umcLdProjectBo.setProjectVersion(each.getProjectVersion());
                        umcLdProjectBo.setErpProjectCode(each.getErpProjectCode());
                        umcLdProjectBo.setProjectAbbreviation(each.getProjectAbbreviation());
                        umcLdProjectBo.setProjectPromotionName(each.getProjectPromotionName());
                        umcLdProjectBo.setProjectQuality(each.getProjectQuality());
                        umcLdProjectBo.setProjectType(each.getProjectType());
                        umcLdProjectBo.setLegalCompany(each.getLegalCompany());
                        umcLdProjectBo.setLegalCompanyCode(each.getLegalCompanyCode());
                        umcLdProjectBo.setLegalCompanyName(each.getLegalCompanyName());
                        umcLdProjectBo.setProvinceCode(each.getProvinceCode());
                        umcLdProjectBo.setCityCode(each.getCityCode());
                        umcLdProjectBo.setRegionCode(each.getRegionCode());
                        dealData.add(umcLdProjectBo);
                    }
                    if (!CollectionUtils.isEmpty(dealData)) {
                        try {
                            int n = this.iUmcLdProjectInfoModel.createOrUpdateLdProjectInfos(dealData);
                        }
                        catch (Exception e) {
                            log.debug("\u63d2\u5165\u6216\u8005\u4fee\u6539\u5c97\u4f4d\u7ec4\u4fe1\u606f\u5931\u8d25{},", (Object)e.getMessage());
                            throw new UmcBusinessException("8888", e.getMessage());
                        }
                    }
                });
            }
            if (ldRspBO.getData() == null || CollectionUtils.isEmpty((Collection)ldRspBO.getData().getContent())) break;
            ++page;
        }
        threadService.shutdown();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

