/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.ldinvoiceaddress;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressListRspBo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.service.ldinvoiceaddress.bo.LdUmcInvoiceAddressUpdateReqBo;
import com.tydic.dyc.umc.service.ldinvoiceaddress.bo.LdUmcInvoiceAddressUpdateRspBo;
import com.tydic.dyc.umc.service.ldinvoiceaddress.service.LdUmcInvoiceAddressUpdateService;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.ldinvoiceaddress.service.LdUmcInvoiceAddressUpdateService"})
public class LdUmcInvoiceAddressUpdateServiceImpl
implements LdUmcInvoiceAddressUpdateService {
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"updateInvoiceAddress"})
    public LdUmcInvoiceAddressUpdateRspBo updateInvoiceAddress(@RequestBody LdUmcInvoiceAddressUpdateReqBo reqBo) {
        List<UmcInvoiceAddressDo> invoiceAddressDoList;
        this.validationParams(reqBo);
        LdUmcInvoiceAddressUpdateRspBo rspBo = (LdUmcInvoiceAddressUpdateRspBo)UmcRu.success(LdUmcInvoiceAddressUpdateRspBo.class);
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setInvoiceAddrId(reqBo.getInvoiceAddrId());
        UmcInvoiceAddressDo invoiceAddressCheck = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        int checkIdValue = invoiceAddressCheck.getCount();
        if (checkIdValue < 1) {
            throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u5730\u5740ID[" + reqBo.getInvoiceAddrId() + "]\u4e0d\u5b58\u5728");
        }
        if (null == reqBo.getAccountId()) {
            UmcOrgInfoQryBo orgInfoCheckReqBo = new UmcOrgInfoQryBo();
            orgInfoCheckReqBo.setOrgId(reqBo.getOrgIdWeb());
            Integer checkOrgInfo = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(orgInfoCheckReqBo).getNumber();
            if (checkOrgInfo == null) {
                throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + reqBo.getOrgIdWeb() + "]\u4e0d\u5b58\u5728");
            }
            if (checkOrgInfo < 1) {
                throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + reqBo.getOrgIdWeb() + "]\u4e0d\u5b58\u5728");
            }
        }
        if (reqBo.getMainFlag().equals(UmcCommConstant.InvAddrMainFlag.YES) && !CollectionUtils.isEmpty(invoiceAddressDoList = null != reqBo.getAccountId() ? this.qryAddrByAccountId(reqBo.getAccountId()) : this.qryAddrByOrgId(reqBo.getOrgIdWeb()))) {
            this.cancleMainFlagAddr(invoiceAddressDoList);
        }
        UmcInvoiceAddressDo invoiceAddressDo = (UmcInvoiceAddressDo)StrUtil.noNullStringAttr((Object)UmcRu.js((Object)reqBo, UmcInvoiceAddressDo.class));
        invoiceAddressDo.setCompanyName(reqBo.getCompanyNameWeb());
        invoiceAddressDo.setName(reqBo.getContactNameWeb());
        invoiceAddressDo.setAreaCode(reqBo.getAreaCode());
        invoiceAddressDo.setAreaName(reqBo.getAreaName());
        invoiceAddressDo.setAddrDesc(reqBo.getAddrDesc());
        invoiceAddressDo.setTel(reqBo.getTel());
        invoiceAddressDo.setSpecialPlane(reqBo.getSpecialPlane());
        invoiceAddressDo.setRemark(reqBo.getRemark());
        invoiceAddressDo.setPostCode(reqBo.getPostCode());
        invoiceAddressDo.setCountyId(reqBo.getCountyId());
        invoiceAddressDo.setCountryName(reqBo.getCountryName());
        invoiceAddressDo.setProvinceId(reqBo.getProvinceId());
        invoiceAddressDo.setProvinceName(reqBo.getProvinceName());
        invoiceAddressDo.setCityId(reqBo.getCityId());
        invoiceAddressDo.setCityName(reqBo.getCityName());
        invoiceAddressDo.setCountyId(reqBo.getCountyId());
        invoiceAddressDo.setCountyName(reqBo.getCountyName());
        invoiceAddressDo.setTownId(reqBo.getTownId());
        invoiceAddressDo.setTownName(reqBo.getTownName());
        invoiceAddressDo.setElcInvoiceEmail(reqBo.getElcInvoiceEmail());
        invoiceAddressDo.setElcInvoiceMobile(reqBo.getElcInvoiceMobile());
        invoiceAddressDo.setEmail(reqBo.getEmail());
        invoiceAddressDo.setAddrStatus("01");
        invoiceAddressDo.setUpdateTime(new Date());
        invoiceAddressDo.setUpdateOperName(reqBo.getCustNameIn());
        invoiceAddressDo.setUpdateOperId(reqBo.getUserIdIn());
        invoiceAddressDo.setExtField1(reqBo.getExtField1());
        invoiceAddressDo.setExtField2(reqBo.getExtField2());
        invoiceAddressDo.setExtField3(reqBo.getExtField3());
        invoiceAddressDo.setExtField4(reqBo.getExtField4());
        this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        return rspBo;
    }

    private List<UmcInvoiceAddressDo> qryAddrByAccountId(Long accountId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private List<UmcInvoiceAddressDo> qryAddrByOrgId(Long orgId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setOrgId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("0");
        UmcInvoiceAddressListRspBo umcInvoiceAddressListRspBo = this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
        return umcInvoiceAddressListRspBo.getRows();
    }

    private void cancleMainFlagAddr(List<UmcInvoiceAddressDo> invoiceAddressDoList) {
        UmcInvoiceAddressDo invoiceAddressDo = new UmcInvoiceAddressDo();
        List collect = invoiceAddressDoList.stream().map(UmcInvoiceAddressDo::getInvoiceAddrId).collect(Collectors.toList());
        for (Long id : collect) {
            invoiceAddressDo.setInvoiceAddrId(id);
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        }
    }

    private void validationParams(LdUmcInvoiceAddressUpdateReqBo reqBo) {
        String msgHead = " \u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u670d\u52a1\u5165\u53c2";
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("200001", msgHead + "\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.InvAddrMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.InvAddrMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("200001", msgHead + "\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u53ea\u80fd\u4e3a0\u62161");
        }
        if (null == reqBo.getInvoiceAddrId()) {
            throw new BaseBusinessException("200001", msgHead + "\u4e3b\u952eID[id]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

