/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.parkInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.service.parkInfo.UmcCreateParkInfoBatchService;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcCreateParkInfoBatchReqBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcCreateParkInfoBatchRspBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcParkInfoBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.parkInfo.UmcCreateParkInfoBatchService"})
public class UmcCreateParkInfoBatchServiceImpl
implements UmcCreateParkInfoBatchService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreateParkInfoBatchServiceImpl.class);
    @Autowired
    private IUmcParkInfoModel iUmcParkInfoModel;

    @PostMapping(value={"createParkInfoBatch"})
    public UmcCreateParkInfoBatchRspBo createParkInfoBatch(@RequestBody UmcCreateParkInfoBatchReqBo reqBo) {
        UmcCreateParkInfoBatchRspBo rspBo = (UmcCreateParkInfoBatchRspBo)UmcRu.success(UmcCreateParkInfoBatchRspBo.class);
        this.validateArg(reqBo);
        List umcParkInfoBos = reqBo.getUmcParkInfoBos();
        ArrayList<UmcParkInfoSubBo> umcParkInfoSubBos = new ArrayList<UmcParkInfoSubBo>(umcParkInfoBos.size());
        for (UmcParkInfoBo each : umcParkInfoBos) {
            UmcParkInfoSubBo umcParkInfoSubBo = (UmcParkInfoSubBo)UmcRu.js((Object)each, UmcParkInfoSubBo.class);
            umcParkInfoSubBo.setParkId(IdUtil.nextId());
            umcParkInfoSubBo.setCreatedTime(new Date());
            umcParkInfoSubBo.setCreatedId(reqBo.getUserId());
            umcParkInfoSubBo.setCreatedName(reqBo.getUserName());
            umcParkInfoSubBo.setParkType("1");
            umcParkInfoSubBos.add(umcParkInfoSubBo);
        }
        try {
            this.iUmcParkInfoModel.createParkInfoBatch(umcParkInfoSubBos);
        }
        catch (Exception e) {
            log.debug("\u6279\u91cf\u56ed\u533a\u4fe1\u606f\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u6279\u91cf\u56ed\u533a\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        return rspBo;
    }

    private void validateArg(UmcCreateParkInfoBatchReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcParkInfoBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[umcParkInfoBos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

