/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.parkInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.service.parkInfo.UmcDeleteParkInfoService;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcDeleteParkInfoReqBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcDeleteParkInfoRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.parkInfo.UmcDeleteParkInfoService"})
public class UmcDeleteParkInfoServiceImpl
implements UmcDeleteParkInfoService {
    private static final Logger log = LoggerFactory.getLogger(UmcDeleteParkInfoServiceImpl.class);
    @Autowired
    private IUmcParkInfoModel iUmcParkInfoModel;

    @PostMapping(value={"deleteParkInfo"})
    public UmcDeleteParkInfoRspBo deleteParkInfo(@RequestBody UmcDeleteParkInfoReqBo reqBo) {
        UmcDeleteParkInfoRspBo rspBo = (UmcDeleteParkInfoRspBo)UmcRu.success(UmcDeleteParkInfoRspBo.class);
        this.validateArg(reqBo);
        if (this.checkIsDelete(reqBo, rspBo)) {
            return rspBo;
        }
        this.deleteMethod(reqBo);
        return rspBo;
    }

    private void deleteMethod(UmcDeleteParkInfoReqBo reqBo) {
        try {
            UmcParkInfoQryBo umcParkInfoQryBo = new UmcParkInfoQryBo();
            umcParkInfoQryBo.setParkIds(reqBo.getParkIds());
            int n = this.iUmcParkInfoModel.deleteParkInfo(umcParkInfoQryBo);
        }
        catch (Exception e) {
            log.debug("\u56ed\u533a\u4fe1\u606f\u5220\u9664\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u56ed\u533a\u4fe1\u606f\u5220\u9664\u5931\u8d25");
        }
    }

    private boolean checkIsDelete(UmcDeleteParkInfoReqBo reqBo, UmcDeleteParkInfoRspBo rspBo) {
        UmcParkInfoQryBo umcParkInfoQryBo = new UmcParkInfoQryBo();
        umcParkInfoQryBo.setParkIds(reqBo.getParkIds());
        List<UmcParkInfoSubBo> umcParkInfoSubBos = this.iUmcParkInfoModel.qryParkAndOrgCountInfo(umcParkInfoQryBo);
        if (CollectionUtils.isEmpty(umcParkInfoSubBos)) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u8981\u5220\u9664\u7684\u6570\u636e!");
        }
        ArrayList<String> parkNames = new ArrayList<String>();
        for (UmcParkInfoSubBo each : umcParkInfoSubBos) {
            if (each.getOrgCount() <= 0L) continue;
            parkNames.add(each.getParkName());
        }
        rspBo.setIsSuccess(Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty(parkNames)) {
            rspBo.setIsSuccess(Boolean.valueOf(false));
            rspBo.setParkNames(parkNames);
            return true;
        }
        return false;
    }

    private void validateArg(UmcDeleteParkInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getParkIds())) {
            throw new BaseBusinessException("100001", "\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e!");
        }
    }
}

