/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.parkInfo;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.parkInfo.UmcGetParkInfoDetailService;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcGetParkInfoDetailReqBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcGetParkInfoDetailRspBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcParkInfoBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.parkInfo.UmcGetParkInfoDetailService"})
public class UmcGetParkInfoDetailServiceImpl
implements UmcGetParkInfoDetailService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetParkInfoDetailServiceImpl.class);
    @Autowired
    private IUmcParkInfoModel iUmcParkInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"getParkInfoDetail"})
    public UmcGetParkInfoDetailRspBo getParkInfoDetail(@RequestBody UmcGetParkInfoDetailReqBo reqBo) {
        UmcGetParkInfoDetailRspBo rspBo = (UmcGetParkInfoDetailRspBo)UmcRu.success(UmcGetParkInfoDetailRspBo.class);
        this.validateArg(reqBo);
        UmcParkInfoQryBo umcParkInfoQryBo = (UmcParkInfoQryBo)((Object)UmcRu.js((Object)reqBo, UmcParkInfoQryBo.class));
        UmcParkInfoSubBo umcParkInfoSubBo = this.iUmcParkInfoModel.getParkInfoDetail(umcParkInfoQryBo);
        if (umcParkInfoSubBo == null) {
            throw new BaseBusinessException("100001", "\u6ca1\u6709\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u56ed\u533a\u4fe1\u606f");
        }
        UmcParkInfoBo umcParkInfoBo = (UmcParkInfoBo)UmcRu.js((Object)umcParkInfoSubBo, UmcParkInfoBo.class);
        umcParkInfoBo.setBelongCityStr(umcParkInfoSubBo.getProvinceName() + "/" + umcParkInfoSubBo.getCityName());
        if (StringUtils.isNotBlank((String)umcParkInfoBo.getBelongRegion())) {
            Map belongRegionMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "umc_region")).getMap();
            umcParkInfoBo.setBelongRegionStr((String)belongRegionMap.get(umcParkInfoBo.getBelongRegion()));
        }
        rspBo.setUmcParkInfoBo(umcParkInfoBo);
        return rspBo;
    }

    private void validateArg(UmcGetParkInfoDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getParkId() == null) {
            throw new BaseBusinessException("100001", "\u56ed\u533a\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

