/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.parkInfo;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.parkInfo.IUmcParkInfoModel;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.service.parkInfo.UmcGetParkInfoListService;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcGetParkInfoListReqBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcGetParkInfoListRspBo;
import com.tydic.dyc.umc.service.parkInfo.bo.UmcParkInfoBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.parkInfo.UmcGetParkInfoListService"})
public class UmcGetParkInfoListServiceImpl
implements UmcGetParkInfoListService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetParkInfoListServiceImpl.class);
    @Value(value="#{'${UMC_PARK_AUTONOMOUS_REGIONS:\u5185\u8499\u53e4\u81ea\u6cbb\u533a,\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a,\u897f\u85cf\u81ea\u6cbb\u533a,\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a,\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a}'.split(',')}")
    private List<String> UMC_PARK_AUTONOMOUS_REGIONS;
    @Value(value="#{'${UMC_PARK_SPECIAL_ADMINISTRATIVE_REGIONS:\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a,\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a}'.split(',')}")
    private List<String> UMC_PARK_SPECIAL_ADMINISTRATIVE_REGIONS;
    @Value(value="#{'${UMC_PARK_URBAN_DISTRICTS:\u5317\u4eac\u5e02,\u5929\u6d25\u5e02,\u4e0a\u6d77\u5e02,\u91cd\u5e86\u5e02}'.split(',')}")
    private List<String> UMC_PARK_URBAN_DISTRICTS;
    @Autowired
    private IUmcParkInfoModel iUmcParkInfoModel;
    @Autowired
    private IUmcSysDicDictionaryModel iUmcSysDicDictionaryModel;

    @PostMapping(value={"getParkInfoList"})
    public UmcGetParkInfoListRspBo getParkInfoList(@RequestBody UmcGetParkInfoListReqBo reqBo) {
        UmcGetParkInfoListRspBo rspBo = (UmcGetParkInfoListRspBo)UmcRu.success(UmcGetParkInfoListRspBo.class);
        UmcParkInfoQryBo umcParkInfoQryBo = (UmcParkInfoQryBo)((Object)UmcRu.js((Object)reqBo, UmcParkInfoQryBo.class));
        BasePageRspBo<UmcParkInfoSubBo> umcParkInfoSubBos = this.iUmcParkInfoModel.getParkInfoList(umcParkInfoQryBo);
        if (umcParkInfoSubBos.getRows() == null || umcParkInfoSubBos.getRows().size() < 1) {
            rspBo.setPageNo(0);
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            return rspBo;
        }
        List jsl = UmcRu.jsl((List)umcParkInfoSubBos.getRows(), UmcParkInfoBo.class);
        for (UmcParkInfoBo each : jsl) {
            if (StringUtils.isNotBlank((String)each.getProvinceName())) {
                String belongCityStr = each.getProvinceName();
                if ("\u53f0\u6e7e".equals(each.getProvinceName())) {
                    belongCityStr = belongCityStr + "\u4e2d\u56fd\u53f0\u6e7e";
                } else {
                    this.UMC_PARK_AUTONOMOUS_REGIONS.addAll(this.UMC_PARK_URBAN_DISTRICTS);
                    List filteredList = this.UMC_PARK_AUTONOMOUS_REGIONS.stream().filter(element -> element.contains(each.getProvinceName())).collect(Collectors.toList());
                    belongCityStr = !CollectionUtils.isEmpty(filteredList) ? (String)filteredList.get(0) + each.getCityName() : ("\u6e2f\u6fb3".equals(each.getProvinceName()) ? ("\u4e2d\u56fd\u9999\u6e2f".equals(each.getCityName()) ? "\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a" : "\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a") : each.getProvinceName() + "\u7701" + each.getCityName());
                }
                each.setBelongCityStr(belongCityStr);
            }
            if (!StringUtils.isNotBlank((String)each.getBelongRegion())) continue;
            Map belongRegionMap = this.iUmcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC_PLUS", "umc_region")).getMap();
            each.setBelongRegionStr((String)belongRegionMap.get(each.getBelongRegion()));
        }
        rspBo.setRows(jsl);
        rspBo.setPageNo(umcParkInfoSubBos.getPageNo());
        rspBo.setTotal(umcParkInfoSubBos.getTotal());
        rspBo.setRecordsTotal(umcParkInfoSubBos.getRecordsTotal());
        rspBo.setRespCode(umcParkInfoSubBos.getRespCode());
        rspBo.setRespDesc(umcParkInfoSubBos.getRespDesc());
        return rspBo;
    }
}

