/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcGetCurrentPurchaseLimitService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetCurrentPurchaseLimitReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetCurrentPurchaseLimitRspBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcPurchaseLimitBo;
import com.tydic.dyc.umc.utils.MoneyUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcGetCurrentPurchaseLimitService"})
public class UmcGetCurrentPurchaseLimitServiceImpl
implements UmcGetCurrentPurchaseLimitService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetCurrentPurchaseLimitServiceImpl.class);
    private static final String TAKE_EFFECT = "0";
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"getCurrentPurchaseLimit"})
    public UmcGetCurrentPurchaseLimitRspBo getCurrentPurchaseLimit(@RequestBody UmcGetCurrentPurchaseLimitReqBo reqBo) {
        UmcGetCurrentPurchaseLimitRspBo rspBo = (UmcGetCurrentPurchaseLimitRspBo)UmcRu.success(UmcGetCurrentPurchaseLimitRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
        if ("P1".equals(reqBo.getLimitObjType())) {
            qryBo.setLimitObjCode(reqBo.getLimitObjCode());
            qryBo.setLimitObjType("P1");
        } else {
            qryBo.setLimitObjType("E1");
            qryBo.setLimitObjCode(reqBo.getLimitObjCode());
        }
        qryBo.setDelFlag(TAKE_EFFECT);
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u5bf9\u8c61\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f");
        }
        String redisKey = "UMC_PURCHASE_LIMIT_" + rspDo.getLimitObjType() + "_" + rspDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        if (currenNum == 0L) {
            this.cacheClient.incrBy(redisKey, MoneyUtil.bigDecimal2Long(rspDo.getPurchaseAmount()).longValue());
        }
        UmcPurchaseLimitBo limitBo = (UmcPurchaseLimitBo)UmcRu.js((Object)rspDo, UmcPurchaseLimitBo.class);
        rspBo.setPurchaseLimitBo(limitBo);
        return rspBo;
    }

    private void validateArg(UmcGetCurrentPurchaseLimitReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcGetPurchaseLimitCartDetailReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getLimitObjCode() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitObjCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getLimitObjType() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitObjType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

