/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcGetLimitAmountService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetLimitAmountReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetLimitAmountRspBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcPurchaseLimitBo;
import com.tydic.dyc.umc.utils.MoneyUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcGetLimitAmountService"})
public class UmcGetLimitAmountServiceImpl
implements UmcGetLimitAmountService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetLimitAmountServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"getLimitAmount"})
    public UmcGetLimitAmountRspBo getLimitAmount(@RequestBody UmcGetLimitAmountReqBo reqBo) {
        UmcGetLimitAmountRspBo rspBo = (UmcGetLimitAmountRspBo)UmcRu.success(UmcGetLimitAmountRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
        if ("P1".equals(reqBo.getLimitObjType())) {
            qryBo.setLimitObjType("P1");
        } else {
            qryBo.setLimitObjType("E1");
        }
        qryBo.setLimitObjTreePath(reqBo.getLimitObjTreePath());
        qryBo.setCurrentTime(reqBo.getCurrentTime());
        qryBo.setLimitObjCodes(reqBo.getLimitObjCodes());
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getLimitAmount(qryBo);
        String redisKey = "UMC_PURCHASE_LIMIT_" + qryBo.getLimitObjType() + "_" + rspDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        if (currenNum == 0L) {
            this.cacheClient.incrBy(redisKey, MoneyUtil.bigDecimal2Long(rspDo.getPurchaseAmount()).longValue());
        }
        UmcPurchaseLimitBo limitBo = (UmcPurchaseLimitBo)UmcRu.js((Object)rspDo, UmcPurchaseLimitBo.class);
        rspBo.setPurchaseLimitBo(limitBo);
        return rspBo;
    }

    private void validateArg(UmcGetLimitAmountReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcGetLimitAmountReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getLimitObjType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitObjType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getLimitObjTreePath())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitObjTreePath]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

