/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcGetPurchaseLimitPageListService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetPurchaseLimitPageListReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcGetPurchaseLimitPageListRspBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcPurchaseLimitBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcGetPurchaseLimitPageListService"})
public class UmcGetPurchaseLimitPageListServiceImpl
implements UmcGetPurchaseLimitPageListService {
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"getPurchaseLimitPageList"})
    public UmcGetPurchaseLimitPageListRspBo getPurchaseLimitPageList(@RequestBody UmcGetPurchaseLimitPageListReqBo reqBo) {
        UmcGetPurchaseLimitPageListRspBo rspBo = (UmcGetPurchaseLimitPageListRspBo)UmcRu.success(UmcGetPurchaseLimitPageListRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitQryBo configQryBo = this.buildDoByBO(reqBo);
        BasePageRspBo<UmcPurchaseLimitSubDo> rspSubDo = this.iUmcPurchaseLimitModel.getPurchaseLimitPageList(configQryBo);
        int sort = 1;
        for (UmcPurchaseLimitSubDo row : rspSubDo.getRows()) {
            this.changeRows(row);
            row.setSort(sort);
            ++sort;
        }
        rspBo.setRows(UmcRu.jsl((List)rspSubDo.getRows(), UmcPurchaseLimitBo.class));
        rspBo.setPageNo(rspSubDo.getPageNo());
        rspBo.setTotal(rspSubDo.getTotal());
        rspBo.setRecordsTotal(rspSubDo.getRecordsTotal());
        rspBo.setRespCode(rspSubDo.getRespCode());
        rspBo.setRespDesc(rspSubDo.getRespDesc());
        return rspBo;
    }

    private void changeRows(UmcPurchaseLimitSubDo row) {
        if ("E1".equals(row.getLimitObjType())) {
            row.setLimitObjTypeStr("\u90e8\u95e8");
            row.setIsExternalUser("2");
            row.setIsExternalUserStr("\u5426");
        } else if ("P1".equals(row.getLimitObjType())) {
            row.setIsExternalUser("2");
            row.setIsExternalUserStr("\u5426");
            row.setLimitObjTypeStr("\u9879\u76ee");
        } else if ("EXT".equals(row.getLimitObjType())) {
            row.setIsExternalUser("1");
            row.setIsExternalUserStr("\u662f");
            row.setLimitObjTypeStr("\u5916\u90e8\u5355\u4f4d");
        }
        if ("1".equals(row.getIsLimit())) {
            row.setIsLimitStr("\u662f");
        } else {
            row.setIsLimitStr("\u5426");
        }
        if ("month".equals(row.getLimitType())) {
            row.setLimitTypeStr("\u6708\u5ea6");
        } else if ("season".equals(row.getLimitType())) {
            row.setLimitTypeStr("\u5b63\u5ea6");
        } else if ("year".equals(row.getLimitType())) {
            row.setLimitTypeStr("\u5e74\u5ea6");
        } else if ("once".equals(row.getLimitType())) {
            row.setLimitTypeStr("\u4e00\u6b21\u6027");
        }
        if ("1".equals(row.getLimitStatus())) {
            row.setLimitStatusStr("\u5df2\u542f\u7528");
        } else {
            row.setLimitStatusStr("\u5df2\u505c\u7528");
        }
        if ("0".equals(row.getIsAccumulation())) {
            row.setIsAccumulationStr("\u5426");
        } else {
            row.setIsAccumulationStr("\u662f");
        }
        row.setAccumulationAmount(this.convertBigDecimal(row.getAccumulationAmount()));
        row.setLeftPurchaseAmount(this.convertBigDecimal(row.getLeftPurchaseAmount()));
        row.setLimitAmount(this.convertBigDecimal(row.getLimitAmount()));
        row.setPurchaseAmount(this.convertBigDecimal(row.getPurchaseAmount()));
        row.setSumLimitAmount(this.convertBigDecimal(row.getSumLimitAmount()));
        row.setLimitTemporary(this.convertBigDecimal(row.getLimitTemporary()));
    }

    private BigDecimal convertBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        bigDecimal = "0E-8".equals(bigDecimal.toString()) ? new BigDecimal(0).setScale(2, RoundingMode.HALF_UP) : bigDecimal.setScale(2, RoundingMode.HALF_UP);
        return bigDecimal;
    }

    private UmcPurchaseLimitQryBo buildDoByBO(UmcGetPurchaseLimitPageListReqBo reqBo) {
        UmcPurchaseLimitQryBo reqDo = (UmcPurchaseLimitQryBo)((Object)UmcRu.js((Object)reqBo, UmcPurchaseLimitQryBo.class));
        ArrayList<String> limitObjTypes = new ArrayList<String>();
        limitObjTypes.add("E1");
        limitObjTypes.add("P1");
        reqDo.setLimitObjTypes(limitObjTypes);
        return reqDo;
    }

    private void validateArg(UmcGetPurchaseLimitPageListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcGetPurchaseLimitHisPageListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

