/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitHisQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.costControl.bo.UmcOperateCostPurchaseLimitMqReqBo;
import com.tydic.dyc.umc.service.purchaselimit.UmcPriceAdjustmentPurchaseLimitService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcPriceAdjustmentPurchaseLimitReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcPriceAdjustmentPurchaseLimitRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.MoneyUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcPriceAdjustmentPurchaseLimitService"})
public class UmcPriceAdjustmentPurchaseLimitServiceImpl
implements UmcPriceAdjustmentPurchaseLimitService {
    private static final Logger log = LoggerFactory.getLogger(UmcPriceAdjustmentPurchaseLimitServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${UMC_PURCHASE_LIMIT_MESSAGE_TOPIC:UMC_PURCHASE_LIMIT_MESSAGE_TOPIC}")
    private String umcCreateTopic;
    @Value(value="${UMC_ERP_MESSAGE_TAG:*}")
    private String umcCreateTag;
    @Resource(name="umcPurchaseLimitMessageProvider")
    private ProxyMessageProducer proxyMessageProducer;

    @PostMapping(value={"operatePriceAdjustmentPurchaseLimit"})
    public UmcPriceAdjustmentPurchaseLimitRspBo operatePriceAdjustmentPurchaseLimit(@RequestBody UmcPriceAdjustmentPurchaseLimitReqBo reqBo) {
        this.validateArg(reqBo);
        UmcPurchaseLimitHisQryBo purchaseLimitHisQryBo = new UmcPurchaseLimitHisQryBo();
        purchaseLimitHisQryBo.setExtField1(String.valueOf(reqBo.getOrderId()));
        purchaseLimitHisQryBo.setDelFlag(null);
        BasePageRspBo<UmcPurchaseLimitHisSubDo> purchaseLimitHisPageList = this.iUmcPurchaseLimitModel.getPurchaseLimitHisList(purchaseLimitHisQryBo);
        if (!CollectionUtils.isEmpty((Collection)purchaseLimitHisPageList.getRows())) {
            UmcPurchaseLimitHisSubDo deductDo = new UmcPurchaseLimitHisSubDo();
            List purchaseLimitHisSubDos = purchaseLimitHisPageList.getRows().stream().filter(o -> "deduct".equalsIgnoreCase(o.getChngType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(purchaseLimitHisSubDos)) {
                List limitHisSubDos = purchaseLimitHisPageList.getRows().stream().filter(o -> "notLimitDeduct".equalsIgnoreCase(o.getChngType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(limitHisSubDos)) {
                    log.info("\u8ba2\u5355orderId:{} \u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u9650\u989d\u6263\u51cf\u8bb0\u5f55", (Object)reqBo.getOrderId());
                    throw new BaseBusinessException("100001", "\u975e\u5e38\u62b1\u6b49\uff0c\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u4e0b\u5355\u65f6\u7684\u91c7\u8d2d\u9650\u989d\u6263\u51cf\u8bb0\u5f55\uff0c\u65e0\u6cd5\u8fdb\u884c\u8c03\u4ef7\u6263\u51cf\uff01");
                }
                deductDo = (UmcPurchaseLimitHisSubDo)limitHisSubDos.get(0);
            } else {
                deductDo = (UmcPurchaseLimitHisSubDo)purchaseLimitHisSubDos.get(0);
            }
            if ("1".equals(deductDo.getExtField3())) {
                UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo = new UmcOperateCostPurchaseLimitMqReqBo();
                limitMqReqBo.setUniKey(Long.valueOf(IdUtil.nextId()));
                limitMqReqBo.setOrderCode(String.valueOf(reqBo.getOrderId()));
                limitMqReqBo.setOperateType("orderPriceAdjust");
                limitMqReqBo.setOperateId(reqBo.getOperateId());
                limitMqReqBo.setOperateName(reqBo.getOperateName());
                UmcPurchaseLimitAmountSubDo limitAmountSubDo = new UmcPurchaseLimitAmountSubDo();
                UmcPurchaseLimitAmountQryBo purchaseLimitAmountQryBo = new UmcPurchaseLimitAmountQryBo();
                purchaseLimitAmountQryBo.setLimitConfigId(deductDo.getLimitConfigId());
                purchaseLimitAmountQryBo.setDelFlag(null);
                purchaseLimitAmountQryBo.setOrderBy("a.create_time desc");
                purchaseLimitAmountQryBo.setCurrentTime(new Date());
                purchaseLimitAmountQryBo.setLimitEffTimeEnd(new Date());
                purchaseLimitAmountQryBo.setLimitExpTimeStart(new Date());
                BasePageRspBo<UmcPurchaseLimitAmountSubDo> purchaseLimitAmountPageList = this.iUmcPurchaseLimitModel.getPurchaseLimitAmountPageList(purchaseLimitAmountQryBo);
                if (!CollectionUtils.isEmpty((Collection)purchaseLimitAmountPageList.getRows())) {
                    limitAmountSubDo = (UmcPurchaseLimitAmountSubDo)purchaseLimitAmountPageList.getRows().get(0);
                    if (deductDo.getValId().equals(limitAmountSubDo.getValId())) {
                        limitMqReqBo.setIsNowAmountConfig("1");
                    } else {
                        limitMqReqBo.setIsNowAmountConfig("0");
                    }
                }
                BigDecimal oldOrderTotoalPrice = deductDo.getChngPurchaseAmount().abs();
                BigDecimal newOrderTotalPrice = reqBo.getAdjustOrderTotalPrice();
                BigDecimal subtract = newOrderTotalPrice.subtract(oldOrderTotoalPrice);
                if ("0".equals(deductDo.getIsAccumulation())) {
                    UmcPurchaseLimitQryBo purchaseLimitQryBo = new UmcPurchaseLimitQryBo();
                    purchaseLimitQryBo.setValId(deductDo.getValId());
                    purchaseLimitQryBo.setDelFlag(null);
                    UmcPurchaseLimitSubDo purchaseLimitModelLimitAmount = this.iUmcPurchaseLimitModel.getLimitAmount(purchaseLimitQryBo);
                    if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                        if (subtract.compareTo(purchaseLimitModelLimitAmount.getLeftPurchaseAmount()) > 0) {
                            log.info("\u8c03\u4ef7\u8ba2\u5355orderId\uff1a{} \u989d\u5ea6\u6263\u9664\u5931\u8d25\uff08\u8d85\u989d\uff09\uff0c\u5e94\u6263\u989d\u5ea6\uff1a{}\uff0c\u5269\u4f59\u989d\u5ea6\uff1a{}\uff0c\u91c7\u8d2d\u9650\u989d\u914d\u7f6eValId\uff1a{}", new Object[]{reqBo.getOrderId(), subtract, purchaseLimitModelLimitAmount.getLeftPurchaseAmount(), deductDo.getValId()});
                            throw new BaseBusinessException("100001", "\u975e\u5e38\u62b1\u6b49\uff0c\u8c03\u4ef7\u540e\u8ba2\u5355\u91d1\u989d\u8d85\u8fc7\u60a8\u7684\u6388\u4fe1\u989d\u5ea6\uff0c\u8bf7\u63d0\u5347\u989d\u5ea6\u540e\u8fdb\u884c\u8c03\u4ef7\u3002");
                        }
                    } else if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                        // empty if block
                    }
                    this.dealPurchaseLimitRedis(limitMqReqBo, deductDo, purchaseLimitModelLimitAmount.getDelFlag(), deductDo.getValId(), subtract);
                } else {
                    if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal usabletPurchaseAmount = limitAmountSubDo.getAccumulationAmount().add(limitAmountSubDo.getLimitAmount()).subtract(limitAmountSubDo.getPurchaseAmount());
                        if (subtract.compareTo(usabletPurchaseAmount) > 0) {
                            log.info("\u8c03\u4ef7\u8ba2\u5355ordeerId\uff1a{} \u989d\u5ea6\u6263\u9664\u5931\u8d25\uff08\u8d85\u989d\uff09\uff0c\u5e94\u6263\u989d\u5ea6\uff1a{}\uff0c\u5269\u4f59\u989d\u5ea6\uff1a{}\uff0c\u91c7\u8d2d\u9650\u989d\u914d\u7f6eValId\uff1a{}", new Object[]{reqBo.getOrderId(), subtract, usabletPurchaseAmount, limitAmountSubDo.getValId()});
                            throw new BaseBusinessException("100001", "\u975e\u5e38\u62b1\u6b49\uff0c\u8c03\u4ef7\u540e\u8ba2\u5355\u91d1\u989d\u8d85\u8fc7\u60a8\u7684\u6388\u4fe1\u989d\u5ea6\uff0c\u8bf7\u63d0\u5347\u989d\u5ea6\u540e\u8fdb\u884c\u8c03\u4ef7\u3002");
                        }
                    } else if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                        // empty if block
                    }
                    this.dealPurchaseLimitRedis(limitMqReqBo, deductDo, limitAmountSubDo.getDelFlag(), limitAmountSubDo.getValId(), subtract);
                }
                this.sendMassage(limitMqReqBo);
            } else {
                log.info("\u8ba2\u5355orderId:{} \u4e0d\u53d7\u91c7\u8d2d\u9650\u989d\u7ba1\u63a7", (Object)reqBo.getOrderId());
            }
        } else {
            log.info("\u8ba2\u5355orderId:{} \u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u9650\u989d\u6263\u51cf\u8bb0\u5f55", (Object)reqBo.getOrderId());
            throw new BaseBusinessException("100001", "\u975e\u5e38\u62b1\u6b49\uff0c\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u4e0b\u5355\u65f6\u7684\u91c7\u8d2d\u9650\u989d\u6263\u51cf\u8bb0\u5f55\uff0c\u65e0\u6cd5\u8fdb\u884c\u8c03\u4ef7\u6263\u51cf\uff01");
        }
        UmcPriceAdjustmentPurchaseLimitRspBo rspBO = new UmcPriceAdjustmentPurchaseLimitRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void validateArg(UmcPriceAdjustmentPurchaseLimitReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcAfterSaleReturnCostPurchaseLimitReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAdjustOrderTotalPrice()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8c03\u4ef7\u540e\u8ba2\u5355\u603b\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BigDecimal.ZERO.compareTo(reqBo.getAdjustOrderTotalPrice()) > 0) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8c03\u4ef7\u540e\u8ba2\u5355\u603b\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (null == reqBo.getOperateId() || 0L == reqBo.getOperateId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getOperateName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void sendMassage(UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo) {
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)limitMqReqBo));
        ProxyMessage proxyMessage = new ProxyMessage(this.umcCreateTopic, this.umcCreateTag, JSON.toJSONString((Object)limitMqReqBo));
        ProxySendResult result = this.proxyMessageProducer.send(proxyMessage);
        log.info("\u53d1\u6d88\u606f\u66f4\u65b0\u6210\u672c\u548c\u91c7\u8d2d\u4fe1\u606f\u5b8c\u6210\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)result));
    }

    private void dealPurchaseLimitRedis(UmcOperateCostPurchaseLimitMqReqBo limitMqReqBo, UmcPurchaseLimitHisSubDo purchaseLimitHisSubDo, String delFlag2, Long valId, BigDecimal backTotal) {
        if ("0".equals(delFlag2) && "1".equals(limitMqReqBo.getIsNowAmountConfig())) {
            String redisKey = "UMC_PURCHASE_LIMIT_" + purchaseLimitHisSubDo.getLimitObjType() + "_" + purchaseLimitHisSubDo.getLimitObjCode();
            this.cacheClient.incrBy(redisKey, MoneyUtil.bigDecimal2Long(backTotal).longValue());
        }
        limitMqReqBo.setPurchaseValId(valId);
        limitMqReqBo.setPurchaseAmount(backTotal);
    }
}

