/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.purchaselimit;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitAmountQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitConfigQryBo;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountConfigHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitHisSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.purchaselimit.UmcUpdatePurchaseLimitConfigService;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcUpdatePurchaseLimitConfigReqBo;
import com.tydic.dyc.umc.service.purchaselimit.bo.UmcUpdatePurchaseLimitConfigRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.purchaselimit.UmcUpdatePurchaseLimitConfigService"})
public class UmcUpdatePurchaseLimitConfigServiceImpl
implements UmcUpdatePurchaseLimitConfigService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdatePurchaseLimitConfigServiceImpl.class);
    public static final String REGULAR_AFTER_MONEY = "afterMoney";
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"updatePurchaseLimitConfig"})
    public UmcUpdatePurchaseLimitConfigRspBo updatePurchaseLimitConfig(@RequestBody UmcUpdatePurchaseLimitConfigReqBo reqBo) {
        UmcPurchaseLimitHisSubDo hisSubDo;
        UmcUpdatePurchaseLimitConfigRspBo rspBo = (UmcUpdatePurchaseLimitConfigRspBo)UmcRu.success(UmcUpdatePurchaseLimitConfigRspBo.class);
        this.validateArg(reqBo);
        UmcPurchaseLimitQryBo qryBo = new UmcPurchaseLimitQryBo();
        qryBo.setLimitConfigId(reqBo.getLimitConfigId());
        qryBo.setCurrentTime(new Date());
        StrUtil.noNullStringAttr((Object)((Object)qryBo));
        UmcPurchaseLimitSubDo rspDo = this.iUmcPurchaseLimitModel.getPurchaseLimitDetail(qryBo);
        this.validateLimit(reqBo, rspDo);
        IUmcPurchaseLimitDo reqDo = this.buildDoByBO(reqBo);
        UmcPurchaseLimitConfigQryBo configQryBo = new UmcPurchaseLimitConfigQryBo();
        configQryBo.setLimitConfigId(reqBo.getLimitConfigId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitConfig(reqDo, configQryBo);
        UmcPurchaseLimitAmountSubDo amountSubDo = this.buildAmountDo(reqDo);
        UmcPurchaseLimitAmountQryBo amountQryBo = new UmcPurchaseLimitAmountQryBo();
        amountQryBo.setValId(rspDo.getValId());
        this.iUmcPurchaseLimitModel.updatePurchaseLimitAmount(amountSubDo, amountQryBo);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(1);
        if (reqBo.getLimitAmount().compareTo(rspDo.getLimitAmount()) != 0) {
            hisSubDo = this.buildHisDo(amountSubDo, rspDo, "1", map);
            hisSubDo.setValId(amountQryBo.getValId());
            this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
        }
        if (reqBo.getLimitTemporary().compareTo(rspDo.getLimitTemporary()) != 0) {
            hisSubDo = this.buildHisDo(amountSubDo, rspDo, "2", map);
            hisSubDo.setValId(amountQryBo.getValId());
            this.iUmcPurchaseLimitModel.createPurchaseLimitHis(hisSubDo);
        }
        UmcPurchaseLimitAmountConfigHisSubDo configHisSubDo = this.buildConfigHisDo(rspDo, reqDo);
        this.iUmcPurchaseLimitModel.createPurchaseLimitConfigHis(configHisSubDo);
        return rspBo;
    }

    private void validateLimit(UmcUpdatePurchaseLimitConfigReqBo reqBo, UmcPurchaseLimitSubDo rspDo) {
        Calendar now = Calendar.getInstance();
        int month = now.get(2) + 1;
        log.info("\u521b\u5efa\u91c7\u8d2d\u9650\u989dmonth{}", (Object)month);
        boolean chngType = false;
        if (rspDo == null) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (rspDo.getLimitExpTime().compareTo(new Date()) < 0) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u5bf9\u8c61\u5df2\u8fc7\u671f");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getLimitType()) && !reqBo.getLimitType().equals(rspDo.getLimitType())) {
            chngType = true;
        }
        if (month != 12 && chngType) {
            throw new BaseBusinessException("100001", "\u9650\u5236\u7c7b\u884c\u53ea\u80fd\u572812\u6708\u4efd\u4fee\u6539");
        }
        BigDecimal addLimitAmount = reqBo.getLimitAmount().add(rspDo.getAccumulationAmount()).add(reqBo.getLimitTemporary());
        if (addLimitAmount.compareTo(rspDo.getPurchaseAmount()) < 0) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u9650\u989d\u540e\u7684\u53ef\u7528\u989d\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u91c7\u8d2d\u91d1\u989d");
        }
        String redisKey = "UMC_PURCHASE_LIMIT_" + rspDo.getLimitObjType() + "_" + rspDo.getLimitObjCode();
        Long currenNum = this.cacheClient.incrBy(redisKey, 0L);
        BigDecimal currentLimit = BigDecimal.ZERO;
        try {
            currentLimit = MoneyUtils.Long2BigDecimal((Long)currenNum);
        }
        catch (Exception e) {
            throw new BaseBusinessException("100001", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        if (addLimitAmount.compareTo(currentLimit) < 0) {
            throw new BaseBusinessException("100001", "\u4fee\u6539\u9650\u989d\u540e\u7684\u53ef\u7528\u989d\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u91c7\u8d2d\u91d1\u989d");
        }
    }

    private IUmcPurchaseLimitDo buildDoByBO(UmcUpdatePurchaseLimitConfigReqBo reqBo) {
        IUmcPurchaseLimitDo reqDo = new IUmcPurchaseLimitDo();
        reqDo.setIsLimit(reqBo.getIsLimit());
        reqDo.setLimitType(reqBo.getLimitType());
        reqDo.setIsAccumulation(reqBo.getIsAccumulation());
        reqDo.setLimitAmount(reqBo.getLimitAmount());
        reqDo.setUpdateOperId(reqBo.getUpdateOperId());
        reqDo.setUpdateOperName(reqBo.getUpdateOperName());
        reqDo.setUpdateTime(reqBo.getUpdateTime());
        reqDo.setExtField1(reqBo.getExtField1());
        reqDo.setExtField2(reqBo.getExtField2());
        reqDo.setExtField3(reqBo.getExtField3());
        reqDo.setExtField4(reqBo.getExtField4());
        reqDo.setExtField5(reqBo.getExtField5());
        reqDo.setExtField6(reqBo.getExtField6());
        reqDo.setExtField7(reqBo.getExtField7());
        reqDo.setExtField8(reqBo.getExtField8());
        reqDo.setExtField9(reqBo.getExtField9());
        reqDo.setExtField10(reqBo.getExtField10());
        reqDo.setLimitTemporary(reqBo.getLimitTemporary());
        return reqDo;
    }

    private UmcPurchaseLimitAmountSubDo buildAmountDo(IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountSubDo amountSubDo = new UmcPurchaseLimitAmountSubDo();
        amountSubDo.setLimitAmount(reqDo.getLimitAmount());
        amountSubDo.setUpdateOperId(reqDo.getUpdateOperId());
        amountSubDo.setUpdateOperName(reqDo.getUpdateOperName());
        amountSubDo.setUpdateTime(reqDo.getUpdateTime());
        amountSubDo.setCreateOperId(reqDo.getCreateOperId());
        amountSubDo.setCreateOperName(reqDo.getCreateOperName());
        amountSubDo.setIsAccumulation(reqDo.getIsAccumulation());
        amountSubDo.setLimitTemporary(reqDo.getLimitTemporary());
        return amountSubDo;
    }

    private UmcPurchaseLimitHisSubDo buildHisDo(UmcPurchaseLimitAmountSubDo reqDo, UmcPurchaseLimitSubDo rspDo, String limitOperType, HashMap<String, BigDecimal> map) {
        UmcPurchaseLimitHisSubDo hisSubDo = new UmcPurchaseLimitHisSubDo();
        hisSubDo.setChngType("modify");
        hisSubDo.setValId(rspDo.getValId());
        hisSubDo.setLimitConfigId(rspDo.getLimitConfigId());
        hisSubDo.setLimitYear(rspDo.getLimitYear());
        if (limitOperType.equals("1")) {
            hisSubDo.setChngRemark("\u4fee\u6539\u56fa\u5b9a\u989d\u5ea6");
            BigDecimal beforMoney = rspDo.getLimitAmount().add(rspDo.getAccumulationAmount()).add(rspDo.getLimitTemporary()).subtract(rspDo.getPurchaseAmount());
            BigDecimal afterMoney = reqDo.getLimitAmount().add(rspDo.getAccumulationAmount()).add(rspDo.getLimitTemporary()).subtract(rspDo.getPurchaseAmount());
            hisSubDo.setPurchaseAmountBefore(beforMoney);
            hisSubDo.setChngPurchaseAmount(afterMoney.subtract(beforMoney));
            hisSubDo.setPurchaseAmountAfter(afterMoney);
            map.put(REGULAR_AFTER_MONEY, afterMoney);
        } else {
            hisSubDo.setChngRemark("\u4fee\u6539\u4e34\u65f6\u989d\u5ea6");
            BigDecimal beforMoney = rspDo.getLimitAmount().add(rspDo.getAccumulationAmount()).add(rspDo.getLimitTemporary()).subtract(rspDo.getPurchaseAmount());
            if (!CollectionUtils.isEmpty(map) && map.get(REGULAR_AFTER_MONEY) != null) {
                beforMoney = map.get(REGULAR_AFTER_MONEY);
            }
            BigDecimal afterMoney = reqDo.getLimitAmount().add(rspDo.getAccumulationAmount()).add(reqDo.getLimitTemporary()).subtract(rspDo.getPurchaseAmount());
            hisSubDo.setPurchaseAmountBefore(beforMoney);
            hisSubDo.setChngPurchaseAmount(afterMoney.subtract(beforMoney));
            hisSubDo.setPurchaseAmountAfter(afterMoney);
        }
        hisSubDo.setCreateOperId(reqDo.getUpdateOperId());
        hisSubDo.setCreateOperName(reqDo.getUpdateOperName());
        hisSubDo.setCreateTime(new Date());
        hisSubDo.setHisId(IdUtil.nextId());
        return hisSubDo;
    }

    private void validateArg(UmcUpdatePurchaseLimitConfigReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UmcUpdatePurchaseLimitConfigReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getLimitConfigId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[LimitConfigId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UmcPurchaseLimitAmountConfigHisSubDo buildConfigHisDo(UmcPurchaseLimitSubDo rspDo, IUmcPurchaseLimitDo reqDo) {
        UmcPurchaseLimitAmountConfigHisSubDo configHisDo = new UmcPurchaseLimitAmountConfigHisSubDo();
        BeanUtils.copyProperties((Object)rspDo, (Object)configHisDo);
        configHisDo = (UmcPurchaseLimitAmountConfigHisSubDo)UmcRu.js((Object)reqDo, UmcPurchaseLimitAmountConfigHisSubDo.class);
        configHisDo.setLimitConfigHisId(IdUtil.nextId());
        configHisDo.setExtField1("\u4fee\u6539\u91c7\u8d2d\u9650\u989d");
        configHisDo.setLimitConfigId(rspDo.getLimitConfigId());
        configHisDo.setLimitObjType(rspDo.getLimitObjType());
        configHisDo.setLimitObjId(rspDo.getLimitObjId());
        configHisDo.setLimitObjCode(rspDo.getLimitObjCode());
        configHisDo.setLimitStatus(rspDo.getLimitStatus());
        configHisDo.setDelFlag(rspDo.getDelFlag());
        configHisDo.setLimitObjTreePath(rspDo.getLimitObjTreePath());
        configHisDo.setLimitObjName(rspDo.getLimitObjName());
        configHisDo.setIsLimit(reqDo.getIsLimit());
        configHisDo.setLimitType(rspDo.getLimitType());
        configHisDo.setIsAccumulation(reqDo.getIsAccumulation());
        configHisDo.setLimitAmount(reqDo.getLimitAmount());
        configHisDo.setCreateOperId(reqDo.getCreateOperId());
        return configHisDo;
    }
}

