/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.tempCredit;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitDo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcDepPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.model.tempCredit.IUmcTempCreditDo;
import com.tydic.dyc.umc.model.tempCredit.IUmcTempCreditModel;
import com.tydic.dyc.umc.model.tempCredit.qrybo.UmcTempCreditQryBo;
import com.tydic.dyc.umc.service.tempCredit.UmcAddTempCreditApplyService;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcAddTempCreditApplyReqBo;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcAddTempCreditApplyRspBo;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.tempCredit.UmcAddTempCreditApplyService"})
public class UmcAddTempCreditApplyServiceImpl
implements UmcAddTempCreditApplyService {
    private static final Logger log = LoggerFactory.getLogger(UmcAddTempCreditApplyServiceImpl.class);
    @Autowired
    private IUmcTempCreditModel iUmcTempCreditModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"addTempCreditApply"})
    public UmcAddTempCreditApplyRspBo addTempCreditApply(@RequestBody UmcAddTempCreditApplyReqBo reqBo) {
        log.debug("\u65b0\u589e\u4e34\u65f6\u989d\u5ea6\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        UmcAddTempCreditApplyRspBo rspBo = (UmcAddTempCreditApplyRspBo)UmcRu.success(UmcAddTempCreditApplyRspBo.class);
        this.validate(reqBo);
        UmcOrgInfoQryBo enterpriseOrgQryBo = new UmcOrgInfoQryBo();
        enterpriseOrgQryBo.setOrgId(reqBo.getCreditOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(enterpriseOrgQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("201006", "\u4f01\u4e1a\u8be6\u60c5\u67e5\u8be2\uff0c\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        IUmcTempCreditDo reqDo = (IUmcTempCreditDo)UmcRu.js((Object)reqBo, IUmcTempCreditDo.class);
        UmcTempCreditQryBo qryBo = new UmcTempCreditQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        BasePageRspBo<UmcTempCreditQryBo> tempCreditList = this.iUmcTempCreditModel.qryTempCreditPageList(qryBo);
        if (!CollectionUtils.isEmpty((Collection)tempCreditList.getRows())) {
            throw new BaseBusinessException("100001", "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728\u4e34\u65f6\u989d\u5ea6\u7533\u8bf7");
        }
        UmcDepPurchaseLimitQryBo qryLimitBo = new UmcDepPurchaseLimitQryBo();
        qryLimitBo.setLimitObjType("tmp");
        qryLimitBo.setLimitObjId(String.valueOf(reqBo.getCreditOrgId()));
        UmcPurchaseLimitSubDo LimitDo = this.iUmcPurchaseLimitModel.getCurrentPurchaseLimit(qryLimitBo);
        Date curentDate = new Date();
        if (LimitDo != null) {
            reqDo.setLimitConfigId(LimitDo.getLimitConfigId());
            IUmcPurchaseLimitDo configDo = new IUmcPurchaseLimitDo();
            configDo.setLimitConfigId(LimitDo.getLimitConfigId());
            configDo.setLimitAmount(reqBo.getTemporaryCreditLimit());
            configDo.setUpdateOperId(reqBo.getUserIdIn());
            configDo.setUpdateOperName(reqBo.getName());
            configDo.setUpdateTime(curentDate);
            this.iUmcPurchaseLimitModel.changeConfigAmountById(configDo);
            UmcPurchaseLimitAmountSubDo amountDo = new UmcPurchaseLimitAmountSubDo();
            amountDo.setValId(LimitDo.getValId());
            reqDo.setValId(LimitDo.getValId());
            amountDo.setLimitAmount(reqBo.getTemporaryCreditLimit());
            amountDo.setUpdateOperId(reqBo.getUserIdIn());
            amountDo.setUpdateOperName(reqBo.getName());
            amountDo.setUpdateTime(curentDate);
            this.iUmcPurchaseLimitModel.changeAmountById(amountDo);
        } else {
            IUmcPurchaseLimitDo configDo = new IUmcPurchaseLimitDo();
            configDo.setLimitConfigId(IdUtil.nextId());
            reqDo.setLimitConfigId(configDo.getLimitConfigId());
            configDo.setLimitObjType("tmp");
            configDo.setLimitObjId(String.valueOf(reqBo.getCreditOrgId()));
            configDo.setLimitObjCode(String.valueOf(reqBo.getCreditOrgId()));
            configDo.setLimitObjTreePath(orgInfo.getOrgTreePath());
            configDo.setLimitObjName(orgInfo.getOrgName());
            configDo.setIsLimit("1");
            configDo.setLimitType("once");
            configDo.setIsAccumulation("0");
            configDo.setLimitAmount(reqBo.getTemporaryCreditLimit());
            configDo.setLimitStatus("1");
            configDo.setDelFlag("0");
            configDo.setCreateOperId(reqBo.getUserIdIn());
            configDo.setCreateOperName(reqBo.getName());
            configDo.setCreateTime(curentDate);
            configDo.setUpdateOperId(reqBo.getUserIdIn());
            configDo.setUpdateOperName(reqBo.getName());
            configDo.setUpdateTime(curentDate);
            this.iUmcPurchaseLimitModel.createPurchaseLimitConfig(configDo);
            UmcPurchaseLimitAmountSubDo amountDo = new UmcPurchaseLimitAmountSubDo();
            amountDo.setValId(IdUtil.nextId());
            reqDo.setValId(amountDo.getValId());
            amountDo.setLimitConfigId(configDo.getLimitConfigId());
            amountDo.setLimitYear("0");
            amountDo.setLimitType("once");
            amountDo.setIsAccumulation("0");
            amountDo.setAccumulationAmount(BigDecimal.ZERO);
            amountDo.setLimitAmount(reqBo.getTemporaryCreditLimit());
            amountDo.setPurchaseAmount(BigDecimal.ZERO);
            amountDo.setLimitEffTime(curentDate);
            amountDo.setLimitEffTime(DateUtil.getCurrentYearStartTime());
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtil.getCurrentYearStartTime());
            cal.add(1, 50);
            amountDo.setLimitExpTime(cal.getTime());
            amountDo.setDelFlag("0");
            amountDo.setCreateOperId(reqBo.getUserIdIn());
            amountDo.setCreateOperName(reqBo.getName());
            amountDo.setCreateTime(curentDate);
            amountDo.setUpdateOperId(reqBo.getUserIdIn());
            amountDo.setUpdateOperName(reqBo.getName());
            amountDo.setUpdateTime(curentDate);
            this.iUmcPurchaseLimitModel.createPurchaseLimitAmount(amountDo);
        }
        reqDo.setCreditOrgName(orgInfo.getOrgName());
        reqDo.setTemporaryCreditId(reqBo.getOrderId());
        reqDo.setExtField1(reqBo.getOrgName());
        reqDo.setCreateOperId(reqBo.getUserIdIn());
        reqDo.setCreateOperName(reqBo.getName());
        reqDo.setCreateTime(curentDate);
        reqDo.setUpdateOperId(reqBo.getUserIdIn());
        reqDo.setUpdateOperName(reqBo.getName());
        reqDo.setUpdateTime(curentDate);
        this.iUmcTempCreditModel.createTempCredit(reqDo);
        rspBo.setApplyId(reqDo.getTemporaryCreditId());
        return rspBo;
    }

    private void validate(UmcAddTempCreditApplyReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreditOrgId() == null) {
            throw new BaseBusinessException("100001", "\u6388\u4fe1\u673a\u6784ID[creditOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTemporaryCreditLimit() == null) {
            throw new BaseBusinessException("100001", "\u4e34\u65f6\u989d\u5ea6[temporaryCreditLimit]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u4e34\u65f6\u989d\u5ea6[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

