/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.tempCredit;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitAmountSubDo;
import com.tydic.dyc.umc.model.tempCredit.IUmcTempCreditDo;
import com.tydic.dyc.umc.model.tempCredit.IUmcTempCreditModel;
import com.tydic.dyc.umc.model.tempCredit.qrybo.UmcTempCreditQryBo;
import com.tydic.dyc.umc.service.tempCredit.UmcConfirmTempCreditApplyService;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcConfirmTempCreditApplyReqBo;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcConfirmTempCreditApplyRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.tempCredit.UmcConfirmTempCreditApplyService"})
public class UmcConfirmTempCreditApplyServiceImpl
implements UmcConfirmTempCreditApplyService {
    private static final Logger log = LoggerFactory.getLogger(UmcConfirmTempCreditApplyServiceImpl.class);
    @Autowired
    private IUmcTempCreditModel iUmcTempCreditModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"confirmTempCreditApply"})
    public UmcConfirmTempCreditApplyRspBo confirmTempCreditApply(@RequestBody UmcConfirmTempCreditApplyReqBo reqBo) {
        log.debug("\u65b0\u589e\u4e34\u65f6\u989d\u5ea6\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        UmcConfirmTempCreditApplyRspBo rspBo = (UmcConfirmTempCreditApplyRspBo)UmcRu.success(UmcConfirmTempCreditApplyRspBo.class);
        this.validate(reqBo);
        UmcTempCreditQryBo detailBo = new UmcTempCreditQryBo();
        detailBo.setTemporaryCreditId(reqBo.getApplyId());
        UmcTempCreditQryBo qryBo = this.iUmcTempCreditModel.qryTempCreditDetail(detailBo);
        Date curentDate = new Date();
        if (qryBo != null) {
            if ("3".equals(reqBo.getApplyType()) && "1".equals(qryBo.getCreditState())) {
                if (qryBo.getTemporaryCreditLimit().compareTo(reqBo.getCancelAmount()) != 0) {
                    return rspBo;
                }
                UmcPurchaseLimitAmountSubDo amountDo = new UmcPurchaseLimitAmountSubDo();
                amountDo.setValId(qryBo.getValId());
                amountDo.setPurchaseAmount(qryBo.getTemporaryCreditLimit().multiply(new BigDecimal(-1)));
                amountDo.setUpdateOperId(reqBo.getUserIdIn());
                amountDo.setUpdateOperName(reqBo.getName());
                amountDo.setUpdateTime(curentDate);
                this.iUmcPurchaseLimitModel.changeAmountById(amountDo);
                IUmcTempCreditDo reqDo = new IUmcTempCreditDo();
                reqDo.setApplyType(reqBo.getApplyType());
                reqDo.setTemporaryCreditId(reqBo.getApplyId());
                reqDo.setApplyType(reqBo.getApplyType());
                reqDo.setUpdateOperId(reqBo.getUserIdIn());
                reqDo.setUpdateOperName(reqBo.getName());
                reqDo.setUpdateTime(curentDate);
                this.iUmcTempCreditModel.confirmTempCredit(reqDo);
            } else {
                if ("1".equals(reqBo.getApplyType())) {
                    UmcPurchaseLimitAmountSubDo amountDo = new UmcPurchaseLimitAmountSubDo();
                    amountDo.setValId(qryBo.getValId());
                    amountDo.setPurchaseAmount(qryBo.getTemporaryCreditLimit());
                    amountDo.setUpdateOperId(reqBo.getUserIdIn());
                    amountDo.setUpdateOperName(reqBo.getName());
                    amountDo.setUpdateTime(curentDate);
                    this.iUmcPurchaseLimitModel.changeAmountById(amountDo);
                }
                IUmcTempCreditDo reqDo = new IUmcTempCreditDo();
                reqDo.setTemporaryCreditId(reqBo.getApplyId());
                reqDo.setApplyType(reqBo.getApplyType());
                reqDo.setUpdateOperId(reqBo.getUserIdIn());
                reqDo.setUpdateOperName(reqBo.getName());
                reqDo.setUpdateTime(curentDate);
                this.iUmcTempCreditModel.confirmTempCredit(reqDo);
            }
        } else {
            throw new BaseBusinessException("100001", "\u4e34\u65f6\u989d\u5ea6\u4e0d\u5b58\u5728");
        }
        return rspBo;
    }

    private void validate(UmcConfirmTempCreditApplyReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyType() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applyType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

