/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.tempCredit;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.tempCredit.IUmcTempCreditModel;
import com.tydic.dyc.umc.model.tempCredit.qrybo.UmcTempCreditQryBo;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.tempCredit.UmcGetTempCreditDetailService;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcGetTempCreditDetailReqBo;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcGetTempCreditDetailRspBo;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcTempCreditDetailBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.tempCredit.UmcGetTempCreditDetailService"})
public class UmcGetTempCreditDetailServiceImpl
implements UmcGetTempCreditDetailService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetTempCreditDetailServiceImpl.class);
    @Autowired
    private IUmcTempCreditModel iUmcTempCreditModel;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    @PostMapping(value={"getTempCreditDetail"})
    public UmcGetTempCreditDetailRspBo getTempCreditDetail(@RequestBody UmcGetTempCreditDetailReqBo reqBo) {
        log.debug("\u65b0\u589e\u4e34\u65f6\u989d\u5ea6\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        UmcGetTempCreditDetailRspBo rspBo = (UmcGetTempCreditDetailRspBo)UmcRu.success(UmcGetTempCreditDetailRspBo.class);
        this.validate(reqBo);
        UmcTempCreditQryBo qryBo = new UmcTempCreditQryBo();
        qryBo.setTemporaryCreditId(reqBo.getTemporaryCreditId());
        UmcTempCreditQryBo rspDetailBo = this.iUmcTempCreditModel.qryTempCreditDetail(qryBo);
        if (rspDetailBo == null) {
            throw new BaseBusinessException("100001", "\u4e34\u65f6\u989d\u5ea6\u4e0d\u5b58\u5728");
        }
        UmcTempCreditDetailBo detailBo = (UmcTempCreditDetailBo)UmcRu.js((Object)((Object)rspDetailBo), UmcTempCreditDetailBo.class);
        this.translate(detailBo);
        detailBo.setCreateOrgName(detailBo.getExtField1());
        rspBo.setUmcTempCreditDetailBo(detailBo);
        return rspBo;
    }

    private void translate(UmcTempCreditDetailBo rspBO) {
        Map accountPeriodMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ACCOUNT_PERIOD_OLD");
        Map valleyMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_IS_VALLEY");
        Map natureMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ENTERPRISE_TYPE");
        Map stateMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_QRY_CREDIT_TEMP_STATE");
        if (!ObjectUtils.isEmpty((Object)rspBO)) {
            if (!MapUtils.isEmpty((Map)accountPeriodMap)) {
                rspBO.setAccountPeriodStr((String)accountPeriodMap.get(rspBO.getAccountPeriod()));
            }
            if (StringUtils.isBlank((CharSequence)rspBO.getAccountPeriodStr())) {
                rspBO.setAccountPeriodStr(rspBO.getAccountPeriod());
            }
            if (!MapUtils.isEmpty((Map)valleyMap)) {
                rspBO.setIsValleyStr((String)valleyMap.get(rspBO.getIsValley()));
            }
            if (!MapUtils.isEmpty((Map)natureMap)) {
                rspBO.setCustomerNatureStr((String)natureMap.get(rspBO.getCustomerNature()));
            }
            if (!MapUtils.isEmpty((Map)stateMap)) {
                rspBO.setCreditStateStr((String)stateMap.get(rspBO.getCreditState()));
            }
        }
    }

    private void validate(UmcGetTempCreditDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTemporaryCreditId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[temporaryCreditId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

