/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.tempCredit;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcDepPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.service.tempCredit.UmcGetTempCreditLimitService;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcGetTempCreditLimitReqBo;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcGetTempCreditLimitRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.tempCredit.UmcGetTempCreditLimitService"})
public class UmcGetTempCreditLimitServiceImpl
implements UmcGetTempCreditLimitService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetTempCreditLimitServiceImpl.class);
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;

    @PostMapping(value={"getTempCreditLimit"})
    public UmcGetTempCreditLimitRspBo getTempCreditLimit(@RequestBody UmcGetTempCreditLimitReqBo reqBo) {
        UmcGetTempCreditLimitRspBo rspBo = (UmcGetTempCreditLimitRspBo)UmcRu.success(UmcGetTempCreditLimitRspBo.class);
        this.validate(reqBo);
        UmcDepPurchaseLimitQryBo qryLimitBo = new UmcDepPurchaseLimitQryBo();
        qryLimitBo.setLimitObjType("tmp");
        qryLimitBo.setLimitObjId(String.valueOf(reqBo.getCreditOrgId()));
        UmcPurchaseLimitSubDo LimitDo = this.iUmcPurchaseLimitModel.getCurrentPurchaseLimit(qryLimitBo);
        if (LimitDo != null) {
            rspBo.setPurchaseAmount(LimitDo.getPurchaseAmount());
            rspBo.setLimitAmount(LimitDo.getLimitAmount());
            rspBo.setLeftPurchaseAmount(LimitDo.getLeftPurchaseAmount());
        } else {
            rspBo.setPurchaseAmount(BigDecimal.ZERO);
            rspBo.setLimitAmount(BigDecimal.ZERO);
            rspBo.setLeftPurchaseAmount(BigDecimal.ZERO);
        }
        return rspBo;
    }

    private void validate(UmcGetTempCreditLimitReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreditOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u6388\u4fe1\u673a\u6784id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

