/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.tempCredit;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.purchaselimit.IUmcPurchaseLimitModel;
import com.tydic.dyc.umc.model.purchaselimit.qrybo.UmcDepPurchaseLimitQryBo;
import com.tydic.dyc.umc.model.purchaselimit.sub.UmcPurchaseLimitSubDo;
import com.tydic.dyc.umc.model.tempCredit.IUmcTempCreditModel;
import com.tydic.dyc.umc.model.tempCredit.qrybo.UmcTempCreditQryBo;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.tempCredit.UmcGetTempCreditPageListService;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcGetTempCreditPageListReqBo;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcGetTempCreditPageListRspBo;
import com.tydic.dyc.umc.service.tempCredit.bo.UmcTempCreditDetailBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.tempCredit.UmcGetTempCreditPageListService"})
public class UmcGetTempCreditPageListServiceImpl
implements UmcGetTempCreditPageListService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetTempCreditPageListServiceImpl.class);
    @Autowired
    private IUmcTempCreditModel iUmcTempCreditModel;
    @Autowired
    private IUmcPurchaseLimitModel iUmcPurchaseLimitModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    @PostMapping(value={"getTempCreditPageList"})
    public UmcGetTempCreditPageListRspBo getTempCreditPageList(@RequestBody UmcGetTempCreditPageListReqBo reqBo) {
        log.debug("\u65b0\u589e\u4e34\u65f6\u989d\u5ea6\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        this.validate(reqBo);
        UmcOrgInfoQryBo enterpriseOrgQryBo = new UmcOrgInfoQryBo();
        enterpriseOrgQryBo.setOrgId(reqBo.getCreditOrgId());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(enterpriseOrgQryBo);
        if (null == orgInfo) {
            throw new BaseBusinessException("201006", "\u4f01\u4e1a\u8be6\u60c5\u67e5\u8be2\uff0c\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmcTempCreditQryBo qryBo = new UmcTempCreditQryBo();
        qryBo.setCreditOrgId(reqBo.getCreditOrgId());
        qryBo.setPageNo(reqBo.getPageNo());
        qryBo.setPageSize(reqBo.getPageSize());
        qryBo.setOrderBy("create_time desc");
        BasePageRspBo<UmcTempCreditQryBo> rspList = this.iUmcTempCreditModel.qryTempCreditPageList(qryBo);
        UmcGetTempCreditPageListRspBo rspBo = (UmcGetTempCreditPageListRspBo)UmcRu.js(rspList, UmcGetTempCreditPageListRspBo.class);
        List jsl = UmcRu.jsl((List)rspList.getRows(), UmcTempCreditDetailBo.class);
        if (!CollectionUtils.isEmpty((Collection)jsl)) {
            Map accountPeriodMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ACCOUNT_PERIOD");
            Map valleyMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_IS_VALLEY");
            Map natureMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_CREDIT_ENTERPRISE_TYPE");
            Map stateMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_QRY_CREDIT_TEMP_STATE");
            for (UmcTempCreditDetailBo each : jsl) {
                if (!MapUtils.isEmpty((Map)accountPeriodMap)) {
                    each.setAccountPeriodStr((String)accountPeriodMap.get(each.getAccountPeriod()));
                }
                if (!MapUtils.isEmpty((Map)valleyMap)) {
                    each.setIsValleyStr((String)valleyMap.get(each.getIsValley()));
                }
                if (!MapUtils.isEmpty((Map)natureMap)) {
                    each.setCustomerNatureStr((String)natureMap.get(each.getCustomerNature()));
                }
                if (!MapUtils.isEmpty((Map)stateMap)) {
                    each.setCreditStateStr((String)stateMap.get(each.getCreditState()));
                }
                each.setCreateOrgName(each.getExtField1());
            }
        }
        rspBo.setRows(jsl);
        UmcDepPurchaseLimitQryBo qryLimitBo = new UmcDepPurchaseLimitQryBo();
        qryLimitBo.setLimitObjType("tmp");
        qryLimitBo.setLimitObjId(String.valueOf(reqBo.getCreditOrgId()));
        UmcPurchaseLimitSubDo LimitDo = this.iUmcPurchaseLimitModel.getCurrentPurchaseLimit(qryLimitBo);
        if (LimitDo != null) {
            rspBo.setCreditOrgName(LimitDo.getLimitObjName());
            rspBo.setPurchaseAmount(LimitDo.getPurchaseAmount());
            rspBo.setLimitAmount(LimitDo.getLimitAmount());
            rspBo.setLeftPurchaseAmount(LimitDo.getLeftPurchaseAmount());
        } else {
            rspBo.setCreditOrgName(orgInfo.getOrgName());
            rspBo.setPurchaseAmount(BigDecimal.ZERO);
            rspBo.setLimitAmount(BigDecimal.ZERO);
            rspBo.setLeftPurchaseAmount(BigDecimal.ZERO);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u4e34\u65f6\u6388\u4fe1\u5206\u9875\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBo;
    }

    private void validate(UmcGetTempCreditPageListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCreditOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[CreditOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

