/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.weekdayConfig;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.service.weekdayConfig.UmcGetWorkingDayService;
import com.tydic.dyc.umc.service.weekdayConfig.UmcQryWeekDayConfigListService;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetLastWorkingDayThisMonthReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetLastWorkingDayThisMonthRspBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetWorkingDayByDataReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcGetWorkingDayByDataRspBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcIsWorkingDayReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcIsWorkingDayRspBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcQryWeekDayConfigListReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcQryWeekDayConfigListRspBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcWeekDayConfigBo;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.weekdayConfig.UmcGetWorkingDayService"})
public class UmcGetWorkingDayServiceImpl
implements UmcGetWorkingDayService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetWorkingDayServiceImpl.class);
    @Autowired
    private UmcQryWeekDayConfigListService umcQryWeekDayConfigListService;

    @PostMapping(value={"isWorkingDay"})
    public UmcIsWorkingDayRspBo isWorkingDay(@RequestBody UmcIsWorkingDayReqBo reqBo) {
        UmcIsWorkingDayRspBo rspBo = (UmcIsWorkingDayRspBo)UmcRu.success(UmcIsWorkingDayRspBo.class);
        Date dateParam = reqBo.getDate();
        boolean isWorkingDay = this.isRestDay(dateParam);
        rspBo.setIsWorkingDay(Boolean.valueOf(isWorkingDay));
        return rspBo;
    }

    @PostMapping(value={"getLastWorkingDayThisMonth"})
    public UmcGetLastWorkingDayThisMonthRspBo getLastWorkingDayThisMonth(@RequestBody UmcGetLastWorkingDayThisMonthReqBo reqBo) {
        UmcGetLastWorkingDayThisMonthRspBo rspBo = (UmcGetLastWorkingDayThisMonthRspBo)UmcRu.success(UmcGetLastWorkingDayThisMonthRspBo.class);
        Date lastWorkingDayOfMonth = this.getLastWorkingDayOfMonth(reqBo.getDate());
        rspBo.setDate(lastWorkingDayOfMonth);
        return rspBo;
    }

    @PostMapping(value={"getWorkingDayByData"})
    public UmcGetWorkingDayByDataRspBo getWorkingDayByData(@RequestBody UmcGetWorkingDayByDataReqBo reqBo) {
        UmcGetWorkingDayByDataRspBo rspBo = (UmcGetWorkingDayByDataRspBo)UmcRu.success(UmcGetWorkingDayByDataRspBo.class);
        if (reqBo.getDate() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8981\u67e5\u8be2\u7684\u65f6\u95f4]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getWorkingDayNum() < 1) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[workingDayNum]\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (!reqBo.getIsContain().booleanValue()) {
            reqBo.setDate(DateUtil.getTomorrowDateStartTime(reqBo.getDate()));
        }
        Date fifthWorkingDayOfMonth = this.getFifthWorkingDayOfMonth(reqBo.getDate(), reqBo.getWorkingDayNum());
        rspBo.setDate(fifthWorkingDayOfMonth);
        return rspBo;
    }

    private boolean isRestDay(Date dateParam) {
        boolean isWorkingDay = true;
        if (dateParam == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u8981\u67e5\u8be2\u7684\u65f6\u95f4]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date currentDateStartTime = DateUtil.getCurrentDateStartTime(dateParam);
        SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy");
        String format = shortSdf.format(currentDateStartTime);
        UmcQryWeekDayConfigListReqBo umcQryWeekDayConfigListReqBo = new UmcQryWeekDayConfigListReqBo();
        umcQryWeekDayConfigListReqBo.setConfigYear(Integer.valueOf(format));
        UmcQryWeekDayConfigListRspBo umcQryWeekDayConfigListRspBo = this.umcQryWeekDayConfigListService.qryWeekDayConfigList(umcQryWeekDayConfigListReqBo);
        if (!"0000".equals(umcQryWeekDayConfigListRspBo.getRespCode())) {
            throw new BaseBusinessException("100100", umcQryWeekDayConfigListRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)umcQryWeekDayConfigListRspBo.getUmcWeekDayConfigBos())) {
            for (UmcWeekDayConfigBo each : umcQryWeekDayConfigListRspBo.getUmcWeekDayConfigBos()) {
                if (each.getConfigTime() == null || each.getConfigTime().compareTo(currentDateStartTime) != 0) continue;
                isWorkingDay = false;
                break;
            }
        }
        return isWorkingDay;
    }

    private Date getFifthWorkingDayOfMonth(Date date, int maxCount) {
        int count = 0;
        Date result = null;
        while (count < maxCount) {
            if (this.isRestDay(date)) {
                ++count;
                result = date;
            }
            date = DateUtil.getTomorrowDateStartTime(date);
        }
        return result;
    }

    private Date getLastWorkingDayOfMonth(Date dateParam) {
        dateParam = DateUtil.getCurrentDateStartTime(dateParam);
        LocalDate localDate = DateUtil.dateConvertLocalDate(dateParam);
        LocalDate lastWorkingDay = null;
        LocalDate current = localDate.withDayOfMonth(1);
        LocalDate nextMonth = localDate.plusMonths(1L).withDayOfMonth(1);
        while (current.isBefore(nextMonth)) {
            Date date = DateUtil.dateConvertLocalDate(current);
            if (this.isRestDay(date)) {
                lastWorkingDay = current;
            }
            current = current.plusDays(1L);
        }
        if (lastWorkingDay == null) {
            return null;
        }
        return DateUtil.dateConvertLocalDate(lastWorkingDay);
    }
}

