/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.weekdayConfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.weekDayConfig.IUmcWeekDayConfigModel;
import com.tydic.dyc.umc.model.weekDayConfig.IUmcWeekdayConfigDo;
import com.tydic.dyc.umc.model.weekDayConfig.qrybo.UmcWeekdayConfigQryBo;
import com.tydic.dyc.umc.service.weekdayConfig.UmcQryWeekDayConfigListService;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcQryWeekDayConfigListReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcQryWeekDayConfigListRspBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcWeekDayConfigBo;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.weekdayConfig.UmcQryWeekDayConfigListService"})
public class UmcQryWeekDayConfigListServiceImpl
implements UmcQryWeekDayConfigListService {
    private static final Logger log = LoggerFactory.getLogger(UmcQryWeekDayConfigListServiceImpl.class);
    public static final int CONFIG_TYPE = 1;
    public static final int WEEKDAY_CONFIG_KEY_EXPIRE_TIME = 7200;
    @Autowired
    private IUmcWeekDayConfigModel iUmcWeekDayConfigModel;
    @Autowired
    private CacheClient cacheService;

    @PostMapping(value={"qryWeekDayConfigList"})
    public UmcQryWeekDayConfigListRspBo qryWeekDayConfigList(@RequestBody UmcQryWeekDayConfigListReqBo reqBo) {
        UmcQryWeekDayConfigListRspBo rspBo = (UmcQryWeekDayConfigListRspBo)UmcRu.success(UmcQryWeekDayConfigListRspBo.class);
        this.validateParam(reqBo);
        String weekDayConfigKey = "WEEKDAY_CONFIG_KEY_" + reqBo.getConfigYear();
        Object weekDayConfigObj = this.cacheService.get(weekDayConfigKey);
        if (weekDayConfigObj == null) {
            UmcWeekdayConfigQryBo umcWeekdayConfigQryBo = new UmcWeekdayConfigQryBo();
            umcWeekdayConfigQryBo.setConfigYear(reqBo.getConfigYear());
            umcWeekdayConfigQryBo.setConfigType(1);
            List<IUmcWeekdayConfigDo> umcWeekdayConfigDos = this.iUmcWeekDayConfigModel.qryWeekDayConfigList(umcWeekdayConfigQryBo);
            List<UmcWeekDayConfigBo> rows = new ArrayList();
            if (CollectionUtils.isEmpty(umcWeekdayConfigDos)) {
                List<LocalDate> list = DateUtil.getSaturdaySundayCertainYear(reqBo.getConfigYear());
                for (LocalDate each : list) {
                    UmcWeekDayConfigBo umcWeekDayConfigBo = new UmcWeekDayConfigBo();
                    umcWeekDayConfigBo.setConfigYear(Integer.valueOf(each.getYear()));
                    umcWeekDayConfigBo.setConfigMonth(Integer.valueOf(each.getMonthValue()));
                    umcWeekDayConfigBo.setConfigDay(Integer.valueOf(each.getDayOfMonth()));
                    Date date = DateUtil.dateConvertLocalDate(each);
                    umcWeekDayConfigBo.setConfigTime(date);
                    rows.add(umcWeekDayConfigBo);
                }
            } else {
                rows = UmcRu.jsl(umcWeekdayConfigDos, UmcWeekDayConfigBo.class);
            }
            rspBo.setUmcWeekDayConfigBos(rows);
            this.cacheService.set(weekDayConfigKey, (Object)JSON.toJSONString(rows), 7200);
        } else {
            String weekDayConfigStr = (String)weekDayConfigObj;
            log.debug("\u83b7\u53d6\u5230\u7684redis\u7684\u503c\u4e3a\uff1a{}", (Object)weekDayConfigStr);
            List rows = JSONObject.parseArray((String)weekDayConfigStr, UmcWeekDayConfigBo.class);
            rspBo.setUmcWeekDayConfigBos(rows);
        }
        return rspBo;
    }

    private void validateParam(UmcQryWeekDayConfigListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getConfigYear() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u67e5\u8be2\u5e74\u4efd]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

