/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.weekdayConfig;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.weekDayConfig.IUmcWeekDayConfigModel;
import com.tydic.dyc.umc.model.weekDayConfig.IUmcWeekdayConfigDo;
import com.tydic.dyc.umc.service.weekdayConfig.UmcSaveWeekDayConfigBatchService;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcSaveWeekDayConfigBatchReqBo;
import com.tydic.dyc.umc.service.weekdayConfig.bo.UmcSaveWeekDayConfigBatchRspBo;
import com.tydic.dyc.umc.utils.DateUtil;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.weekdayConfig.UmcSaveWeekDayConfigBatchService"})
public class UmcSaveWeekDayConfigBatchServiceImpl
implements UmcSaveWeekDayConfigBatchService {
    private static final Logger log = LoggerFactory.getLogger(UmcSaveWeekDayConfigBatchServiceImpl.class);
    public static final int CONFIG_TYPE = 1;
    @Autowired
    private IUmcWeekDayConfigModel iUmcWeekDayConfigModel;
    @Autowired
    private CacheClient cacheService;

    @PostMapping(value={"saveWeekDayConfigBatch"})
    public UmcSaveWeekDayConfigBatchRspBo saveWeekDayConfigBatch(@RequestBody UmcSaveWeekDayConfigBatchReqBo reqBo) {
        UmcSaveWeekDayConfigBatchRspBo rspBo = (UmcSaveWeekDayConfigBatchRspBo)UmcRu.success(UmcSaveWeekDayConfigBatchRspBo.class);
        this.validateParam(reqBo);
        List<IUmcWeekdayConfigDo> umcWeekdayConfigDos = UmcSaveWeekDayConfigBatchServiceImpl.buildWeekdayConfigDos(reqBo);
        this.deleteOldWeekday(reqBo);
        try {
            this.iUmcWeekDayConfigModel.createWeekDayConfigBatch(umcWeekdayConfigDos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u8282\u5047\u65e5\u5931\u8d25:{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fdd\u5b58\u5931\u8d25");
        }
        this.cacheService.delete("WEEKDAY_CONFIG_KEY_" + reqBo.getConfigYear());
        return rspBo;
    }

    private void deleteOldWeekday(UmcSaveWeekDayConfigBatchReqBo reqBo) {
        IUmcWeekdayConfigDo iUmcWeekdayConfigDoSet = new IUmcWeekdayConfigDo();
        iUmcWeekdayConfigDoSet.setDelFlag("1");
        IUmcWeekdayConfigDo iUmcWeekdayConfigDoWhere = new IUmcWeekdayConfigDo();
        iUmcWeekdayConfigDoWhere.setConfigYear(reqBo.getConfigYear());
        try {
            this.iUmcWeekDayConfigModel.deleteBy(iUmcWeekdayConfigDoWhere);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u4e4b\u524d\u8bbe\u7f6e\u7684\u8282\u5047\u65e5\u5931\u8d25{}", (Object)e.getMessage());
            throw new BaseBusinessException("100001", "\u4fdd\u5b58\u5931\u8d25");
        }
    }

    private static List<IUmcWeekdayConfigDo> buildWeekdayConfigDos(UmcSaveWeekDayConfigBatchReqBo reqBo) {
        ArrayList<IUmcWeekdayConfigDo> umcWeekdayConfigDos = new ArrayList<IUmcWeekdayConfigDo>(reqBo.getConfigTimes().size());
        for (Date each : reqBo.getConfigTimes()) {
            Date date = DateUtil.getCurrentDateStartTime(each);
            IUmcWeekdayConfigDo addWeekdayConfigDo = new IUmcWeekdayConfigDo();
            LocalDate localDate = DateUtil.dateConvertLocalDate(date);
            int configYear = localDate.getYear();
            if (!reqBo.getConfigYear().equals(configYear)) {
                throw new BaseBusinessException("100001", "\u4f20\u5165\u7684\u8282\u5047\u65e5\u65e5\u671f\u548c\u8bbe\u7f6e\u7684\u5e74\u4efd\u4e0d\u4e00\u81f4");
            }
            int configMonth = localDate.getMonthValue();
            int configDay = localDate.getDayOfMonth();
            addWeekdayConfigDo.setWeekdayConfigId(IdUtil.nextId());
            addWeekdayConfigDo.setConfigYear(reqBo.getConfigYear());
            addWeekdayConfigDo.setConfigMonth(configMonth);
            addWeekdayConfigDo.setConfigDay(configDay);
            addWeekdayConfigDo.setConfigTime(date);
            addWeekdayConfigDo.setConfigType(1);
            addWeekdayConfigDo.setCreateOperId(reqBo.getUserId());
            addWeekdayConfigDo.setCreateOperName(reqBo.getName());
            addWeekdayConfigDo.setCreateTime(new Date());
            addWeekdayConfigDo.setDelFlag("0");
            umcWeekdayConfigDos.add(addWeekdayConfigDo);
        }
        return umcWeekdayConfigDos;
    }

    private void validateParam(UmcSaveWeekDayConfigBatchReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getConfigYear() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u5e74\u4efd]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getConfigTimes())) {
            throw new BaseBusinessException("100001", "\u4f20\u5165\u7684\u8282\u5047\u65e5\u65e5\u671f\u4e3a\u7a7a\u6216\u4e0d\u80fd\u5168\u5e74\u90fd\u8bbe\u7f6e\u4e3a\u5de5\u4f5c\u65e5");
        }
    }
}

