/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.utils;

import com.tydic.dyc.umc.utils.ExecutorServiceFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorProcessPool {
    private static final Logger log = LoggerFactory.getLogger(ExecutorProcessPool.class);
    private static final ExecutorProcessPool pool = new ExecutorProcessPool();
    private static ExecutorService customExcecutor;

    private ExecutorProcessPool() {
        customExcecutor = ExecutorServiceFactory.getInstance().createCustomThreadPool();
    }

    public static ExecutorProcessPool getInstance() {
        return pool;
    }

    public static void shutdownAll() {
        customExcecutor.shutdown();
    }

    public static void executeByCustomThread(Runnable task) {
        customExcecutor.execute(task);
        ExecutorProcessPool.log("custom", (ThreadPoolExecutor)customExcecutor);
    }

    public static void log(String name, ThreadPoolExecutor tpe) {
        String status = "[Thread] " + name + " activeCount: " + tpe.getActiveCount() + " ; CompletedTaskCount: " + tpe.getCompletedTaskCount() + " ; Queue Size: " + tpe.getQueue().size() + "; taskCount: " + tpe.getTaskCount();
        log.warn(status);
    }
}

