/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MoneyUtil {
    public static final long VAL = 10000L;
    public static final BigDecimal CONVERSION_BASE = new BigDecimal(10000L);

    public static Long bigDecimal2Long(BigDecimal money) {
        if (money != null) {
            BigDecimal retValue = money.multiply(CONVERSION_BASE);
            return retValue.longValue();
        }
        return 0L;
    }

    public static BigDecimal long2BigDecimal(Long fee) {
        if (fee != null) {
            BigDecimal money = new BigDecimal(fee);
            return money.divide(CONVERSION_BASE, 8, RoundingMode.HALF_UP);
        }
        return null;
    }

    public static BigDecimal long2BigDecimalKeep(Long fee) {
        if (fee != null) {
            BigDecimal money = new BigDecimal(fee);
            return money.divide(CONVERSION_BASE, 2, RoundingMode.HALF_UP);
        }
        return null;
    }

    public static BigDecimal keepTwoDecimalPlaces(BigDecimal money) {
        if (money != null) {
            if ((money = money.stripTrailingZeros()).scale() == 2) {
                return money;
            }
            return money.setScale(2, RoundingMode.HALF_UP);
        }
        return null;
    }

    public static BigDecimal bigDecimalAdjust(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        return MoneyUtil.keepTwoDecimalPlaces(bigDecimal.longValue());
    }

    public static BigDecimal keepTwoDecimalPlaces(Long fee) {
        BigDecimal money = MoneyUtil.long2BigDecimal(fee);
        if (money != null) {
            if (money.scale() == 2) {
                return money;
            }
            return money.setScale(2, RoundingMode.HALF_UP);
        }
        return null;
    }

    public static BigDecimal bigDecimalKeep(BigDecimal money) {
        if (money != null) {
            return money.setScale(2, RoundingMode.HALF_UP);
        }
        return null;
    }
}

