/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.ldOrganization.UmcLdOrganizationInfoQryDo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoPageQryBo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoQryBo;
import com.tydic.dyc.umc.model.ldOrganization.sub.UmcLdOrganizationInfo;
import com.tydic.dyc.umc.repository.UmcLdOrganizationInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcLdOrganizationMapper;
import com.tydic.dyc.umc.repository.po.UmcLdOrganizationPo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcLdOrganizationInfoRepositoryImpl
implements UmcLdOrganizationInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcLdOrganizationInfoRepositoryImpl.class);
    @Autowired
    private UmcLdOrganizationMapper umcLdOrganizationMapper;
    public static final String PROJECT_NAME = "\u9879\u76ee\u7ec4\u7ec7";
    @Value(value="${NO_LEGAL_ENTITY:00026124}")
    private String NO_LEGAL_ENTITY;

    public int synchronizeOrg(List<UmcLdOrganizationInfo> umcLdOrganizationInfos) {
        List umcLdOrganizationPos = UmcRu.jsl(umcLdOrganizationInfos, UmcLdOrganizationPo.class);
        for (UmcLdOrganizationPo each : umcLdOrganizationPos) {
            UmcLdOrganizationPo qryUmcLdOrganizationPo = new UmcLdOrganizationPo();
            qryUmcLdOrganizationPo.setOrgDepId(each.getOrgDepId());
            UmcLdOrganizationPo umcLdOrganizationPo = this.umcLdOrganizationMapper.queryByCondition(qryUmcLdOrganizationPo);
            if (umcLdOrganizationPo == null) {
                each.setOrgId(IdUtil.nextId());
                continue;
            }
            each.setOrgId(umcLdOrganizationPo.getOrgId());
        }
        return this.umcLdOrganizationMapper.insertOrUpdateBatch(umcLdOrganizationPos);
    }

    public List<UmcLdOrganizationInfoQryDo> selectProjectInfoList(UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo) {
        UmcLdOrganizationPo umcLdOrganizationPo = (UmcLdOrganizationPo)UmcRu.js((Object)umcLdOrganizationInfoQryBo, UmcLdOrganizationPo.class);
        List<UmcLdOrganizationPo> rows = this.umcLdOrganizationMapper.selectProjectList(umcLdOrganizationPo);
        if (!CollectionUtils.isEmpty(rows)) {
            List<String> orgNoFullPaths = rows.stream().filter(each -> PROJECT_NAME.equals(each.getOrgShortName())).map(UmcLdOrganizationPo::getOrgNoFullPath).collect(Collectors.toList());
            HashSet<String> orgDepIds = new HashSet<String>();
            orgNoFullPaths.forEach(each -> {
                String[] split = each.split("-");
                orgDepIds.addAll(Arrays.asList(split));
            });
            log.debug("\u67e5\u8be2\u9879\u76ee\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u4e0a\u7ea7id{}", orgDepIds);
            UmcLdOrganizationPo qryUmcLdOrganization = new UmcLdOrganizationPo();
            qryUmcLdOrganization.setOrgDepIdSet(orgDepIds);
            List<UmcLdOrganizationPo> umcLdOrgGradingList = this.umcLdOrganizationMapper.selectInternalOrgList(qryUmcLdOrganization);
            log.debug("\u67e5\u8be2\u9879\u76ee\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u4e0a\u7ea7\u6570\u636e{}", umcLdOrgGradingList);
            rows.addAll(umcLdOrgGradingList);
        }
        return ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcLdOrganizationInfoQryDo.class) : new ArrayList(0);
    }

    public BasePageRspBo<UmcLdOrganizationInfo> selectLegalEntityInfo(UmcLdOrganizationInfoPageQryBo umcLdOrganizationInfoPageQryBo) {
        Page page = new Page(umcLdOrganizationInfoPageQryBo.getPageNo(), umcLdOrganizationInfoPageQryBo.getPageSize());
        UmcLdOrganizationPo umcLdOrganization = new UmcLdOrganizationPo();
        umcLdOrganization.setOrgShortName(umcLdOrganizationInfoPageQryBo.getOrgShortName());
        umcLdOrganization.setOrgType("P2");
        umcLdOrganization.setNoOrgDepIds(Collections.singletonList(this.NO_LEGAL_ENTITY));
        umcLdOrganization.setOrgStatus("1");
        List<UmcLdOrganizationPo> umcLdOrganizationPoList = this.umcLdOrganizationMapper.queryAllByLimit(umcLdOrganization, (Page<UmcLdOrganizationPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(!CollectionUtils.isEmpty(umcLdOrganizationPoList) ? UmcRu.jsl(umcLdOrganizationPoList, UmcLdOrganizationInfo.class) : new ArrayList(0));
        return rspBo;
    }

    public BasePageRspBo<UmcLdOrganizationInfo> queryAllByLimit(UmcLdOrganizationInfoPageQryBo umcLdOrganizationInfoPageQryBo) {
        Page page = new Page(umcLdOrganizationInfoPageQryBo.getPageNo(), umcLdOrganizationInfoPageQryBo.getPageSize());
        UmcLdOrganizationPo umcLdOrganization = new UmcLdOrganizationPo();
        umcLdOrganization.setOrgDepId(umcLdOrganizationInfoPageQryBo.getOrgDepId());
        List<UmcLdOrganizationPo> umcLdOrganizationPoList = this.umcLdOrganizationMapper.queryAllByLimit(umcLdOrganization, (Page<UmcLdOrganizationPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(!CollectionUtils.isEmpty(umcLdOrganizationPoList) ? UmcRu.jsl(umcLdOrganizationPoList, UmcLdOrganizationInfo.class) : new ArrayList(0));
        return rspBo;
    }

    public UmcLdOrganizationInfoQryDo qryLdOrgInfoDetail(UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo) {
        UmcLdOrganizationPo umcLdOrganizationPo = (UmcLdOrganizationPo)UmcRu.js((Object)umcLdOrganizationInfoQryBo, UmcLdOrganizationPo.class);
        UmcLdOrganizationPo modelBy = this.umcLdOrganizationMapper.queryByCondition(umcLdOrganizationPo);
        return (UmcLdOrganizationInfoQryDo)UmcRu.js((Object)modelBy, UmcLdOrganizationInfoQryDo.class);
    }
}

