/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.authority.repository.dao.SysCustInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysUserInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysUserTagRelMapper;
import com.tydic.dyc.authority.repository.po.SysCustInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserTagRelPo;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcEnumConstant;
import com.tydic.dyc.umc.model.ldUser.sub.UmcMemberInfo;
import com.tydic.dyc.umc.model.ldUser.sub.UmcSynUserInfo;
import com.tydic.dyc.umc.repository.UmcLdUserInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcDealMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcCustInfoPo;
import com.tydic.dyc.umc.repository.po.UmcLdOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserTagRelPo;
import com.tydic.dyc.umc.utils.UmcBusinessException;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcLdUserInfoRepositoryImpl
implements UmcLdUserInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcLdUserInfoRepositoryImpl.class);
    @Autowired
    private UmcDealMapper umcDealMapper;
    @Autowired
    private UmcCustInfoMapper umcCustInfoMapper;
    @Autowired
    private SysCustInfoMapper sysCustInfoMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private SysUserInfoMapper sysUserInfoMapper;
    @Autowired
    private UmcUserTagRelMapper umcUserTagRelMapper;
    @Autowired
    private SysUserTagRelMapper sysUserTagRelMapper;
    public static final String VALID_STATUS = "0";

    public void synchronizeUser(List<UmcSynUserInfo> rows) {
        for (UmcSynUserInfo each : rows) {
            if (StringUtils.isBlank((CharSequence)each.getUserid())) continue;
            UmcMemberInfo inboundData = this.dealMemberInfo(each);
            this.dealUmcCustInfo(inboundData);
            if (!StringUtils.isBlank((CharSequence)each.getParttimepost())) {
                String[] positionIds = each.getParttimepost().split(";");
                List<Long> userIds = this.umcDealMapper.qryUserIdByJobCodes(positionIds, inboundData.getMemId());
                if (!CollectionUtils.isEmpty(userIds)) {
                    this.umcDealMapper.delSysUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserInfo(userIds);
                    this.umcDealMapper.delSysUserInfo(userIds);
                }
                for (int i = 0; i < positionIds.length; ++i) {
                    UmcUserInfoPo qryUmcCustInfoPo = new UmcUserInfoPo();
                    qryUmcCustInfoPo.setMainCustId(inboundData.getMemId());
                    qryUmcCustInfoPo.setExtField1(positionIds[i]);
                    qryUmcCustInfoPo.setIsMain(VALID_STATUS);
                    UmcUserInfoPo umcUserInfoPo = this.umcUserInfoMapper.getModelBy(qryUmcCustInfoPo);
                    if (umcUserInfoPo != null) continue;
                    Long userId = Sequence.getInstance().nextId();
                    this.dealUmcUserInfo(inboundData, positionIds[i], userId, VALID_STATUS);
                }
            } else {
                List<Long> userIds = this.umcDealMapper.qryPluralismByMainCustId(inboundData.getMemId());
                if (!CollectionUtils.isEmpty(userIds)) {
                    this.umcDealMapper.delSysUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserInfo(userIds);
                    this.umcDealMapper.delSysUserInfo(userIds);
                }
            }
            UmcUserInfoPo qryUmcUserInfoPo = new UmcUserInfoPo();
            qryUmcUserInfoPo.setIsMain("1");
            qryUmcUserInfoPo.setMainCustId(inboundData.getMemId());
            UmcUserInfoPo modelBy = this.umcUserInfoMapper.getModelBy(qryUmcUserInfoPo);
            if (modelBy == null) {
                Long userId = Sequence.getInstance().nextId();
                this.dealUmcUserInfo(inboundData, inboundData.getPostCode(), userId, "1");
                continue;
            }
            this.updateUmcUserInfo(inboundData, modelBy.getUserId());
        }
    }

    private void updateUmcUserInfo(UmcMemberInfo inboundData, Long userId) {
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setUserId(userId);
        umcUserInfoPo.setCustId(inboundData.getMemId());
        umcUserInfoPo.setMainCustId(inboundData.getMemId());
        umcUserInfoPo.setTenantId(inboundData.getTenantId());
        umcUserInfoPo.setOrgId(inboundData.getOrgId());
        umcUserInfoPo.setOrgTreePath(inboundData.getOrgTreePath());
        umcUserInfoPo.setCompanyId(inboundData.getCompanyId());
        umcUserInfoPo.setUserType(inboundData.getUserType());
        umcUserInfoPo.setAuthorityType("auth:default:manage");
        umcUserInfoPo.setIsMain("1");
        umcUserInfoPo.setStopStatus(inboundData.getStopStatus());
        umcUserInfoPo.setDelFlag(inboundData.getDelFlag());
        umcUserInfoPo.setCreateTime(inboundData.getCreateTime());
        umcUserInfoPo.setExtField2(inboundData.getPostCode());
        StrUtil.noNullStringAttr((Object)umcUserInfoPo);
        SysUserInfoPo sysUserInfoPo = new SysUserInfoPo();
        BeanUtils.copyProperties((Object)umcUserInfoPo, (Object)sysUserInfoPo);
        try {
            UmcUserInfoPo whereParam = new UmcUserInfoPo();
            whereParam.setUserId(userId);
            this.umcUserInfoMapper.updateBy(umcUserInfoPo, whereParam);
            SysUserInfoPo whereParam2 = new SysUserInfoPo();
            whereParam2.setUserId(userId);
            sysUserInfoPo.setUserStatus("1");
            sysUserInfoPo.setIsMain("1");
            this.sysUserInfoMapper.updateBy(sysUserInfoPo, whereParam2);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u7528\u6237\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u4fee\u6539\u7528\u6237\u8868\u5931\u8d25!" + e.getMessage());
        }
    }

    private void dealUserTagRel(UmcMemberInfo inboundData, Long userId) {
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        Long relId = Sequence.getInstance().nextId();
        umcUserTagRelPo.setRelId(relId);
        umcUserTagRelPo.setUserId(userId);
        umcUserTagRelPo.setTenantId(inboundData.getTenantId());
        umcUserTagRelPo.setTagId("1");
        umcUserTagRelPo.setIsDefalt("1");
        umcUserTagRelPo.setDelFlag(inboundData.getDelFlag());
        StrUtil.noNullStringAttr((Object)umcUserTagRelPo);
        SysUserTagRelPo sysUserTagRelPo = (SysUserTagRelPo)UmcRu.js((Object)umcUserTagRelPo, SysUserTagRelPo.class);
        try {
            this.umcUserTagRelMapper.insert(umcUserTagRelPo);
            this.sysUserTagRelMapper.insert(sysUserTagRelPo);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u7528\u6237\u5728\u6240\u5c5e\u673a\u6784\u7684\u8eab\u4efd\u7c7b\u578b\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u7528\u6237\u5728\u6240\u5c5e\u673a\u6784\u7684\u8eab\u4efd\u7c7b\u578b\u8868\u5931\u8d25!");
        }
    }

    private void dealUmcUserInfo(UmcMemberInfo inboundData, String positionId, Long userId, String isMain) {
        log.debug("\u5c97\u4f4d\u7f16\u7801\u4e3a\uff1a{}", (Object)positionId);
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setUserId(userId);
        umcUserInfoPo.setCustId(inboundData.getMemId());
        umcUserInfoPo.setMainCustId(inboundData.getMemId());
        umcUserInfoPo.setTenantId(inboundData.getTenantId());
        UmcLdOrgInfoPo qryUmcLdOrgInfoPo = new UmcLdOrgInfoPo();
        qryUmcLdOrgInfoPo.setJobCode(positionId);
        UmcLdOrgInfoPo enterpriseOrgByCondition = this.umcDealMapper.getEnterpriseOrgByCondition(qryUmcLdOrgInfoPo);
        log.debug("\u6839\u636e\u5c97\u4f4d\u7f16\u7801\u67e5\u8be2\u5230\u7684\u673a\u6784\u4fe1\u606f\u4e3a\uff1a{}", (Object)enterpriseOrgByCondition);
        if (enterpriseOrgByCondition != null) {
            umcUserInfoPo.setOrgId(enterpriseOrgByCondition.getOrgId());
            umcUserInfoPo.setOrgTreePath(enterpriseOrgByCondition.getOrgTreePath());
            umcUserInfoPo.setCompanyId(enterpriseOrgByCondition.getCompanyId());
            umcUserInfoPo.setUserType(inboundData.getUserType());
            umcUserInfoPo.setAuthorityType("auth:default:manage");
            umcUserInfoPo.setIsMain(isMain);
            umcUserInfoPo.setStopStatus(inboundData.getStopStatus());
            umcUserInfoPo.setDelFlag(inboundData.getDelFlag());
            umcUserInfoPo.setCreateTime(inboundData.getCreateTime());
            umcUserInfoPo.setExtField2(positionId);
            StrUtil.noNullStringAttr((Object)umcUserInfoPo);
            SysUserInfoPo sysUserInfoPo = new SysUserInfoPo();
            BeanUtils.copyProperties((Object)umcUserInfoPo, (Object)sysUserInfoPo);
            try {
                this.umcUserInfoMapper.insert(umcUserInfoPo);
                sysUserInfoPo.setUserStatus("1");
                sysUserInfoPo.setIsMain(isMain);
                this.sysUserInfoMapper.insert(sysUserInfoPo);
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u7528\u6237\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new UmcBusinessException("8888", "\u64cd\u4f5c\u7528\u6237\u8868\u5931\u8d25!" + e.getMessage());
            }
            this.dealUserTagRel(inboundData, userId);
        } else {
            log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u5c97\u4f4d\u6240\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u5c97\u4f4d\u7f16\u7801\u4e3a\uff1a{}", (Object)positionId);
        }
    }

    private void dealUmcCustInfo(UmcMemberInfo inboundData) {
        UmcCustInfoPo umcCustInfoPo = new UmcCustInfoPo();
        umcCustInfoPo.setCustId(inboundData.getMemId());
        umcCustInfoPo.setWorkNo(inboundData.getWorkNo());
        umcCustInfoPo.setOfficePhone(inboundData.getOfficePhone());
        umcCustInfoPo.setStopStatus(inboundData.getStopStatus());
        umcCustInfoPo.setCustAffiliation(inboundData.getMemAffiliation());
        umcCustInfoPo.setCustType(inboundData.getUserType());
        umcCustInfoPo.setRegAccount(inboundData.getRegAccount());
        umcCustInfoPo.setRegMobile(inboundData.getRegMobile());
        umcCustInfoPo.setRegEmail(inboundData.getRegEmail());
        umcCustInfoPo.setHeadUrl(inboundData.getHeadUrl());
        umcCustInfoPo.setIsOnline(inboundData.getIsOnline());
        umcCustInfoPo.setCustStatus(inboundData.getState());
        umcCustInfoPo.setIsPasswdValid(inboundData.getIsPasswdValid());
        umcCustInfoPo.setMaxRepeatLoginNum(inboundData.getMaxRepeatLoginNum());
        umcCustInfoPo.setCustName(inboundData.getMemName2());
        umcCustInfoPo.setSex(inboundData.getSex());
        umcCustInfoPo.setBirthday(inboundData.getBirthday());
        umcCustInfoPo.setIsBlacklist(inboundData.getIsBlackList());
        umcCustInfoPo.setCreateTime(inboundData.getCreateTime());
        umcCustInfoPo.setUpdateTime(inboundData.getUpdateTime());
        umcCustInfoPo.setDelFlag(inboundData.getDelFlag());
        umcCustInfoPo.setCertType(inboundData.getCertType());
        umcCustInfoPo.setCertNo(inboundData.getCertNo());
        umcCustInfoPo.setExtField1(inboundData.getSource());
        umcCustInfoPo.setExtField2(inboundData.getPartTimePost());
        SysCustInfoPo sysCustInfoPo = new SysCustInfoPo();
        sysCustInfoPo.setCustId(inboundData.getMemId());
        sysCustInfoPo.setLoginName(umcCustInfoPo.getRegAccount());
        sysCustInfoPo.setCustCode(inboundData.getMemCode());
        sysCustInfoPo.setTenantId(inboundData.getTenantId());
        sysCustInfoPo.setCustName(umcCustInfoPo.getCustName());
        sysCustInfoPo.setCellPhone(umcCustInfoPo.getRegMobile());
        sysCustInfoPo.setCustEmail(umcCustInfoPo.getRegEmail());
        sysCustInfoPo.setCustStatus(umcCustInfoPo.getCustStatus());
        sysCustInfoPo.setCustSource(umcCustInfoPo.getExtField1());
        sysCustInfoPo.setCreateTime(umcCustInfoPo.getCreateTime());
        sysCustInfoPo.setDelFlag(umcCustInfoPo.getDelFlag());
        sysCustInfoPo.setPasswordEffDate(inboundData.getCreateTime());
        StrUtil.noNullStringAttr((Object)umcCustInfoPo);
        StrUtil.noNullStringAttr((Object)sysCustInfoPo);
        SysCustInfoPo qrySysCustInfoPo = new SysCustInfoPo();
        qrySysCustInfoPo.setCustCode(inboundData.getMemCode());
        qrySysCustInfoPo = this.sysCustInfoMapper.getModelBy(qrySysCustInfoPo);
        try {
            if (qrySysCustInfoPo == null) {
                this.umcCustInfoMapper.insert(umcCustInfoPo);
                this.sysCustInfoMapper.insert(sysCustInfoPo);
            } else {
                UmcCustInfoPo whereParam = new UmcCustInfoPo();
                whereParam.setCustId(inboundData.getMemId());
                this.umcCustInfoMapper.updateBy(umcCustInfoPo, whereParam);
                SysCustInfoPo whereParam2 = new SysCustInfoPo();
                whereParam2.setCustId(inboundData.getMemId());
                this.sysCustInfoMapper.updateBy(sysCustInfoPo, whereParam2);
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5ba2\u6237\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u5ba2\u6237\u8868\u5931\u8d25!" + e.getMessage());
        }
    }

    private UmcMemberInfo dealMemberInfo(UmcSynUserInfo each) {
        Date date;
        SimpleDateFormat sdf;
        UmcMemberInfo memberPO = new UmcMemberInfo();
        memberPO.setUserId(Long.valueOf("1" + each.getUserid()));
        memberPO.setMemId(memberPO.getUserId());
        memberPO.setSource("2");
        memberPO.setMemCode(each.getUserid());
        memberPO.setMainMemId(memberPO.getMemId());
        memberPO.setMemName2(each.getUsercn());
        memberPO.setMaxRepeatLoginNum(Integer.valueOf(5));
        memberPO.setRegEmail(each.getMail());
        memberPO.setRegMobile(each.getMobile());
        memberPO.setDelFlag(VALID_STATUS);
        memberPO.setState("1");
        if (VALID_STATUS.equals(each.getValidstatus())) {
            memberPO.setStopStatus("01");
        } else {
            memberPO.setStopStatus("00");
        }
        memberPO.setRegAccount(each.getAlias());
        if (UmcEnumConstant.Sex.Male.getCode().toString().equals(each.getGender())) {
            memberPO.setSex(UmcEnumConstant.Sex.Male.getCode());
        } else if (UmcEnumConstant.Sex.female.getCode().toString().equals(each.getGender())) {
            memberPO.setSex(UmcEnumConstant.Sex.female.getCode());
        } else {
            memberPO.setSex(UmcEnumConstant.Sex.Unknown.getCode());
        }
        memberPO.setOfficePhone(each.getTelephonenumber());
        memberPO.setWorkNo(each.getUsernumber());
        memberPO.setBirthday(each.getBirthdate());
        if (!StringUtils.isBlank((CharSequence)each.getUsercreatetime())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = sdf.parse(each.getUsercreatetime());
                memberPO.setCreateTime(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isBlank((CharSequence)each.getModifytimestamp())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = sdf.parse(each.getModifytimestamp());
                memberPO.setUpdateTime(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        memberPO.setUserType("4");
        if (!StringUtils.isBlank((CharSequence)each.getDepartmentnumber())) {
            UmcLdOrgInfoPo qryUmcLdOrgInfoPo = new UmcLdOrgInfoPo();
            qryUmcLdOrgInfoPo.setOrgCode(each.getDepartmentnumber());
            UmcLdOrgInfoPo umcOrgInfoPo = this.umcDealMapper.getEnterpriseOrgByCondition(qryUmcLdOrgInfoPo);
            if (umcOrgInfoPo != null) {
                memberPO.setOrgId(umcOrgInfoPo.getOrgId());
                memberPO.setOrgTreePath(umcOrgInfoPo.getOrgTreePath());
                memberPO.setCompanyId(umcOrgInfoPo.getCompanyId());
            }
        }
        memberPO.setMemAffiliation("01");
        memberPO.setMemClassify("00");
        if (each.getPositionid() == null) {
            memberPO.setPostCode("");
        } else {
            memberPO.setPostCode(each.getPositionid());
        }
        memberPO.setPartTimePost(each.getParttimepost());
        memberPO.setIsOnline(UmcEnumConstant.IsOnline.NO.getCode());
        memberPO.setIsPasswdValid(UmcEnumConstant.IsPasswdValid.YES.getCode());
        memberPO.setIsBlackList(UmcEnumConstant.IsBlacklist.NO.getCode());
        memberPO.setMemLevel(UmcCommConstant.UmcDefaultValue.MEM_LEVEL);
        memberPO.setMaxRepeatLoginNum(UmcCommConstant.UmcDefaultValue.MAX_REPEAT_LOGIN_NUM);
        memberPO.setGrowValue(UmcCommConstant.UmcDefaultValue.GROW_VALUE);
        memberPO.setMemReputation(UmcCommConstant.UmcDefaultValue.MEM_REPUTATION);
        memberPO.setMemBalance(UmcCommConstant.UmcDefaultValue.MEM_BALANCE);
        memberPO.setTenantId(Long.valueOf(10000L));
        return memberPO;
    }
}

