/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.common.util.HanyuPinyinHelper;
import com.tydic.dyc.authority.repository.dao.SysOrgInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysOrgTagRelMapper;
import com.tydic.dyc.authority.repository.po.SysOrgInfoPo;
import com.tydic.dyc.authority.repository.po.SysOrgTagRelPo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.ldOrganization.sub.UmcEnterpriseOrgInfo;
import com.tydic.dyc.umc.model.ldOrganization.sub.UmcLdOrganizationInfo;
import com.tydic.dyc.umc.repository.UmcSynchronizeOrgToMyTableRepository;
import com.tydic.dyc.umc.repository.dao.UmcDealMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseAccountMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcLdOrganizationMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseAccountPo;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseInfoPo;
import com.tydic.dyc.umc.repository.po.UmcLdOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcLdOrganizationPo;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgTagRelPo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcBusinessException;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcSynchronizeOrgToMyTableRepositoryImpl
implements UmcSynchronizeOrgToMyTableRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcSynchronizeOrgToMyTableRepositoryImpl.class);
    public static final String STAGE = "1";
    @Value(value="305775845729763327")
    private Long deliveryCenterId;
    public static final String OPERTYPE_ADD = "add";
    public static final String OPERTYPE_UPDATE = "update";
    @Value(value="${LD_PARENT_ID:305775845729763327}")
    private Long LD_PARENT_ID;
    @Value(value="${LD_ORG_TREE_PATH:1-305775845729763327-}")
    private String LD_ORG_TREE_PATH;
    @Autowired
    private UmcDealMapper umcDealMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private UmcLdOrganizationMapper umcLdOrganizationMapper;
    @Autowired
    private UmcOrgTagRelMapper umcOrgTagRelMapper;
    @Autowired
    private UmcEnterpriseInfoMapper umcEnterpriseInfoMapper;
    @Autowired
    private SysOrgInfoMapper sysOrgInfoMapper;
    @Autowired
    private SysOrgTagRelMapper sysOrgTagRelMapper;
    @Autowired
    private UmcEnterpriseAccountMapper umcEnterpriseAccountMapper;

    public void synchronizeOrgToMyTable(List<UmcLdOrganizationInfo> rows) {
        if (!CollectionUtils.isEmpty(rows)) {
            for (UmcLdOrganizationInfo each : rows) {
                UmcLdOrgInfoPo qryUmcOrgInfoPo = new UmcLdOrgInfoPo();
                qryUmcOrgInfoPo.setOrgCode(each.getOrgDepid());
                UmcLdOrgInfoPo modelByCondition = this.umcDealMapper.getEnterpriseOrgByCondition(qryUmcOrgInfoPo);
                String operType = "";
                operType = modelByCondition == null ? OPERTYPE_ADD : OPERTYPE_UPDATE;
                UmcEnterpriseOrgInfo inboundData = this.dealEnterpriseOrg(each);
                this.dealUmcOrgInfoOrg(inboundData, operType);
                if (modelByCondition == null) {
                    this.dealUmcOrgTagRel(inboundData);
                }
                this.dealUmcEnterpriseInfo(inboundData, operType);
                this.dealSysOrgInfo(inboundData, operType);
                this.dealEnterpriseAccount(inboundData);
            }
        }
    }

    private void dealEnterpriseAccount(UmcEnterpriseOrgInfo inboundData) {
        UmcEnterpriseAccountPo enterpriseAccountPONew = new UmcEnterpriseAccountPo();
        enterpriseAccountPONew.setOrgId(inboundData.getOrgId());
        enterpriseAccountPONew.setAccountStatus(STAGE);
        enterpriseAccountPONew.setDelFlag("0");
        enterpriseAccountPONew.setCheckStatus(STAGE);
        int checkBy = this.umcEnterpriseAccountMapper.getCheckBy(enterpriseAccountPONew);
        if (checkBy == 0) {
            Long accountId = inboundData.getOrgId();
            enterpriseAccountPONew.setAccountId(accountId);
            enterpriseAccountPONew.setAccountName(inboundData.getOrgName());
            enterpriseAccountPONew.setAccountType("01");
            enterpriseAccountPONew.setIsShadowAccount(UmcCommConstant.EntAccIsShadow.NO.toString());
            enterpriseAccountPONew.setAccountOwner("COMPANY");
            enterpriseAccountPONew.setDeliveryCenterId(this.deliveryCenterId);
            try {
                this.umcEnterpriseAccountMapper.insert(enterpriseAccountPONew);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u9ed8\u8ba4\u8d26\u5957\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new UmcBusinessException("8888", "\u65b0\u589e\u9ed8\u8ba4\u8d26\u5957\u5931\u8d25!");
            }
        }
    }

    private void dealSysOrgInfo(UmcEnterpriseOrgInfo inboundData, String operType) {
        SysOrgInfoPo sysOrgInfoPo = new SysOrgInfoPo();
        sysOrgInfoPo.setOrgId(inboundData.getOrgId());
        sysOrgInfoPo.setTenantId(inboundData.getTenantId());
        sysOrgInfoPo.setParentId(inboundData.getParentId());
        sysOrgInfoPo.setCompanyId(inboundData.getCompanyOrgId());
        sysOrgInfoPo.setOrgTreePath(inboundData.getOrgTreePath());
        sysOrgInfoPo.setOrgCode(inboundData.getOrgCode());
        sysOrgInfoPo.setDeep(inboundData.getDeep());
        sysOrgInfoPo.setOrgName(inboundData.getOrgName());
        sysOrgInfoPo.setOrgAlias(inboundData.getAlias());
        sysOrgInfoPo.setOrgType(inboundData.getOrgType());
        sysOrgInfoPo.setIsVirtual(inboundData.getIsVirtual());
        sysOrgInfoPo.setOrgStatus(inboundData.getStatus());
        sysOrgInfoPo.setOrgSort(inboundData.getSort());
        sysOrgInfoPo.setCreateTime(inboundData.getCreateTime());
        sysOrgInfoPo.setUpdateTime(inboundData.getUpdateTime());
        sysOrgInfoPo.setDelFlag(inboundData.getDelStatus());
        try {
            if (OPERTYPE_ADD.equals(operType)) {
                StrUtil.noNullStringAttr((Object)sysOrgInfoPo);
                this.sysOrgInfoMapper.insert(sysOrgInfoPo);
            } else {
                SysOrgInfoPo whereParam = new SysOrgInfoPo();
                whereParam.setOrgId(sysOrgInfoPo.getOrgId());
                this.sysOrgInfoMapper.updateBy(sysOrgInfoPo, whereParam);
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u6743\u9650\u673a\u6784\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u6743\u9650\u673a\u6784\u8868\u5931\u8d25!");
        }
    }

    private void dealUmcEnterpriseInfo(UmcEnterpriseOrgInfo inboundData, String operType) {
        UmcEnterpriseInfoPo umcEnterpriseInfoPo = new UmcEnterpriseInfoPo();
        umcEnterpriseInfoPo.setOrgId(inboundData.getOrgId());
        umcEnterpriseInfoPo.setTenantId(inboundData.getTenantId());
        umcEnterpriseInfoPo.setOrgShortName(inboundData.getOrgName());
        umcEnterpriseInfoPo.setOrgClass(inboundData.getOrgClass());
        umcEnterpriseInfoPo.setIsAbroad(inboundData.getIsAbroad());
        umcEnterpriseInfoPo.setIsMerchant(STAGE);
        umcEnterpriseInfoPo.setIsShopOrg(inboundData.getIsShopOrg());
        umcEnterpriseInfoPo.setCreateTime(inboundData.getCreateTime());
        umcEnterpriseInfoPo.setUpdateTime(inboundData.getUpdateTime());
        umcEnterpriseInfoPo.setDelFlag(inboundData.getDelStatus());
        umcEnterpriseInfoPo.setExtField1(STAGE);
        try {
            if (OPERTYPE_ADD.equals(operType)) {
                StrUtil.noNullStringAttr((Object)umcEnterpriseInfoPo);
                this.umcEnterpriseInfoMapper.insert(umcEnterpriseInfoPo);
            } else {
                UmcEnterpriseInfoPo whereParam = new UmcEnterpriseInfoPo();
                whereParam.setOrgId(umcEnterpriseInfoPo.getOrgId());
                this.umcEnterpriseInfoMapper.updateBy(umcEnterpriseInfoPo, whereParam);
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u673a\u6784\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u673a\u6784\u8868\u5931\u8d25!");
        }
    }

    private void dealUmcOrgInfoOrg(UmcEnterpriseOrgInfo inboundData, String operType) {
        UmcOrgInfoPo umcOrgInfo = new UmcOrgInfoPo();
        umcOrgInfo.setOrgId(inboundData.getOrgId());
        umcOrgInfo.setTenantId(inboundData.getTenantId());
        umcOrgInfo.setParentId(inboundData.getParentId());
        umcOrgInfo.setOrgType(inboundData.getOrgType());
        umcOrgInfo.setCompanyId(inboundData.getCompanyOrgId());
        umcOrgInfo.setOrgTreePath(inboundData.getOrgTreePath());
        umcOrgInfo.setOrgCode(inboundData.getOrgCode());
        umcOrgInfo.setDeep(inboundData.getDeep());
        umcOrgInfo.setOrgName(inboundData.getOrgName());
        umcOrgInfo.setOrgAlias(inboundData.getAlias());
        umcOrgInfo.setIsVirtual(inboundData.getIsVirtual());
        umcOrgInfo.setOrgStatus(inboundData.getStatus());
        umcOrgInfo.setOrgSort(inboundData.getSort());
        umcOrgInfo.setCreateTime(inboundData.getCreateTime());
        umcOrgInfo.setUpdateTime(inboundData.getUpdateTime());
        umcOrgInfo.setDelFlag(inboundData.getDelStatus());
        umcOrgInfo.setExtField1(STAGE);
        try {
            if (OPERTYPE_ADD.equals(operType)) {
                StrUtil.noNullStringAttr((Object)umcOrgInfo);
                this.umcOrgInfoMapper.insert(umcOrgInfo);
            } else {
                UmcOrgInfoPo whereParam = new UmcOrgInfoPo();
                whereParam.setOrgId(umcOrgInfo.getOrgId());
                this.umcOrgInfoMapper.updateBy(umcOrgInfo, whereParam);
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u673a\u6784\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u673a\u6784\u8868\u5931\u8d25!");
        }
    }

    private void dealUmcOrgTagRel(UmcEnterpriseOrgInfo inboundData) {
        UmcOrgTagRelPo umcOrgTagRelPo = new UmcOrgTagRelPo();
        umcOrgTagRelPo.setRelId(Long.valueOf(IdUtil.nextId()));
        umcOrgTagRelPo.setOrgId(inboundData.getOrgId());
        umcOrgTagRelPo.setTenantId(inboundData.getTenantId());
        umcOrgTagRelPo.setTagId(STAGE);
        umcOrgTagRelPo.setTagStatus(STAGE);
        umcOrgTagRelPo.setCreateTime(inboundData.getCreateTime());
        umcOrgTagRelPo.setUpdateTime(inboundData.getUpdateTime());
        umcOrgTagRelPo.setDelFlag("0");
        try {
            StrUtil.noNullStringAttr((Object)umcOrgTagRelPo);
            this.umcOrgTagRelMapper.insert(umcOrgTagRelPo);
            SysOrgTagRelPo sysOrgTagRelPo = (SysOrgTagRelPo)UmcRu.js((Object)umcOrgTagRelPo, SysOrgTagRelPo.class);
            this.sysOrgTagRelMapper.insert(sysOrgTagRelPo);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u673a\u6784\u8868\u8eab\u4efd\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u673a\u6784\u8868\u8eab\u4efd\u5931\u8d25!");
        }
    }

    private UmcEnterpriseOrgInfo dealEnterpriseOrg(UmcLdOrganizationInfo each) {
        Date date;
        SimpleDateFormat sdf;
        String[] orgDepids;
        UmcEnterpriseOrgInfo inboundData = new UmcEnterpriseOrgInfo();
        inboundData.setOrgId(each.getOrgId());
        if ("0".equals(each.getParentOrgId())) {
            inboundData.setParentId(Long.valueOf(0L));
        } else {
            UmcLdOrganizationPo qryUmcLdOrganization = new UmcLdOrganizationPo();
            qryUmcLdOrganization.setOrgDepId(each.getParentOrgId());
            UmcLdOrganizationPo umcLdOrganizationPO = this.umcLdOrganizationMapper.queryByCondition(qryUmcLdOrganization);
            if (umcLdOrganizationPO != null) {
                inboundData.setParentId(umcLdOrganizationPO.getOrgId());
            }
        }
        if (inboundData.getParentId() == 0L) {
            inboundData.setOrgTreePath(this.LD_ORG_TREE_PATH + inboundData.getOrgId() + "-");
            inboundData.setParentId(this.LD_PARENT_ID);
            inboundData.setCompanyOrgId(inboundData.getOrgId());
        } else if (StringUtils.isNotBlank((CharSequence)each.getOrgNoFullPath())) {
            orgDepids = each.getOrgNoFullPath().split("-");
            UmcLdOrganizationPo qryUmcLdOrganization = new UmcLdOrganizationPo();
            qryUmcLdOrganization.setOrgDepIds(Arrays.asList(orgDepids));
            List<UmcLdOrganizationPo> umcLdOrganizationList = this.umcLdOrganizationMapper.queryAllByAll(qryUmcLdOrganization);
            StringBuffer orgTreePath = new StringBuffer(this.LD_ORG_TREE_PATH);
            if (!CollectionUtils.isEmpty(umcLdOrganizationList)) {
                Map<String, List<UmcLdOrganizationPo>> umcLdOrganizationMap = umcLdOrganizationList.stream().collect(Collectors.groupingBy(UmcLdOrganizationPo::getOrgDepId));
                for (String orgDepid : orgDepids) {
                    List<UmcLdOrganizationPo> umcLdOrganizationPOS = umcLdOrganizationMap.get(orgDepid);
                    if (CollectionUtils.isEmpty(umcLdOrganizationPOS)) continue;
                    orgTreePath.append(umcLdOrganizationPOS.get(0).getOrgId()).append("-");
                }
                if (STAGE.equals(each.getStage())) {
                    inboundData.setCompanyOrgId(inboundData.getOrgId());
                } else {
                    for (int i = orgDepids.length - 1; i >= 0; --i) {
                        UmcLdOrganizationPo umcLdOrganizationPO;
                        List<UmcLdOrganizationPo> umcLdOrganizationPOS = umcLdOrganizationMap.get(orgDepids[i]);
                        if (CollectionUtils.isEmpty(umcLdOrganizationPOS) || !STAGE.equals((umcLdOrganizationPO = umcLdOrganizationPOS.get(0)).getStage())) continue;
                        inboundData.setCompanyOrgId(umcLdOrganizationPO.getOrgId());
                        break;
                    }
                }
            }
            inboundData.setOrgTreePath(orgTreePath.toString());
        }
        orgDepids = inboundData.getOrgTreePath().split("-");
        inboundData.setDeep(Integer.valueOf(orgDepids.length));
        inboundData.setOrgName(each.getOrgShortName());
        if (STAGE.equals(each.getStage())) {
            inboundData.setOrgType(UmcCommConstants.OrgType.COMPANY);
        } else if ("2".equals(each.getStage())) {
            inboundData.setOrgType(UmcCommConstants.OrgType.DEPARTMENT);
        } else {
            inboundData.setOrgType(UmcCommConstants.OrgType.DEPARTMENT);
        }
        inboundData.setSort(each.getOrgOrder());
        if (!StringUtils.isBlank((CharSequence)each.getCreateTimeStamp())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = sdf.parse(each.getCreateTimeStamp());
                inboundData.setCreateTime(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isBlank((CharSequence)each.getModifyTimeStamp())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = sdf.parse(each.getModifyTimeStamp());
                inboundData.setUpdateTime(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        inboundData.setDelStatus("0");
        if (STAGE.equals(each.getOrgStatus())) {
            inboundData.setStatus(STAGE);
        } else {
            inboundData.setStatus("0");
        }
        inboundData.setIntExtProperty("101");
        inboundData.setTradeCapacity(STAGE);
        inboundData.setIsProfessionalOrg(STAGE);
        String code = HanyuPinyinHelper.getPinyinString((String)each.getOrgShortName());
        inboundData.setOrgCode(each.getOrgDepid());
        inboundData.setAlias(code);
        inboundData.setIsAbroad("0");
        inboundData.setOrgClass("4");
        inboundData.setTenantId(Long.valueOf(10000L));
        return inboundData;
    }
}

