/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.tydic.dyc.umc.model.score.DycUmcSupplierResetRatingRulesBusiService;
import com.tydic.dyc.umc.model.score.sub.DycUmcSupplierResetRatingRulesBusiReqBo;
import com.tydic.dyc.umc.model.score.sub.DycUmcSupplierResetRatingRulesBusiRspBo;
import com.tydic.dyc.umc.repository.dao.SupplierAssessmentRatingRulesMapper;
import com.tydic.dyc.umc.repository.po.SupplierAssessmentRatingRulesPO;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUmcSupplierResetRatingRulesBusiServiceImpl
implements DycUmcSupplierResetRatingRulesBusiService {
    @Autowired
    private SupplierAssessmentRatingRulesMapper supplierAssessmentRatingRulesMapper;
    @Value(value="${rating_rules_reset_default:false}")
    private Boolean rating_rules_reset_default;
    private static final String MONTH = "1";
    private static final String JIDU = "2";
    private static final String YEAR = "3";

    public DycUmcSupplierResetRatingRulesBusiRspBo resetRatingRules(DycUmcSupplierResetRatingRulesBusiReqBo reqBo) {
        SupplierAssessmentRatingRulesPO supplierAssessmentRatingRulesPO;
        LocalDateTime currentTime = this.rating_rules_reset_default != false ? LocalDateTime.now() : LocalDateTime.of((int)reqBo.getYear(), reqBo.getMonth(), (int)reqBo.getDay(), (int)reqBo.getHour(), (int)reqBo.getMinute(), (int)reqBo.getSeconds());
        LocalDate localDate = LocalDateTime.now().toLocalDate();
        LocalDateTime firstMonthTime = LocalDateTime.of(localDate.with(TemporalAdjusters.firstDayOfMonth()), LocalTime.MIN);
        LocalDateTime firstYearTime = LocalDateTime.of(localDate.with(TemporalAdjusters.firstDayOfYear()), LocalTime.MIN);
        Date currentQuarterEndTime = DycUmcSupplierResetRatingRulesBusiServiceImpl.getCurrentQuarterStartTime();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LocalDateTime firstJiduTime = LocalDateTime.parse(simpleDateFormat.format(currentQuarterEndTime), df);
        if (ChronoUnit.DAYS.between(firstMonthTime, currentTime) == 0L) {
            supplierAssessmentRatingRulesPO = new SupplierAssessmentRatingRulesPO();
            supplierAssessmentRatingRulesPO.setRatingRulesCycle(MONTH);
            supplierAssessmentRatingRulesPO.setCreateStatus(MONTH);
            this.supplierAssessmentRatingRulesMapper.update(supplierAssessmentRatingRulesPO);
        }
        if (ChronoUnit.DAYS.between(firstYearTime, currentTime) == 0L) {
            supplierAssessmentRatingRulesPO = new SupplierAssessmentRatingRulesPO();
            supplierAssessmentRatingRulesPO.setRatingRulesCycle(YEAR);
            supplierAssessmentRatingRulesPO.setCreateStatus(MONTH);
            this.supplierAssessmentRatingRulesMapper.update(supplierAssessmentRatingRulesPO);
        }
        if (ChronoUnit.DAYS.between(firstMonthTime, currentTime) == 0L) {
            supplierAssessmentRatingRulesPO = new SupplierAssessmentRatingRulesPO();
            supplierAssessmentRatingRulesPO.setRatingRulesCycle(JIDU);
            supplierAssessmentRatingRulesPO.setCreateStatus(MONTH);
            this.supplierAssessmentRatingRulesMapper.update(supplierAssessmentRatingRulesPO);
        }
        DycUmcSupplierResetRatingRulesBusiRspBo rspBo = new DycUmcSupplierResetRatingRulesBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public static Date getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = null;
        try {
            if (currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth <= 9) {
                c.set(2, 6);
            } else if (currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }
}

