/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.tydic.dyc.umc.model.feedback.UmcEnterpriseOrgManageAtomService;
import com.tydic.dyc.umc.model.feedback.qrybo.UmcQryOrgFullNameByOrgIdsAtomReqBO;
import com.tydic.dyc.umc.model.feedback.sub.UmcQryOrgFullNameByOrgIdsAtomRspBO;
import com.tydic.dyc.umc.repository.dao.ExtEnterpriseOrgMapper;
import com.tydic.dyc.umc.repository.po.EnterpriseOrgPO;
import com.tydic.dyc.umc.service.feedback.bo.UmcEnterpriseOrgBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcEnterpriseOrgManageAtomServiceImpl
implements UmcEnterpriseOrgManageAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(UmcEnterpriseOrgManageAtomServiceImpl.class);
    @Autowired
    private ExtEnterpriseOrgMapper extEnterpriseOrgMapper;

    public UmcQryOrgFullNameByOrgIdsAtomRspBO qryOrgFullNameByOrgIds(UmcQryOrgFullNameByOrgIdsAtomReqBO atomReqBO) {
        UmcQryOrgFullNameByOrgIdsAtomRspBO result = new UmcQryOrgFullNameByOrgIdsAtomRspBO();
        HashMap<Long, UmcEnterpriseOrgBO> orgIdAndOrgBOMap = new HashMap<Long, UmcEnterpriseOrgBO>();
        if (CollectionUtils.isEmpty((Collection)atomReqBO.getOrgIds())) {
            result.setRespCode("161000");
            result.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
        enterpriseOrgPO.setOrgIds(atomReqBO.getOrgIds());
        List<UmcEnterpriseOrgBO> enterpriseOrgBOs = this.extEnterpriseOrgMapper.getListByIds(enterpriseOrgPO);
        if (CollectionUtils.isEmpty(enterpriseOrgBOs)) {
            result.setRespCode("161000");
            result.setRespDesc("\u5165\u53c2\u673a\u6784\u4e0d\u5b58\u5728");
            return result;
        }
        HashMap<Long, String> orgIdAndOrgTreeMap = new HashMap<Long, String>();
        HashSet<Long> orgSet = new HashSet<Long>();
        for (UmcEnterpriseOrgBO umcEnterpriseOrgBO : enterpriseOrgBOs) {
            String[] orgTrees;
            orgIdAndOrgBOMap.put(umcEnterpriseOrgBO.getOrgId(), umcEnterpriseOrgBO);
            orgIdAndOrgTreeMap.put(umcEnterpriseOrgBO.getOrgId(), "-" + umcEnterpriseOrgBO.getOrgTreePath());
            for (String orgId : orgTrees = umcEnterpriseOrgBO.getOrgTreePath().split("-")) {
                orgSet.add(Long.parseLong(orgId));
            }
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (Long orgIdItem : orgSet) {
            orgIds.add(orgIdItem);
        }
        EnterpriseOrgPO enterpriseOrgPO2 = new EnterpriseOrgPO();
        enterpriseOrgPO2.setOrgIds(orgIds);
        List<UmcEnterpriseOrgBO> umcEnterpriseOrgBOS = this.extEnterpriseOrgMapper.getListByOrgPO(enterpriseOrgPO2);
        if (!CollectionUtils.isEmpty(umcEnterpriseOrgBOS)) {
            HashMap<String, String> orgIdAndOrgNameMap = new HashMap<String, String>();
            for (UmcEnterpriseOrgBO bo : umcEnterpriseOrgBOS) {
                orgIdAndOrgNameMap.put(bo.getOrgId().toString(), bo.getOrgName());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u673a\u6784\u540d\u79f0map:" + orgIdAndOrgNameMap);
            }
            for (Long sourceOrgId : orgIdAndOrgTreeMap.keySet()) {
                String orgTree = (String)orgIdAndOrgTreeMap.get(sourceOrgId);
                String[] orgTrees = orgTree.split("-");
                String orgTreeName = "";
                for (String orgIdStr : orgTrees) {
                    if (orgIdStr.equals("1")) continue;
                    orgTreeName = orgIdAndOrgNameMap.get(orgIdStr) != null ? orgTreeName + "-" + (String)orgIdAndOrgNameMap.get(orgIdStr) : orgTreeName + "-" + orgIdStr;
                }
                orgTreeName = !StringUtils.isBlank((CharSequence)orgTreeName) && orgTreeName.length() > 1 ? orgTreeName.substring(2, orgTreeName.length()) : "root";
                ((UmcEnterpriseOrgBO)orgIdAndOrgBOMap.get(sourceOrgId)).setOrgFullName(orgTreeName);
            }
        }
        result.setOrgIdAndOrgBOMap(orgIdAndOrgBOMap);
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return result;
    }
}

