/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.authority.model.user.qrybo.AuthUserRoleStationListQryBO;
import com.tydic.dyc.authority.model.user.sub.AuthUserRoleStationListDo;
import com.tydic.dyc.authority.model.user.sub.AuthUserRoleStationListRspDO;
import com.tydic.dyc.authority.repository.dao.SysCustInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysUserInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysUserTagRelMapper;
import com.tydic.dyc.authority.repository.po.SysCustInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserTagRelPo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.user.AuthDealUserRoleService;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserRoleReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthDealUserRoleRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcEnumConstant;
import com.tydic.dyc.umc.model.ldUser.UmcQryUserInfoQryDo;
import com.tydic.dyc.umc.model.ldUser.qrybo.SyncCsUserBo;
import com.tydic.dyc.umc.model.ldUser.qrybo.UmcCustServiceUsersBo;
import com.tydic.dyc.umc.model.ldUser.qrybo.UmcGetInvoiceCheckQryBo;
import com.tydic.dyc.umc.model.ldUser.qrybo.UmcQryUserInfoQryBo;
import com.tydic.dyc.umc.model.ldUser.qrybo.UmcUserAndOrgInfoQryBo;
import com.tydic.dyc.umc.model.ldUser.qrybo.UmcUserRoleInfoQryBo;
import com.tydic.dyc.umc.model.ldUser.sub.UmcMemberInfo;
import com.tydic.dyc.umc.model.ldUser.sub.UmcRoleInfo;
import com.tydic.dyc.umc.model.ldUser.sub.UmcSynUserInfo;
import com.tydic.dyc.umc.model.ldUser.sub.UmcUserAndOrgInfo;
import com.tydic.dyc.umc.repository.UmcLdUserInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcDealMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcAuthRoleInfoPo;
import com.tydic.dyc.umc.repository.po.UmcCustInfoPo;
import com.tydic.dyc.umc.repository.po.UmcCustUserSubPo;
import com.tydic.dyc.umc.repository.po.UmcLdOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserAndOrgPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserTagRelPo;
import com.tydic.dyc.umc.repository.utils.SSLClient;
import com.tydic.dyc.umc.utils.UmcBusinessException;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcLdUserInfoRepositoryImpl
implements UmcLdUserInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcLdUserInfoRepositoryImpl.class);
    @Autowired
    private UmcDealMapper umcDealMapper;
    @Autowired
    private UmcCustInfoMapper umcCustInfoMapper;
    @Autowired
    private SysCustInfoMapper sysCustInfoMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private SysUserInfoMapper sysUserInfoMapper;
    @Autowired
    private UmcUserTagRelMapper umcUserTagRelMapper;
    @Autowired
    private SysUserTagRelMapper sysUserTagRelMapper;
    @Autowired
    private AuthDealUserRoleService authDealUserRoleService;
    @Value(value="${custServiceEnable:false}")
    private boolean custServiceEnableExt;
    public static final String VALID_STATUS = "0";
    private static final String CS_USER_TYPE_NORMAL = "1";
    @Value(value="${CUST_SERVICE_IP:http://39.106.83.78/improxy}")
    private String custServiceUrl;

    public void synchronizeUser(List<UmcSynUserInfo> rows) {
        for (UmcSynUserInfo each : rows) {
            if (StringUtils.isBlank((CharSequence)each.getUserid())) continue;
            UmcMemberInfo inboundData = this.dealMemberInfo(each);
            this.dealUmcCustInfo(inboundData);
            if (!StringUtils.isBlank((CharSequence)each.getParttimepost())) {
                String[] positionIds = each.getParttimepost().split(";");
                List<Long> userIds = this.umcDealMapper.qryUserIdByJobCodes(positionIds, inboundData.getMemId());
                if (!CollectionUtils.isEmpty(userIds)) {
                    this.umcDealMapper.delSysUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserInfo(userIds);
                    this.umcDealMapper.delSysUserInfo(userIds);
                }
                for (int i = 0; i < positionIds.length; ++i) {
                    UmcUserInfoPo qryUmcCustInfoPo = new UmcUserInfoPo();
                    qryUmcCustInfoPo.setMainCustId(inboundData.getMemId());
                    qryUmcCustInfoPo.setExtField2(positionIds[i]);
                    qryUmcCustInfoPo.setIsMain(VALID_STATUS);
                    log.debug("\u67e5\u8be2\u5165\u53c2{}", (Object)qryUmcCustInfoPo);
                    UmcUserInfoPo umcUserInfoPo = this.umcUserInfoMapper.getModelBy(qryUmcCustInfoPo);
                    if (umcUserInfoPo == null) {
                        Long userId = Sequence.getInstance().nextId();
                        this.dealUmcUserInfo(inboundData, positionIds[i], userId, VALID_STATUS);
                        continue;
                    }
                    UmcUserInfoPo whereParam = new UmcUserInfoPo();
                    whereParam.setUserId(umcUserInfoPo.getUserId());
                    UmcUserInfoPo setParam = new UmcUserInfoPo();
                    setParam.setStopStatus(inboundData.getStopStatus());
                    this.umcUserInfoMapper.updateBy(setParam, whereParam);
                    SysUserInfoPo whereParam2 = new SysUserInfoPo();
                    whereParam2.setUserId(umcUserInfoPo.getUserId());
                    SysUserInfoPo setParam2 = new SysUserInfoPo();
                    setParam2.setUserStatus(inboundData.getState());
                    this.sysUserInfoMapper.updateBy(setParam2, whereParam2);
                }
            } else {
                List<Long> userIds = this.umcDealMapper.qryPluralismByMainCustId(inboundData.getMemId());
                if (!CollectionUtils.isEmpty(userIds)) {
                    this.umcDealMapper.delSysUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserTagRel(userIds);
                    this.umcDealMapper.delUmcUserInfo(userIds);
                    this.umcDealMapper.delSysUserInfo(userIds);
                }
            }
            UmcUserInfoPo qryUmcUserInfoPo = new UmcUserInfoPo();
            qryUmcUserInfoPo.setIsMain(CS_USER_TYPE_NORMAL);
            qryUmcUserInfoPo.setMainCustId(inboundData.getMemId());
            UmcUserInfoPo modelBy = this.umcUserInfoMapper.getModelBy(qryUmcUserInfoPo);
            if (modelBy == null) {
                Long userId = Sequence.getInstance().nextId();
                this.dealUmcUserInfo(inboundData, inboundData.getPostCode(), userId, CS_USER_TYPE_NORMAL);
                continue;
            }
            this.updateUmcUserInfo(inboundData, modelBy.getUserId());
        }
    }

    private void updateUmcUserInfo(UmcMemberInfo inboundData, Long userId) {
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setUserId(userId);
        umcUserInfoPo.setCustId(inboundData.getMemId());
        umcUserInfoPo.setMainCustId(inboundData.getMemId());
        umcUserInfoPo.setTenantId(inboundData.getTenantId());
        umcUserInfoPo.setOrgId(inboundData.getOrgId());
        umcUserInfoPo.setOrgTreePath(inboundData.getOrgTreePath());
        umcUserInfoPo.setCompanyId(inboundData.getCompanyId());
        umcUserInfoPo.setUserType(inboundData.getUserType());
        umcUserInfoPo.setAuthorityType("auth:default:manage");
        umcUserInfoPo.setIsMain(CS_USER_TYPE_NORMAL);
        umcUserInfoPo.setStopStatus(inboundData.getStopStatus());
        umcUserInfoPo.setDelFlag(inboundData.getDelFlag());
        umcUserInfoPo.setCreateTime(inboundData.getCreateTime());
        umcUserInfoPo.setExtField2(inboundData.getPostCode());
        StrUtil.noNullStringAttr((Object)umcUserInfoPo);
        SysUserInfoPo sysUserInfoPo = new SysUserInfoPo();
        BeanUtils.copyProperties((Object)umcUserInfoPo, (Object)sysUserInfoPo);
        try {
            UmcUserInfoPo whereParam = new UmcUserInfoPo();
            whereParam.setUserId(userId);
            this.umcUserInfoMapper.updateBy(umcUserInfoPo, whereParam);
            SysUserInfoPo whereParam2 = new SysUserInfoPo();
            whereParam2.setUserId(userId);
            sysUserInfoPo.setUserStatus(inboundData.getState());
            sysUserInfoPo.setIsMain(CS_USER_TYPE_NORMAL);
            this.sysUserInfoMapper.updateBy(sysUserInfoPo, whereParam2);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u7528\u6237\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u4fee\u6539\u7528\u6237\u8868\u5931\u8d25!" + e.getMessage());
        }
    }

    private void dealUserTagRel(UmcMemberInfo inboundData, Long userId) {
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        Long relId = Sequence.getInstance().nextId();
        umcUserTagRelPo.setRelId(relId);
        umcUserTagRelPo.setUserId(userId);
        umcUserTagRelPo.setTenantId(inboundData.getTenantId());
        umcUserTagRelPo.setTagId(CS_USER_TYPE_NORMAL);
        umcUserTagRelPo.setIsDefalt(CS_USER_TYPE_NORMAL);
        umcUserTagRelPo.setDelFlag(inboundData.getDelFlag());
        StrUtil.noNullStringAttr((Object)umcUserTagRelPo);
        SysUserTagRelPo sysUserTagRelPo = (SysUserTagRelPo)UmcRu.js((Object)umcUserTagRelPo, SysUserTagRelPo.class);
        try {
            this.umcUserTagRelMapper.insert(umcUserTagRelPo);
            this.sysUserTagRelMapper.insert(sysUserTagRelPo);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u7528\u6237\u5728\u6240\u5c5e\u673a\u6784\u7684\u8eab\u4efd\u7c7b\u578b\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u7528\u6237\u5728\u6240\u5c5e\u673a\u6784\u7684\u8eab\u4efd\u7c7b\u578b\u8868\u5931\u8d25!");
        }
    }

    private void dealUmcUserInfo(UmcMemberInfo inboundData, String positionId, Long userId, String isMain) {
        log.debug("\u5c97\u4f4d\u7f16\u7801\u4e3a\uff1a{}", (Object)positionId);
        log.debug("\u662f\u5426\u662f\u4e3b\u7528\u6237\uff1a{}", (Object)isMain);
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setUserId(userId);
        umcUserInfoPo.setCustId(inboundData.getMemId());
        umcUserInfoPo.setMainCustId(inboundData.getMemId());
        umcUserInfoPo.setTenantId(inboundData.getTenantId());
        UmcLdOrgInfoPo qryUmcLdOrgInfoPo = new UmcLdOrgInfoPo();
        qryUmcLdOrgInfoPo.setJobCode(positionId);
        UmcLdOrgInfoPo enterpriseOrgByCondition = this.umcDealMapper.getEnterpriseOrgByCondition(qryUmcLdOrgInfoPo);
        log.debug("\u6839\u636e\u5c97\u4f4d\u7f16\u7801\u67e5\u8be2\u5230\u7684\u673a\u6784\u4fe1\u606f\u4e3a\uff1a{}", (Object)enterpriseOrgByCondition);
        if (enterpriseOrgByCondition != null) {
            umcUserInfoPo.setOrgId(enterpriseOrgByCondition.getOrgId());
            umcUserInfoPo.setOrgTreePath(enterpriseOrgByCondition.getOrgTreePath());
            umcUserInfoPo.setCompanyId(enterpriseOrgByCondition.getCompanyId());
            umcUserInfoPo.setUserType(inboundData.getUserType());
            umcUserInfoPo.setAuthorityType("auth:default:manage");
            umcUserInfoPo.setIsMain(isMain);
            umcUserInfoPo.setStopStatus(inboundData.getStopStatus());
            umcUserInfoPo.setDelFlag(inboundData.getDelFlag());
            umcUserInfoPo.setCreateTime(inboundData.getCreateTime());
            umcUserInfoPo.setExtField2(positionId);
            StrUtil.noNullStringAttr((Object)umcUserInfoPo);
            SysUserInfoPo sysUserInfoPo = new SysUserInfoPo();
            BeanUtils.copyProperties((Object)umcUserInfoPo, (Object)sysUserInfoPo);
            try {
                this.umcUserInfoMapper.insert(umcUserInfoPo);
                sysUserInfoPo.setUserStatus(inboundData.getState());
                sysUserInfoPo.setIsMain(isMain);
                this.sysUserInfoMapper.insert(sysUserInfoPo);
                AuthDealUserRoleReqBo authDealUserRoleReqBo = new AuthDealUserRoleReqBo();
                authDealUserRoleReqBo.setUserId(userId);
                ArrayList<AuthDistributeBo> authDistributeBos = new ArrayList<AuthDistributeBo>();
                AuthDistributeBo authDistributeBo = new AuthDistributeBo();
                authDistributeBo.setTenantId(inboundData.getTenantId());
                authDistributeBo.setRoleId(Long.valueOf(5L));
                authDistributeBo.setDisFlag(Integer.valueOf(1));
                authDistributeBo.setCreateOperId(userId);
                authDistributeBo.setCreateTime(new Date());
                authDistributeBos.add(authDistributeBo);
                authDealUserRoleReqBo.setAuthDistributeList(authDistributeBos);
                log.debug("\u7528\u6237\u6388\u6743\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)authDealUserRoleReqBo));
                AuthDealUserRoleRspBo authDealUserRoleRspBo = this.authDealUserRoleService.dealUserRole(authDealUserRoleReqBo);
                log.debug("\u7528\u6237\u6388\u6743\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)authDealUserRoleRspBo));
                if (!"0000".equals(authDealUserRoleRspBo.getRespCode())) {
                    throw new ZTBusinessException("\u4fee\u6539\u7528\u6237\u89d2\u8272\u4fe1\u606f\u5931\u8d25");
                }
                if (this.custServiceEnableExt) {
                    this.addSyncCsUser(inboundData, userId);
                }
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u7528\u6237\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new UmcBusinessException("8888", "\u64cd\u4f5c\u7528\u6237\u8868\u5931\u8d25!" + e.getMessage());
            }
            this.dealUserTagRel(inboundData, userId);
        } else {
            log.error("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u5c97\u4f4d\u6240\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u5c97\u4f4d\u7f16\u7801\u4e3a\uff1a{}", (Object)positionId);
        }
    }

    private void addSyncCsUser(UmcMemberInfo umcMemberInfo, Long userId) {
        SyncCsUserBo syncCsUserBo = new SyncCsUserBo();
        ArrayList<UmcCustServiceUsersBo> umcCustServiceUsersBos = new ArrayList<UmcCustServiceUsersBo>();
        syncCsUserBo.setTenantCode(Convert.toStr((Object)umcMemberInfo.getOrgId()));
        UmcCustServiceUsersBo umcCustServiceUsersBo = new UmcCustServiceUsersBo();
        umcCustServiceUsersBo.setExtUid(userId + "_1");
        umcCustServiceUsersBo.setUserType(CS_USER_TYPE_NORMAL);
        umcCustServiceUsersBo.setNickname(umcMemberInfo.getMemName2());
        HashMap<String, String> extDataMap = new HashMap<String, String>();
        extDataMap.put("memUserType", CS_USER_TYPE_NORMAL);
        extDataMap.put("purchaserId", Convert.toStr((Object)umcMemberInfo.getOrgId()));
        extDataMap.put("userId", Convert.toStr((Object)userId));
        umcCustServiceUsersBo.setExtData(JSON.toJSONString(extDataMap));
        umcCustServiceUsersBo.setName(umcMemberInfo.getRegAccount());
        umcCustServiceUsersBos.add(umcCustServiceUsersBo);
        syncCsUserBo.setUsers(umcCustServiceUsersBos);
        String reqString = JSON.toJSONString((Object)syncCsUserBo);
        String url = this.custServiceUrl + "/user-center/batch/add";
        log.debug("\u8c03\u7528\u7528\u6237\u5bfc\u5165\u63a5\u53e3\uff08\u6279\u91cf\uff09\u5165\u53c2----url:{}\nreqString: {}", (Object)url, (Object)reqString);
        String result = SSLClient.doPost(url, reqString);
        log.debug("\u8c03\u7528\u7528\u6237\u5bfc\u5165\u63a5\u53e3\uff08\u6279\u91cf\uff09\u51fa\u53c2----result:{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new ZTBusinessException("\u7528\u6237\u65b0\u589e\u5f02\u5e38");
        }
        if (!"0000".equals(JSON.parseObject((String)result).get((Object)"rspCode"))) {
            log.error("\u540c\u6b65\u5ba2\u670d\u7528\u6237\u5931\u8d25");
        }
    }

    private void dealUmcCustInfo(UmcMemberInfo inboundData) {
        UmcCustInfoPo umcCustInfoPo = new UmcCustInfoPo();
        umcCustInfoPo.setCustId(inboundData.getMemId());
        umcCustInfoPo.setWorkNo(inboundData.getWorkNo());
        umcCustInfoPo.setOfficePhone(inboundData.getOfficePhone());
        umcCustInfoPo.setStopStatus(inboundData.getStopStatus());
        umcCustInfoPo.setCustAffiliation(inboundData.getMemAffiliation());
        umcCustInfoPo.setCustType(inboundData.getUserType());
        umcCustInfoPo.setRegAccount(inboundData.getRegAccount());
        umcCustInfoPo.setRegMobile(inboundData.getRegMobile());
        umcCustInfoPo.setRegEmail(inboundData.getRegEmail());
        umcCustInfoPo.setHeadUrl(inboundData.getHeadUrl());
        umcCustInfoPo.setIsOnline(inboundData.getIsOnline());
        umcCustInfoPo.setCustStatus(inboundData.getState());
        umcCustInfoPo.setIsPasswdValid(inboundData.getIsPasswdValid());
        umcCustInfoPo.setMaxRepeatLoginNum(inboundData.getMaxRepeatLoginNum());
        umcCustInfoPo.setCustName(inboundData.getMemName2());
        umcCustInfoPo.setSex(inboundData.getSex());
        umcCustInfoPo.setBirthday(inboundData.getBirthday());
        umcCustInfoPo.setIsBlacklist(inboundData.getIsBlackList());
        umcCustInfoPo.setCreateTime(inboundData.getCreateTime());
        umcCustInfoPo.setUpdateTime(inboundData.getUpdateTime());
        umcCustInfoPo.setDelFlag(inboundData.getDelFlag());
        umcCustInfoPo.setCertType(inboundData.getCertType());
        umcCustInfoPo.setCertNo(inboundData.getCertNo());
        umcCustInfoPo.setExtField1(inboundData.getSource());
        umcCustInfoPo.setExtField2(inboundData.getPartTimePost());
        SysCustInfoPo sysCustInfoPo = new SysCustInfoPo();
        sysCustInfoPo.setCustId(inboundData.getMemId());
        sysCustInfoPo.setLoginName(umcCustInfoPo.getRegAccount());
        sysCustInfoPo.setCustCode(inboundData.getMemCode());
        sysCustInfoPo.setTenantId(inboundData.getTenantId());
        sysCustInfoPo.setCustName(umcCustInfoPo.getCustName());
        sysCustInfoPo.setCellPhone(umcCustInfoPo.getRegMobile());
        sysCustInfoPo.setCustEmail(umcCustInfoPo.getRegEmail());
        sysCustInfoPo.setCustStatus(umcCustInfoPo.getCustStatus());
        sysCustInfoPo.setCustSource(umcCustInfoPo.getExtField1());
        sysCustInfoPo.setCreateTime(umcCustInfoPo.getCreateTime());
        sysCustInfoPo.setDelFlag(umcCustInfoPo.getDelFlag());
        sysCustInfoPo.setPasswordEffDate(inboundData.getCreateTime());
        sysCustInfoPo.setExtField1(inboundData.getSource());
        StrUtil.noNullStringAttr((Object)umcCustInfoPo);
        StrUtil.noNullStringAttr((Object)sysCustInfoPo);
        SysCustInfoPo qrySysCustInfoPo = new SysCustInfoPo();
        qrySysCustInfoPo.setCustCode(inboundData.getMemCode());
        qrySysCustInfoPo = this.sysCustInfoMapper.getModelBy(qrySysCustInfoPo);
        try {
            if (qrySysCustInfoPo == null) {
                this.umcCustInfoMapper.insert(umcCustInfoPo);
                this.sysCustInfoMapper.insert(sysCustInfoPo);
            } else {
                UmcCustInfoPo whereParam = new UmcCustInfoPo();
                whereParam.setCustId(inboundData.getMemId());
                this.umcCustInfoMapper.updateBy(umcCustInfoPo, whereParam);
                SysCustInfoPo whereParam2 = new SysCustInfoPo();
                whereParam2.setCustId(inboundData.getMemId());
                this.sysCustInfoMapper.updateBy(sysCustInfoPo, whereParam2);
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5ba2\u6237\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new UmcBusinessException("8888", "\u64cd\u4f5c\u5ba2\u6237\u8868\u5931\u8d25!" + e.getMessage());
        }
    }

    private UmcMemberInfo dealMemberInfo(UmcSynUserInfo each) {
        Date date;
        SimpleDateFormat sdf;
        UmcMemberInfo memberPO = new UmcMemberInfo();
        memberPO.setUserId(Long.valueOf(CS_USER_TYPE_NORMAL + each.getUserid()));
        memberPO.setMemId(memberPO.getUserId());
        memberPO.setSource("2");
        memberPO.setMemCode(CS_USER_TYPE_NORMAL + each.getUserid());
        memberPO.setMainMemId(memberPO.getMemId());
        memberPO.setMemName2(each.getUsercn());
        memberPO.setMaxRepeatLoginNum(Integer.valueOf(5));
        memberPO.setRegEmail(each.getMail());
        memberPO.setRegMobile(each.getMobile());
        memberPO.setDelFlag(VALID_STATUS);
        if (VALID_STATUS.equals(each.getValidstatus())) {
            memberPO.setState(CS_USER_TYPE_NORMAL);
            memberPO.setStopStatus("01");
        } else {
            memberPO.setState(VALID_STATUS);
            memberPO.setStopStatus("00");
        }
        memberPO.setRegAccount(each.getAlias());
        if (UmcEnumConstant.Sex.Male.getCode().toString().equals(each.getGender())) {
            memberPO.setSex(UmcEnumConstant.Sex.Male.getCode());
        } else if (UmcEnumConstant.Sex.female.getCode().toString().equals(each.getGender())) {
            memberPO.setSex(UmcEnumConstant.Sex.female.getCode());
        } else {
            memberPO.setSex(UmcEnumConstant.Sex.Unknown.getCode());
        }
        memberPO.setOfficePhone(each.getTelephonenumber());
        memberPO.setWorkNo(each.getUsernumber());
        memberPO.setBirthday(each.getBirthdate());
        if (!StringUtils.isBlank((CharSequence)each.getUsercreatetime())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = sdf.parse(each.getUsercreatetime());
                memberPO.setCreateTime(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isBlank((CharSequence)each.getModifytimestamp())) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = sdf.parse(each.getModifytimestamp());
                memberPO.setUpdateTime(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        memberPO.setUserType("4");
        if (!StringUtils.isBlank((CharSequence)each.getDepartmentnumber())) {
            UmcLdOrgInfoPo qryUmcLdOrgInfoPo = new UmcLdOrgInfoPo();
            qryUmcLdOrgInfoPo.setOrgCode(each.getDepartmentnumber());
            UmcLdOrgInfoPo umcOrgInfoPo = this.umcDealMapper.getEnterpriseOrgByCondition(qryUmcLdOrgInfoPo);
            if (umcOrgInfoPo != null) {
                memberPO.setOrgId(umcOrgInfoPo.getOrgId());
                memberPO.setOrgTreePath(umcOrgInfoPo.getOrgTreePath());
                memberPO.setCompanyId(umcOrgInfoPo.getCompanyId());
            }
        }
        memberPO.setMemAffiliation("01");
        memberPO.setMemClassify("00");
        if (each.getPositionid() == null) {
            memberPO.setPostCode("");
        } else {
            memberPO.setPostCode(each.getPositionid());
        }
        memberPO.setPartTimePost(each.getParttimepost());
        memberPO.setIsOnline(UmcEnumConstant.IsOnline.NO.getCode());
        memberPO.setIsPasswdValid(UmcEnumConstant.IsPasswdValid.YES.getCode());
        memberPO.setIsBlackList(UmcEnumConstant.IsBlacklist.NO.getCode());
        memberPO.setMemLevel(UmcCommConstant.UmcDefaultValue.MEM_LEVEL);
        memberPO.setMaxRepeatLoginNum(UmcCommConstant.UmcDefaultValue.MAX_REPEAT_LOGIN_NUM);
        memberPO.setGrowValue(UmcCommConstant.UmcDefaultValue.GROW_VALUE);
        memberPO.setMemReputation(UmcCommConstant.UmcDefaultValue.MEM_REPUTATION);
        memberPO.setMemBalance(UmcCommConstant.UmcDefaultValue.MEM_BALANCE);
        memberPO.setTenantId(Long.valueOf(10000L));
        return memberPO;
    }

    public AuthUserRoleStationListRspDO userRoleStationList(AuthUserRoleStationListQryBO qryBO) {
        AuthUserRoleStationListRspDO rspBO = new AuthUserRoleStationListRspDO();
        rspBO.setRespCode("0000");
        Page page = new Page(qryBO.getPageNo(), qryBO.getPageSize());
        List<UmcCustUserSubPo> userOrgPath = this.umcDealMapper.getUserOrgPath(qryBO.getUserNameRel(), qryBO.getOrgIdRel(), qryBO.getQueryType(), (Page<UmcCustUserSubPo>)page);
        if (CollectionUtils.isEmpty(userOrgPath)) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        for (UmcCustUserSubPo each : userOrgPath) {
            if (!StringUtils.isNotBlank((CharSequence)each.getJobName())) continue;
            each.setCustName(each.getCustName() + "(" + each.getJobName() + ")");
        }
        rspBO.setRows(AuthRu.jsl(userOrgPath, AuthUserRoleStationListDo.class));
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(qryBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    public List<UmcUserAndOrgInfo> getUserAndOrgInfoList(UmcUserAndOrgInfoQryBo qryBo) {
        UmcUserAndOrgPo umcOrgInfoPo = (UmcUserAndOrgPo)UmcRu.js((Object)qryBo, UmcUserAndOrgPo.class);
        List<UmcUserAndOrgPo> umcOrgInfoPoList = this.umcDealMapper.getUserAndOrgInfoList(umcOrgInfoPo);
        return CollectionUtils.isEmpty(umcOrgInfoPoList) ? new ArrayList(0) : UmcRu.jsl(umcOrgInfoPoList, UmcUserAndOrgInfo.class);
    }

    public List<UmcRoleInfo> getRoleInfoListByUser(UmcUserRoleInfoQryBo qryBo) {
        List<UmcAuthRoleInfoPo> umcAuthRoleInfoPos = this.umcDealMapper.getRoleInfoListByUser(qryBo.getUserId());
        return CollectionUtils.isEmpty(umcAuthRoleInfoPos) ? new ArrayList(0) : UmcRu.jsl(umcAuthRoleInfoPos, UmcRoleInfo.class);
    }

    public List<UmcUserAndOrgInfo> qryManagerUserInfoList(UmcUserAndOrgInfoQryBo qryBo) {
        UmcUserAndOrgPo umcOrgInfoPo = (UmcUserAndOrgPo)UmcRu.js((Object)qryBo, UmcUserAndOrgPo.class);
        List<UmcUserAndOrgPo> umcOrgInfoPoList = this.umcDealMapper.qryManagerUserInfoList(umcOrgInfoPo);
        return CollectionUtils.isEmpty(umcOrgInfoPoList) ? new ArrayList(0) : UmcRu.jsl(umcOrgInfoPoList, UmcUserAndOrgInfo.class);
    }

    public List<UmcQryUserInfoQryDo> qryUserInfoListByUserIds(UmcQryUserInfoQryBo umcQryUserInfoQryBo) {
        UmcUserAndOrgPo umcOrgInfoPo = (UmcUserAndOrgPo)UmcRu.js((Object)umcQryUserInfoQryBo, UmcUserAndOrgPo.class);
        List<UmcUserAndOrgPo> umcOrgInfoPoList = this.umcDealMapper.qryUserInfoListByUserIds(umcOrgInfoPo);
        return CollectionUtils.isEmpty(umcOrgInfoPoList) ? new ArrayList(0) : UmcRu.jsl(umcOrgInfoPoList, UmcQryUserInfoQryDo.class);
    }

    public List<UmcUserAndOrgInfoQryBo> statisticsRegisterCust(UmcUserAndOrgInfoQryBo qryBo) {
        UmcUserAndOrgPo umcOrgInfoPo = (UmcUserAndOrgPo)UmcRu.js((Object)qryBo, UmcUserAndOrgPo.class);
        List<UmcUserAndOrgPo> umcOrgInfoPoList = this.umcDealMapper.statisticsRegisterCust(umcOrgInfoPo);
        return CollectionUtils.isEmpty(umcOrgInfoPoList) ? new ArrayList(0) : UmcRu.jsl(umcOrgInfoPoList, UmcUserAndOrgInfoQryBo.class);
    }

    public List<UmcUserAndOrgInfoQryBo> qryPositionNames(UmcUserAndOrgInfoQryBo qryBo) {
        UmcUserAndOrgPo umcOrgInfoPo = (UmcUserAndOrgPo)UmcRu.js((Object)qryBo, UmcUserAndOrgPo.class);
        List<UmcUserAndOrgPo> umcUserAndOrgPos = this.umcDealMapper.qryPositionNames(umcOrgInfoPo);
        return CollectionUtils.isEmpty(umcUserAndOrgPos) ? new ArrayList(0) : UmcRu.jsl(umcUserAndOrgPos, UmcUserAndOrgInfoQryBo.class);
    }

    public Integer getInvoiceCheck(UmcGetInvoiceCheckQryBo qryBo) {
        return this.umcDealMapper.getInvoiceCheck(qryBo);
    }

    public UmcUserAndOrgInfo qryUserInfoDetail(UmcUserAndOrgInfo qryBo) {
        UmcUserAndOrgPo umcOrgInfoPo = (UmcUserAndOrgPo)UmcRu.js((Object)qryBo, UmcUserAndOrgPo.class);
        UmcUserAndOrgPo umcUserAndOrgPo = this.umcDealMapper.qryUserInfoDetail(umcOrgInfoPo);
        return (UmcUserAndOrgInfo)UmcRu.js((Object)umcUserAndOrgPo, UmcUserAndOrgInfo.class);
    }
}

