/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgTagRel;
import com.tydic.dyc.umc.model.parkInfo.UmcEnterpriseLabelInfoDo;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcEnterpriseLabelInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoQryBo;
import com.tydic.dyc.umc.model.parkInfo.qrybo.UmcParkInfoVByOrgQryBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoByOrgSubBo;
import com.tydic.dyc.umc.model.parkInfo.sub.UmcParkInfoSubBo;
import com.tydic.dyc.umc.repository.UmcParkInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcParkInfoMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseLabelOrgPo;
import com.tydic.dyc.umc.repository.po.UmcParkInfoByOrgPo;
import com.tydic.dyc.umc.repository.po.UmcParkInfoPo;
import com.tydic.dyc.umc.utils.StrUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcParkInfoRepositoryImpl
implements UmcParkInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcParkInfoRepositoryImpl.class);
    @Autowired
    private UmcParkInfoMapper umcParkInfoMapper;

    public void createParkInfo(UmcParkInfoSubBo umcParkInfoSubBo) {
        UmcParkInfoPo umcParkInfoPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoSubBo, UmcParkInfoPo.class);
        this.umcParkInfoMapper.insert(umcParkInfoPo);
    }

    public BasePageRspBo<UmcParkInfoSubBo> getParkInfoList(UmcParkInfoQryBo umcParkInfoQryBo) {
        UmcParkInfoPo umcDataDailyOrdersPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoQryBo, UmcParkInfoPo.class);
        Page page = new Page(umcParkInfoQryBo.getPageNo(), umcParkInfoQryBo.getPageSize());
        List<UmcParkInfoPo> rows = this.umcParkInfoMapper.queryAllByLimit(umcDataDailyOrdersPo, (Page<UmcParkInfoPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcParkInfoSubBo.class) : new ArrayList(0));
        return rspBo;
    }

    public List<UmcParkInfoByOrgSubBo> getParkInfoListByOrgList(UmcParkInfoVByOrgQryBo umcParkInfoQryBo) {
        UmcParkInfoByOrgPo umcParkInfoPo = (UmcParkInfoByOrgPo)UmcRu.js((Object)umcParkInfoQryBo, UmcParkInfoByOrgPo.class);
        List<UmcParkInfoByOrgPo> rows = this.umcParkInfoMapper.getParkInfoListByOrgList(umcParkInfoPo);
        return ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcParkInfoByOrgSubBo.class) : new ArrayList(0);
    }

    public long qryParkInfoCount(UmcParkInfoQryBo umcParkInfoQryBo) {
        UmcParkInfoPo umcParkInfoPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoQryBo, UmcParkInfoPo.class);
        return this.umcParkInfoMapper.count(umcParkInfoPo);
    }

    public void updateParkInfo(UmcParkInfoSubBo umcParkInfoSubBo) {
        UmcParkInfoPo umcDataDailyOrdersPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoSubBo, UmcParkInfoPo.class);
        this.umcParkInfoMapper.update(umcDataDailyOrdersPo);
    }

    public List<UmcParkInfoSubBo> qryParkAndOrgCountInfo(UmcParkInfoQryBo umcParkInfoQryBo) {
        UmcParkInfoPo umcParkInfoPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoQryBo, UmcParkInfoPo.class);
        List<UmcParkInfoPo> rows = this.umcParkInfoMapper.qryParkAndOrgCountInfo(umcParkInfoPo);
        return ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcParkInfoSubBo.class) : new ArrayList(0);
    }

    public int deleteParkInfo(UmcParkInfoQryBo umcParkInfoQryBo) {
        UmcParkInfoPo umcParkInfoPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoQryBo, UmcParkInfoPo.class);
        return this.umcParkInfoMapper.deleteParkInfo(umcParkInfoPo);
    }

    public UmcParkInfoSubBo getParkInfoDetail(UmcParkInfoQryBo umcParkInfoQryBo) {
        UmcParkInfoPo umcParkInfoPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoQryBo, UmcParkInfoPo.class);
        UmcParkInfoPo umcParkInfoPo1 = this.umcParkInfoMapper.queryByCondition(umcParkInfoPo);
        return umcParkInfoPo1 == null ? null : (UmcParkInfoSubBo)UmcRu.js((Object)umcParkInfoPo1, UmcParkInfoSubBo.class);
    }

    public void createParkInfoBatch(List<UmcParkInfoSubBo> umcParkInfoSubBos) {
        ArrayList<UmcParkInfoPo> umcParkInfoPos = new ArrayList<UmcParkInfoPo>(umcParkInfoSubBos.size());
        for (UmcParkInfoSubBo umcParkInfoSubBo : umcParkInfoSubBos) {
            UmcParkInfoPo umcParkInfoPo = (UmcParkInfoPo)UmcRu.js((Object)umcParkInfoSubBo, UmcParkInfoPo.class);
            umcParkInfoPos.add(umcParkInfoPo);
        }
        this.umcParkInfoMapper.insertBatch(umcParkInfoPos);
    }

    public BasePageRspBo<UmcEnterpriseLabelInfoDo> qryEnterpriseLabelInfoListPage(UmcEnterpriseLabelInfoQryBo qryBo) {
        UmcEnterpriseLabelOrgPo umcEnterpriseOrgPo = (UmcEnterpriseLabelOrgPo)((Object)UmcRu.js((Object)qryBo, UmcEnterpriseLabelOrgPo.class));
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        StrUtil.noNullStringAttr((Object)((Object)umcEnterpriseOrgPo));
        List<UmcEnterpriseLabelOrgPo> umcEnterpriseOrgPoList = this.umcParkInfoMapper.qryEnterpriseLabelInfoListPage(umcEnterpriseOrgPo, (Page<UmcEnterpriseLabelOrgPo>)page);
        ArrayList<UmcEnterpriseLabelInfoDo> rows = new ArrayList<UmcEnterpriseLabelInfoDo>(umcEnterpriseOrgPoList.size());
        if (!CollectionUtils.isEmpty(umcEnterpriseOrgPoList)) {
            for (UmcEnterpriseLabelOrgPo enterpriseOrgPo : umcEnterpriseOrgPoList) {
                UmcEnterpriseLabelInfoDo enterpriseInfoDo = (UmcEnterpriseLabelInfoDo)UmcRu.js((Object)((Object)enterpriseOrgPo), UmcEnterpriseLabelInfoDo.class);
                UmcOrgInfo orgInfo = (UmcOrgInfo)UmcRu.js((Object)((Object)enterpriseOrgPo), UmcOrgInfo.class);
                orgInfo.setSupStatus(enterpriseOrgPo.getSupStatus());
                if (!StringUtils.isEmpty((CharSequence)enterpriseOrgPo.getOrgTagRel())) {
                    List<String> orgTagRels = Arrays.asList(enterpriseOrgPo.getOrgTagRel().split(","));
                    List orgTagRelList = orgTagRels.stream().map(item -> {
                        UmcOrgTagRel orgTagRel = new UmcOrgTagRel();
                        orgTagRel.setOrgId(enterpriseOrgPo.getOrgId());
                        orgTagRel.setTagId(item);
                        return orgTagRel;
                    }).collect(Collectors.toList());
                    orgInfo.setOrgTagRelList(orgTagRelList);
                }
                enterpriseInfoDo.setOrgInfo(orgInfo);
                rows.add(enterpriseInfoDo);
            }
        }
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcEnterpriseLabelInfoDo.class) : new ArrayList(0));
        return rspBo;
    }
}

