/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.score.UmcSupMisconductAppealBusiService;
import com.tydic.dyc.umc.model.score.qrybo.UmcSupMisconductAppealBusiReqBO;
import com.tydic.dyc.umc.model.score.sub.UmcSupMisconductAppealBusiRspBO;
import com.tydic.dyc.umc.repository.dao.OhaotianOrderSequenceMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductDescMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.po.OhaotianOrderSequencePO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductDescPO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcSupMisconductAppealBusiServiceImpl
implements UmcSupMisconductAppealBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupMisconductAppealBusiServiceImpl.class);
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private SupplierMisconductDescMapper supplierMisconductDescMapper;
    @Autowired
    private OhaotianOrderSequenceMapper ohaotianOrderSequenceMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Resource(name="supplierMisconductSequencePager")
    private OrderSequence supplierMisconductSequencePager;

    public UmcSupMisconductAppealBusiRspBO supMisconductAppeal(UmcSupMisconductAppealBusiReqBO reqBO) {
        UmcSupMisconductAppealBusiRspBO rspBO = new UmcSupMisconductAppealBusiRspBO();
        SupplierMisconductPO smPO = new SupplierMisconductPO();
        Long serialNumber = this.getRegAccountSequencePager();
        if (serialNumber >= 99L) {
            OhaotianOrderSequencePO ohaotianOrderSequencePO = new OhaotianOrderSequencePO();
            ohaotianOrderSequencePO.setId(7L);
            ohaotianOrderSequencePO.setCurrentValue(1L);
            int update = this.ohaotianOrderSequenceMapper.updateByCondition(ohaotianOrderSequencePO);
            if (update < 1) {
                throw new BaseBusinessException("163001", "\u5e8f\u5217\u5316\u8868\u4fee\u6539\u5931\u8d25\uff01");
            }
            serialNumber = 1L;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHH");
        String appealCode = "SX" + df.format(LocalDateTime.now()) + String.format("%02d", serialNumber);
        BeanUtils.copyProperties((Object)reqBO, (Object)smPO);
        smPO.setAppealCode(appealCode);
        smPO.setAppealTime(new Date());
        smPO.setAppealId(reqBO.getUserId());
        smPO.setAppealName(reqBO.getUserName());
        smPO.setAppealStatus(reqBO.getAppealStatus());
        smPO.setMisconductStatus(reqBO.getMisconductStatus());
        smPO.setOrgId(null);
        smPO.setOrgName(null);
        this.supplierMisconductMapper.updateByPrimaryKeySelective(smPO);
        SupplierMisconductDescPO smdPO = new SupplierMisconductDescPO();
        smdPO.setMisconductId(reqBO.getMisconductId());
        smdPO.setAppealDesc(reqBO.getAppealDesc());
        this.supplierMisconductDescMapper.updateByPrimaryKeySelective(smdPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private long getRegAccountSequencePager() {
        try {
            return this.supplierMisconductSequencePager.nextId();
        }
        catch (Exception e) {
            throw new BaseBusinessException("163069", "\u83b7\u53d6\u4e0d\u826f\u8bb0\u5f55\u7f16\u7801\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean createProcess(Long misconductId, SupplierMisconductPO supplierMisconductPO, UmcSupMisconductAppealBusiReqBO reqBO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(UmcCommConstants.AuditObjType.SUPPLIER_MIS_APPEAL_AUDIT);
        approvalObjBO.setObjId(misconductId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(UmcCommConstants.AuditObjType.SUPPLIER_MIS_APPEAL_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(misconductId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u4f9b\u5e94\u5546\u5931\u4fe1\u884c\u4e3a\u7533\u8bc9\u63d0\u4ea4\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setProcDefKey("supplier_misconduct_appeal_approval");
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(supplierMisconductPO.getOrgName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(supplierMisconductPO.getAppealId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(supplierMisconductPO.getAppealName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.error("\u5f00\u59cb\u8c03\u7528\u5ba1\u6279-----");
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        uacNoTaskAuditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BaseBusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            return false;
        }
        return uacNoTaskAuditCreateRspBO.getFinish() == false;
    }
}

