/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.rectification.UmcSupplierRectificationRequireBusiService;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierRectificationAuditBusiReqBO;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierRectificationLogBusiReqPageBO;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierRectificationPlanDetailBusiReqBO;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierRectificationRequireBusiReqBO;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierRectificationRequireBusiReqPageBO;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierRectificationRequireConfirmBusiReqBO;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierSubmitRectificationPlanBusiReqBO;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcSupplierSubmitRectificationRequireBusiReqBO;
import com.tydic.dyc.umc.model.rectification.sub.UmcSupplierRectificationLogBusiRspPageBO;
import com.tydic.dyc.umc.model.rectification.sub.UmcSupplierRectificationPlanDetailBusiRspBO;
import com.tydic.dyc.umc.model.rectification.sub.UmcSupplierRectificationRequireBusiPageRspBO;
import com.tydic.dyc.umc.model.rectification.sub.UmcSupplierRectificationRequireBusiRspBO;
import com.tydic.dyc.umc.model.rectification.sub.UmcSupplierRectificationTemplateBusiRspBO;
import com.tydic.dyc.umc.repository.dao.AssessmentScoreRecordTargetMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierRectificationPlanMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierRectificationRequireMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierRectificationRequireScoreContactMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierRectificationScoreContactMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierRectificationTemplateMapper;
import com.tydic.dyc.umc.repository.po.AssessmentScoreRecordTargetPO;
import com.tydic.dyc.umc.repository.po.ExtUmcSupplierInfoPO;
import com.tydic.dyc.umc.repository.po.SupplierRectificationScoreContactPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierRectificationLogPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierRectificationPlanPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierRectificationRequirePO;
import com.tydic.dyc.umc.repository.po.UmcSupplierRectificationRequireScoreContactPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierRectificationTemplatePO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcRspBaseBO;
import com.tydic.dyc.umc.service.rectification.bo.RectificationTemplateBO;
import com.tydic.dyc.umc.service.rectification.bo.UmcSupplierRectificationLogBO;
import com.tydic.dyc.umc.service.rectification.bo.UmcSupplierRectificationPlanBO;
import com.tydic.dyc.umc.service.rectification.bo.UmcSupplierRectificationRequireAbilityReqPageBO;
import com.tydic.dyc.umc.service.rectification.bo.UmcSupplierRectificationRequireBO;
import com.tydic.dyc.umc.service.rectification.bo.UmcSupplierRectificationTemplateBO;
import com.tydic.dyc.umc.service.rectification.bo.supplierRatingDetailBO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UmcSupplierRectificationRequireBusiServiceImpl
implements UmcSupplierRectificationRequireBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupplierRectificationRequireBusiServiceImpl.class);
    @Autowired
    private UmcSupplierInfoMapper umcSupplierInfoMapper;
    @Autowired
    private UmcSupplierRectificationRequireMapper umcSupplierRectificationRequireMapper;
    @Autowired
    private UmcSupplierRectificationTemplateMapper umcSupplierRectificationTemplateMapper;
    @Autowired
    private UmcSupplierRectificationPlanMapper umcSupplierRectificationPlanMapper;
    @Autowired
    private UmcSupplierRectificationScoreContactMapper umcSupplierRectificationScoreContactMapper;
    @Autowired
    private AssessmentScoreRecordTargetMapper assessmentScoreRecordTargetMapper;
    @Autowired
    private UmcSupplierRectificationRequireScoreContactMapper umcSupplierRectificationRequireScoreContactMapper;
    private static final Sequence sequece = Sequence.getInstance();

    public UmcRspBaseBO auditRectification(UmcSupplierRectificationAuditBusiReqBO reqBO) {
        UmcRspBaseBO rspBaseBO = new UmcRspBaseBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getRectificationPlanId()) || ObjectUtils.isEmpty((Object)reqBO.getRectificationResult())) {
            rspBaseBO.setRespDesc("\u4f20\u5165\u53c2\u6570\u6709\u8bef\uff01");
            rspBaseBO.setRespCode("161000");
            return rspBaseBO;
        }
        UmcSupplierRectificationPlanPO planPO = new UmcSupplierRectificationPlanPO();
        UmcSupplierRectificationRequirePO requirePO = new UmcSupplierRectificationRequirePO();
        requirePO.setStatus(reqBO.getRectificationResult());
        requirePO.setRectificationId(reqBO.getRectificationId());
        planPO.setRectificationPlanId(reqBO.getRectificationPlanId());
        planPO.setRectificationResult(reqBO.getRectificationResult());
        planPO.setRectificationConfirmDes(reqBO.getRectificationConfirmDes());
        try {
            this.umcSupplierRectificationPlanMapper.updateByPrimaryKeySelective(planPO);
            this.umcSupplierRectificationRequireMapper.updateByPrimaryKeySelective(requirePO);
            SupplierRectificationScoreContactPO scoreContactPO = new SupplierRectificationScoreContactPO();
            scoreContactPO.setSupplierId(reqBO.getSupplierId());
            scoreContactPO.setSupplierRatingId(reqBO.getSupplierRatingId());
            scoreContactPO.setStatus(reqBO.getRectificationResult());
            this.umcSupplierRectificationRequireScoreContactMapper.updateBySelect(scoreContactPO);
            UmcSupplierRectificationLogPO logPO = new UmcSupplierRectificationLogPO();
            logPO.setCauseDes(reqBO.getRectificationConfirmDes());
            logPO.setCreateTime(new Date());
            logPO.setUpdateTime(new Date());
            logPO.setRectificationResult(reqBO.getRectificationResult());
            UmcSupplierRectificationPlanPO plan = this.umcSupplierRectificationPlanMapper.selectByPrimaryKey(reqBO.getRectificationPlanId());
            logPO.setAnnexFile(plan.getAnnexFile());
            logPO.setSupplierId(plan.getSupplierId());
            logPO.setRectificationPlanDes(plan.getRectificationPlanDes());
            logPO.setId(sequece.nextId());
            logPO.setSupplierName(plan.getSupplierName());
            this.umcSupplierRectificationPlanMapper.insertLog(logPO);
            rspBaseBO.setRespCode("0000");
            rspBaseBO.setRespDesc("\u6210\u529f");
            return rspBaseBO;
        }
        catch (Exception e) {
            log.error("-----------auditRectification ERROR----------" + e.getMessage());
            throw new BaseBusinessException("163118", "\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public UmcSupplierRectificationPlanDetailBusiRspBO queryPlanDetail(UmcSupplierRectificationPlanDetailBusiReqBO reqBO) {
        UmcSupplierRectificationPlanDetailBusiRspBO rspBO = new UmcSupplierRectificationPlanDetailBusiRspBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId()) || ObjectUtils.isEmpty((Object)reqBO.getSupplierRatingId())) {
            rspBO.setRespCode("161000");
            rspBO.setRespDesc("supplierId \u6216 supplierRatingId \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UmcSupplierRectificationPlanPO planPO = this.umcSupplierRectificationPlanMapper.selectRectificationPlanDetail(reqBO.getSupplierId(), reqBO.getSupplierRatingId());
        if (!ObjectUtils.isEmpty((Object)planPO.getRectificationResult()) && planPO.getRectificationResult() == 1) {
            planPO.setRectificationResultStr("\u901a\u8fc7");
        }
        if (!ObjectUtils.isEmpty((Object)planPO.getRectificationResult()) && planPO.getRectificationResult() == 2) {
            planPO.setRectificationResultStr("\u4e0d\u901a\u8fc7");
        }
        UmcSupplierRectificationPlanBO rectificationPlanBO = new UmcSupplierRectificationPlanBO();
        BeanUtils.copyProperties((Object)planPO, (Object)rectificationPlanBO);
        if (!ObjectUtils.isEmpty((Object)rectificationPlanBO.getAnnexFile())) {
            String annexFileStr = rectificationPlanBO.getAnnexFile();
            List list = (List)JSON.parseObject((String)annexFileStr, List.class);
            rectificationPlanBO.setAnnexFileBOs(list);
        }
        rspBO.setUmcSupplierRectificationPlanBO(rectificationPlanBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public UmcSupplierRectificationLogBusiRspPageBO queryLogs(UmcSupplierRectificationLogBusiReqPageBO reqBO) {
        UmcSupplierRectificationLogBusiRspPageBO rspBO = new UmcSupplierRectificationLogBusiRspPageBO();
        rspBO.setRespCode("0000");
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new BaseBusinessException("161000", "supplierId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<UmcSupplierRectificationLogPO> logPOs = this.umcSupplierRectificationPlanMapper.queryLogs(reqBO.getSupplierId(), page);
        if (!CollectionUtils.isEmpty(logPOs) || logPOs.size() > 0) {
            List umcLogBOS = logPOs.stream().map(PO -> {
                UmcSupplierRectificationLogBO umcSupplierRectificationLogBO = new UmcSupplierRectificationLogBO();
                BeanUtils.copyProperties((Object)PO, (Object)umcSupplierRectificationLogBO);
                if (!ObjectUtils.isEmpty((Object)PO.getRectificationResult()) && PO.getRectificationResult() == 1) {
                    umcSupplierRectificationLogBO.setRectificationResultStr("\u901a\u8fc7");
                }
                if (!ObjectUtils.isEmpty((Object)PO.getRectificationResult()) && PO.getRectificationResult() == 2) {
                    umcSupplierRectificationLogBO.setRectificationResultStr("\u4e0d\u901a\u8fc7");
                }
                return umcSupplierRectificationLogBO;
            }).collect(Collectors.toList());
            rspBO.setRows(umcLogBOS);
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setRespCode("0000");
            return rspBO;
        }
        rspBO.setRespDesc("\u67e5\u8be2\u5217\u8868\u4e3a\u7a7a\uff01");
        return rspBO;
    }

    public UmcSupplierRectificationRequireBusiPageRspBO listRectificationRequire(UmcSupplierRectificationRequireBusiReqPageBO reqBO) {
        UmcSupplierRectificationRequireBusiPageRspBO rspBO = new UmcSupplierRectificationRequireBusiPageRspBO();
        reqBO.setSupplierId(reqBO.getSupId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        UmcSupplierRectificationRequireAbilityReqPageBO busiReqBO = new UmcSupplierRectificationRequireAbilityReqPageBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        busiReqBO.setSupplierId(reqBO.getOrgIdIn());
        List<UmcSupplierRectificationRequireBO> requireBOS = this.umcSupplierRectificationRequireMapper.querySelect(busiReqBO, page);
        List rectificationRequireBOS = requireBOS.stream().map(o -> {
            if (o.getStatus() == 0) {
                o.setStatusDes("\u5f85\u786e\u8ba4");
            }
            if (o.getStatus() == 1) {
                o.setStatusDes("\u901a\u8fc7");
            }
            if (o.getStatus() == 2) {
                o.setStatusDes("\u4e0d\u901a\u8fc7");
            }
            if (o.getStatus() == 3) {
                o.setStatusDes("\u5ba1\u6838\u4e2d");
            }
            if (o.getStatus() == 4) {
                o.setStatusDes("\u6574\u6539\u4e2d");
            }
            UmcSupplierRectificationRequireBO umcSupplierRectificationRequireBO = new UmcSupplierRectificationRequireBO();
            BeanUtils.copyProperties((Object)o, (Object)umcSupplierRectificationRequireBO);
            if (!ObjectUtils.isEmpty((Object)o.getRectificationTemplateId())) {
                UmcSupplierRectificationTemplatePO templatePO = this.umcSupplierRectificationTemplateMapper.selectByPrimaryKey(o.getRectificationTemplateId());
                String jsonString = JSON.toJSONString((Object)templatePO);
                RectificationTemplateBO rectificationTemplateBO = (RectificationTemplateBO)JSONObject.parseObject((String)jsonString, RectificationTemplateBO.class);
                umcSupplierRectificationRequireBO.setRectificationTemplateBo(rectificationTemplateBO);
            }
            return umcSupplierRectificationRequireBO;
        }).collect(Collectors.toList());
        rspBO.setRows(rectificationRequireBOS);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public UmcRspBaseBO submitRectificationRequire(UmcSupplierSubmitRectificationRequireBusiReqBO reqBO) {
        UmcRspBaseBO rspBO = new UmcRspBaseBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId()) || ObjectUtils.isEmpty((Object)reqBO.getTemplateId()) || ObjectUtils.isEmpty((Object)reqBO.getRectificationDes())) {
            rspBO.setRespCode("161000");
            rspBO.setRespDesc("\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Long rectificationId = sequece.nextId();
        try {
            ExtUmcSupplierInfoPO extUmcSupplierInfoPO = new ExtUmcSupplierInfoPO();
            extUmcSupplierInfoPO.setSupplierId(reqBO.getSupplierId());
            ExtUmcSupplierInfoPO supplierInfoPO = this.umcSupplierInfoMapper.getModelBy(extUmcSupplierInfoPO);
            UmcSupplierRectificationTemplatePO templatePO = this.umcSupplierRectificationTemplateMapper.selectByPrimaryKey(reqBO.getTemplateId());
            AssessmentScoreRecordTargetPO assessmentScoreRecordTargetPO = new AssessmentScoreRecordTargetPO();
            assessmentScoreRecordTargetPO.setScoreTargetIdList(reqBO.getSupplierRatingDetailBOs().stream().map(supplierRatingDetailBO::getScoreTargetId).collect(Collectors.toList()));
            List<AssessmentScoreRecordTargetPO> assessmentScoreRecordTargetPOList = this.assessmentScoreRecordTargetMapper.selectList(assessmentScoreRecordTargetPO);
            String indicators = assessmentScoreRecordTargetPOList.stream().map(AssessmentScoreRecordTargetPO::getIndicatorsName).collect(Collectors.joining("\u3001"));
            SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
            String now = shortSdf.format(new Date());
            String templateDesc = templatePO.getTemplateDesc();
            templateDesc = templateDesc.replaceAll("#indicators#", indicators);
            templateDesc = templateDesc.replaceAll("#require#", reqBO.getRectificationDes());
            templateDesc = templateDesc.replaceAll("#supplierName#", supplierInfoPO.getSupplierName());
            templateDesc = templateDesc.replaceAll("#sysTime#", now);
            UmcSupplierRectificationRequirePO requirePO = new UmcSupplierRectificationRequirePO();
            requirePO.setStatus(0);
            requirePO.setCreateNo(reqBO.getUserName());
            requirePO.setRectificationId(rectificationId);
            requirePO.setCreateTime(new Date());
            requirePO.setIsDel(0);
            requirePO.setSupplierId(reqBO.getSupplierId());
            requirePO.setRectificationDes(reqBO.getRectificationDes());
            requirePO.setRectificationTemplateId(reqBO.getTemplateId());
            requirePO.setSupplierName(supplierInfoPO.getSupplierName());
            requirePO.setTemplateMessage(templateDesc);
            this.umcSupplierRectificationRequireMapper.insert(requirePO);
            List<UmcSupplierRectificationRequireScoreContactPO> insertPOS = reqBO.getSupplierRatingDetailBOs().stream().map(item -> {
                UmcSupplierRectificationRequireScoreContactPO insertPO = new UmcSupplierRectificationRequireScoreContactPO();
                insertPO.setCreateTime(new Date());
                insertPO.setUpdateTime(new Date());
                insertPO.setSupplierId(reqBO.getSupplierId());
                insertPO.setId(sequece.nextId());
                insertPO.setScoreTargetId(item.getScoreTargetId());
                insertPO.setSupplierRatingId(item.getSupplierRatingId());
                insertPO.setRatingDetailId(item.getScoreTargetId());
                insertPO.setRectificationId(rectificationId);
                return insertPO;
            }).collect(Collectors.toList());
            this.umcSupplierRectificationRequireScoreContactMapper.insertBatch(insertPOS);
            SupplierRectificationScoreContactPO supplierRectificationScoreContactPO = new SupplierRectificationScoreContactPO();
            supplierRectificationScoreContactPO.setRectificationScoreContactId(sequece.nextId());
            supplierRectificationScoreContactPO.setStatus(0);
            supplierRectificationScoreContactPO.setSupplierId(reqBO.getSupplierId());
            supplierRectificationScoreContactPO.setSupplierRatingId(((supplierRatingDetailBO)reqBO.getSupplierRatingDetailBOs().get(0)).getSupplierRatingId());
            this.umcSupplierRectificationScoreContactMapper.contactRectificationScore(supplierRectificationScoreContactPO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            log.error("--------\u5931\u8d25\uff1a--------" + e.getMessage());
            throw new BaseBusinessException("163118", "\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public UmcRspBaseBO submitRectificationPlan(UmcSupplierSubmitRectificationPlanBusiReqBO reqBO) {
        UmcRspBaseBO rspBaseBO = new UmcRspBaseBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId()) || ObjectUtils.isEmpty((Object)reqBO.getSupplierName()) || ObjectUtils.isEmpty((Object)reqBO.getRectificationPlanDes()) || ObjectUtils.isEmpty((Object)reqBO.getAnnexFile()) || ObjectUtils.isEmpty((Object)reqBO.getRectificationId())) {
            rspBaseBO.setRespDesc("supplierName-supplierId-rectificationPlanDes-annexFile-rectificationId \u5fc5\u4f20\uff01");
            rspBaseBO.setRespCode("161000");
            return rspBaseBO;
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getIsUpdate()) && reqBO.getIsUpdate().equals(1)) {
            UmcSupplierRectificationPlanPO planPO = this.umcSupplierRectificationPlanMapper.selectByRectificationId(reqBO.getRectificationId());
            UmcSupplierRectificationPlanPO updatePO = new UmcSupplierRectificationPlanPO();
            BeanUtils.copyProperties((Object)planPO, (Object)updatePO);
            updatePO.setRectificationResult(0);
            updatePO.setRectificationPlanDes(reqBO.getRectificationPlanDes());
            updatePO.setAnnexFile(reqBO.getAnnexFile());
            updatePO.setUpdateTime(new Date());
            updatePO.setRectificationConfirmDes(reqBO.getRectificationConfirmDes());
            updatePO.setRectificationPlanId(planPO.getRectificationPlanId());
            try {
                this.umcSupplierRectificationPlanMapper.updateByPrimaryKeySelective(updatePO);
                UmcSupplierRectificationRequirePO requireInfo = this.umcSupplierRectificationRequireMapper.selectByPrimaryKey(reqBO.getRectificationId());
                SupplierRectificationScoreContactPO contactPO = new SupplierRectificationScoreContactPO();
                contactPO.setStatus(3);
                contactPO.setSupplierId(planPO.getSupplierId());
                contactPO.setSupplierRatingId(requireInfo.getSupplierRatingId());
                this.umcSupplierRectificationRequireScoreContactMapper.updateBySelect(contactPO);
                UmcSupplierRectificationRequirePO requirePO = new UmcSupplierRectificationRequirePO();
                requirePO.setRectificationId(reqBO.getRectificationId());
                requirePO.setStatus(3);
                this.umcSupplierRectificationRequireMapper.updateByPrimaryKeySelective(requirePO);
                rspBaseBO.setRespCode("0000");
                rspBaseBO.setRespDesc("\u6210\u529f");
                return rspBaseBO;
            }
            catch (Exception e) {
                log.error("--- \u9a73\u56de\u63d0\u4ea4\u5f02\u5e38\uff1a ---" + e.getMessage());
                throw new BaseBusinessException("161035", e.getMessage());
            }
        }
        UmcSupplierRectificationPlanPO planPO = new UmcSupplierRectificationPlanPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)planPO);
        planPO.setIsDel(0);
        planPO.setCreateTime(new Date());
        planPO.setUpdateTime(new Date());
        planPO.setRectificationPlanId(sequece.nextId());
        try {
            this.umcSupplierRectificationPlanMapper.insert(planPO);
            SupplierRectificationScoreContactPO contactPO = new SupplierRectificationScoreContactPO();
            contactPO.setStatus(3);
            contactPO.setSupplierId(planPO.getSupplierId());
            this.umcSupplierRectificationRequireScoreContactMapper.updateBySelect(contactPO);
            UmcSupplierRectificationRequirePO requirePO = new UmcSupplierRectificationRequirePO();
            requirePO.setRectificationId(reqBO.getRectificationId());
            requirePO.setStatus(3);
            this.umcSupplierRectificationRequireMapper.updateByPrimaryKeySelective(requirePO);
            rspBaseBO.setRespCode("0000");
            rspBaseBO.setRespDesc("\u6210\u529f");
            return rspBaseBO;
        }
        catch (Exception e) {
            log.error("--------submitRectificationPlan ERROR---------" + e.getMessage());
            throw new BaseBusinessException("161035", "\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    public UmcSupplierRectificationTemplateBusiRspBO listTemplates() {
        UmcSupplierRectificationTemplateBusiRspBO rspBO = new UmcSupplierRectificationTemplateBusiRspBO();
        UmcSupplierRectificationTemplatePO umcSupplierRectificationTemplatePO = new UmcSupplierRectificationTemplatePO();
        umcSupplierRectificationTemplatePO.setTemplateStatus(UmcCommConstants.RectificationTemplateStatus.USING);
        umcSupplierRectificationTemplatePO.setTemplateDelStatus("00");
        List<UmcSupplierRectificationTemplatePO> umcSupplierRectificationTemplatePOS = this.umcSupplierRectificationTemplateMapper.getListBy(umcSupplierRectificationTemplatePO);
        if (!ObjectUtils.isEmpty(umcSupplierRectificationTemplatePOS) && umcSupplierRectificationTemplatePOS.size() > 0) {
            List rsp = umcSupplierRectificationTemplatePOS.stream().map(item -> {
                UmcSupplierRectificationTemplateBO templateBO = new UmcSupplierRectificationTemplateBO();
                BeanUtils.copyProperties((Object)item, (Object)templateBO);
                return templateBO;
            }).collect(Collectors.toList());
            rspBO.setUmcSupplierRectificationTemplateBOS(rsp);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public UmcSupplierRectificationRequireBusiRspBO selectOneDetail(UmcSupplierRectificationRequireBusiReqBO reqBO) {
        UmcSupplierRectificationRequireBusiRspBO rspBO = new UmcSupplierRectificationRequireBusiRspBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getSupplierId()) || ObjectUtils.isEmpty((Object)reqBO.getSupplierRatingId())) {
            rspBO.setRespDesc("supplierRatingId-supplierRatingId \u5fc5\u4f20\uff01");
            rspBO.setRespCode("161000");
            return rspBO;
        }
        UmcSupplierRectificationRequirePO umcSupplierRectificationRequirePO = this.umcSupplierRectificationRequireScoreContactMapper.selectOneRequireInfo(reqBO.getSupplierId(), reqBO.getSupplierRatingId());
        BeanUtils.copyProperties((Object)umcSupplierRectificationRequirePO, (Object)rspBO);
        UmcSupplierRectificationTemplatePO templatePO = this.umcSupplierRectificationTemplateMapper.selectByPrimaryKey(umcSupplierRectificationRequirePO.getRectificationTemplateId());
        String jsonString = JSON.toJSONString((Object)templatePO);
        RectificationTemplateBO rectificationTemplateBO = (RectificationTemplateBO)JSONObject.parseObject((String)jsonString, RectificationTemplateBO.class);
        rspBO.setRectificationTemplateBo(rectificationTemplateBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public UmcRspBaseBO confirmRectificationRequire(UmcSupplierRectificationRequireConfirmBusiReqBO reqBO) {
        UmcRspBaseBO rspBO = new UmcRspBaseBO();
        if (ObjectUtils.isEmpty((Object)reqBO.getRectificationId())) {
            rspBO.setRespDesc("\u4f20\u5165\u53c2\u6570rectificationId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            rspBO.setRespCode("161000");
            return rspBO;
        }
        try {
            UmcSupplierRectificationRequirePO umcSupplierRectificationRequirePO = new UmcSupplierRectificationRequirePO();
            umcSupplierRectificationRequirePO.setRectificationId(reqBO.getRectificationId());
            umcSupplierRectificationRequirePO.setStatus(4);
            this.umcSupplierRectificationRequireMapper.updateByPrimaryKeySelective(umcSupplierRectificationRequirePO);
            SupplierRectificationScoreContactPO scoreContactPO = new SupplierRectificationScoreContactPO();
            UmcSupplierRectificationRequirePO rectificationRequirePO = new UmcSupplierRectificationRequirePO();
            rectificationRequirePO.setRectificationId(reqBO.getRectificationId());
            List<UmcSupplierRectificationRequirePO> umcSupplierRectificationRequirePOS = this.umcSupplierRectificationRequireScoreContactMapper.selectList(rectificationRequirePO);
            if (CollectionUtils.isEmpty(umcSupplierRectificationRequirePOS)) {
                throw new BaseBusinessException("161035", "\u67e5\u8be2\u6574\u6539\u4fe1\u606f\u5931\u8d25\uff01");
            }
            UmcSupplierRectificationRequirePO requireScoreContactPO = umcSupplierRectificationRequirePOS.get(0);
            scoreContactPO.setSupplierId(requireScoreContactPO.getSupplierId());
            scoreContactPO.setSupplierRatingId(requireScoreContactPO.getSupplierRatingId());
            scoreContactPO.setStatus(4);
            this.umcSupplierRectificationRequireScoreContactMapper.updateBySelect(scoreContactPO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            log.error("--------\u786e\u8ba4\u5931\u8d25\uff1a\uff08\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff09---------" + e.getMessage());
            throw new BaseBusinessException("161035", "\u786e\u8ba4\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

