/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.rating.DycUmcSupplierRatingScoreSubmitBusiService;
import com.tydic.dyc.umc.model.rating.qrybo.DycUmcSupplierRatingScoreSubmitBusiReqBO;
import com.tydic.dyc.umc.model.rating.sub.DycUmcSupplierRatingScoreSubmitBusiRspBO;
import com.tydic.dyc.umc.repository.dao.AssessmentLevelSetMapper;
import com.tydic.dyc.umc.repository.dao.AssessmentRatingScoreMapper;
import com.tydic.dyc.umc.repository.dao.AssessmentScoreRecordTargetMapper;
import com.tydic.dyc.umc.repository.dao.AssessmentScoreRecordTargetTeamMapper;
import com.tydic.dyc.umc.repository.dao.AssessmentScoreRecordTargetTeamMemberMapper;
import com.tydic.dyc.umc.repository.po.AssessmentLevelSetPO;
import com.tydic.dyc.umc.repository.po.AssessmentRatingScorePO;
import com.tydic.dyc.umc.repository.po.AssessmentScoreRecordTargetPO;
import com.tydic.dyc.umc.repository.po.AssessmentScoreRecordTargetTeamMemberPO;
import com.tydic.dyc.umc.repository.po.AssessmentScoreRecordTargetTeamPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUmcSupplierRatingScoreSubmitBusiServiceImpl
implements DycUmcSupplierRatingScoreSubmitBusiService {
    @Autowired
    private AssessmentRatingScoreMapper assessmentRatingScoreMapper;
    @Autowired
    private AssessmentScoreRecordTargetMapper assessmentScoreRecordTargetMapper;
    @Autowired
    private AssessmentScoreRecordTargetTeamMapper assessmentScoreRecordTargetTeamMapper;
    @Autowired
    private AssessmentScoreRecordTargetTeamMemberMapper assessmentScoreRecordTargetTeamMemberMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private AssessmentLevelSetMapper assessmentLevelSetMapper;

    public DycUmcSupplierRatingScoreSubmitBusiRspBO submitScore(DycUmcSupplierRatingScoreSubmitBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierRatingIds())) {
            for (Long supplierRatingId : reqBO.getSupplierRatingIds()) {
                reqBO.setSupplierRatingId(supplierRatingId);
                this.calculateScore(reqBO);
                AssessmentRatingScorePO assessmentRatingScorePO = new AssessmentRatingScorePO();
                assessmentRatingScorePO.setSupplierRatingId(supplierRatingId);
                assessmentRatingScorePO.setScoreStatus("3");
                assessmentRatingScorePO.setAuditStatus(reqBO.getAuditStatus());
                assessmentRatingScorePO.setSubmitNo(reqBO.getMemIdIn());
                assessmentRatingScorePO.setSubmitTime(new Date());
                int update = this.assessmentRatingScoreMapper.update(assessmentRatingScorePO);
                if (update >= 1) continue;
                throw new BaseBusinessException("163036", "\u4fee\u6539\u8bc4\u5206\u72b6\u6001\u5931\u8d25");
            }
        }
        DycUmcSupplierRatingScoreSubmitBusiRspBO rspBO = new DycUmcSupplierRatingScoreSubmitBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void calculateScore(DycUmcSupplierRatingScoreSubmitBusiReqBO reqBO) {
        DecimalFormat df = new DecimalFormat("#.00");
        String remark = "";
        AssessmentScoreRecordTargetPO recordTargetPO = new AssessmentScoreRecordTargetPO();
        recordTargetPO.setSupplierRatingId(reqBO.getSupplierRatingId());
        List<AssessmentScoreRecordTargetPO> recordTargetPOS = this.assessmentScoreRecordTargetMapper.selectList(recordTargetPO);
        if (!CollectionUtils.isEmpty(recordTargetPOS)) {
            for (AssessmentScoreRecordTargetPO targetPO : recordTargetPOS) {
                AssessmentScoreRecordTargetTeamPO recordTargetTeamPO = new AssessmentScoreRecordTargetTeamPO();
                recordTargetTeamPO.setScoreTargetId(targetPO.getScoreTargetId());
                AssessmentScoreRecordTargetTeamPO scoreRecordTargetTeamPO = this.assessmentScoreRecordTargetTeamMapper.selectTeamDetail(recordTargetTeamPO);
                if (null == scoreRecordTargetTeamPO) continue;
                AssessmentScoreRecordTargetTeamMemberPO targetTeamMemberPO = new AssessmentScoreRecordTargetTeamMemberPO();
                targetTeamMemberPO.setScoreTargetTeamId(scoreRecordTargetTeamPO.getScoreTargetTeamId());
                List<AssessmentScoreRecordTargetTeamMemberPO> recordTargetTeamMemberPOS = this.assessmentScoreRecordTargetTeamMemberMapper.selectMemberList(targetTeamMemberPO);
                Object teamScore = 0.0;
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer remarkBuffer = new StringBuffer();
                if (!CollectionUtils.isEmpty(recordTargetTeamMemberPOS)) {
                    for (AssessmentScoreRecordTargetTeamMemberPO recordTargetTeamMemberPO : recordTargetTeamMemberPOS) {
                        teamScore = (Double)teamScore + Double.parseDouble(recordTargetTeamMemberPO.getMemWeight()) * Double.parseDouble(recordTargetTeamMemberPO.getMemScore()) / 100.0;
                        recordTargetTeamMemberPO.setMemFinalScore(String.valueOf(Double.parseDouble(recordTargetTeamMemberPO.getMemWeight()) * Double.parseDouble(recordTargetTeamMemberPO.getMemScore()) / 100.0));
                        int updateMem = this.assessmentScoreRecordTargetTeamMemberMapper.update(recordTargetTeamMemberPO);
                        if (updateMem < 1) {
                            throw new BaseBusinessException("163037", "\u4fee\u6539\u8bc4\u5206\u4eba\u5458\u6700\u7ec8\u5f97\u5206\u5931\u8d25");
                        }
                        if (recordTargetTeamMemberPO.getScoreTargetMemberDesc() == null) {
                            stringBuffer.append(recordTargetTeamMemberPO.getMemName()).append(":").append("\u65e0").append(";");
                        } else {
                            stringBuffer.append(recordTargetTeamMemberPO.getMemName()).append(":").append(recordTargetTeamMemberPO.getScoreTargetMemberDesc()).append(";");
                        }
                        if (null == recordTargetTeamMemberPO.getRemark()) {
                            remarkBuffer.append(recordTargetTeamMemberPO.getMemName()).append(":").append("\u65e0").append(";");
                            continue;
                        }
                        remarkBuffer.append(recordTargetTeamMemberPO.getMemName()).append(":").append(recordTargetTeamMemberPO.getRemark()).append(";");
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                    if (remarkBuffer.length() > 0) {
                        remark = remarkBuffer.deleteCharAt(remarkBuffer.length() - 1).toString();
                    }
                    if (stringBuffer.length() > 0) {
                        targetPO.setScoreTargetDesc(stringBuffer.toString());
                    }
                }
                scoreRecordTargetTeamPO.setScoreTargetTeamScore(((Double)teamScore).toString());
                scoreRecordTargetTeamPO.setScoreTargetTeamStatus("1");
                int teamUpdate = this.assessmentScoreRecordTargetTeamMapper.updateById(scoreRecordTargetTeamPO);
                if (teamUpdate < 1) {
                    throw new BaseBusinessException("163038", "\u4fee\u6539\u5c0f\u7ec4\u8bc4\u5206\u72b6\u6001\u5931\u8d25");
                }
                targetPO.setIndicatorsScore(((Double)teamScore).toString());
                targetPO.setScoreTargetStatus("1");
                int targetUpdate = this.assessmentScoreRecordTargetMapper.update(targetPO);
                if (targetUpdate >= 1) continue;
                throw new BaseBusinessException("163001", "\u540c\u6b65\u6307\u6807\u5206\u6570\u5931\u8d25");
            }
        }
        AssessmentScoreRecordTargetPO targetPO = new AssessmentScoreRecordTargetPO();
        AssessmentRatingScorePO ratingScorePO = new AssessmentRatingScorePO();
        targetPO.setSupplierRatingId(reqBO.getSupplierRatingId());
        targetPO.setScoreTargetStatus("2");
        ratingScorePO.setSupplierRatingId(reqBO.getSupplierRatingId());
        ratingScorePO = this.assessmentRatingScoreMapper.selectDetail(ratingScorePO);
        if (null == ratingScorePO) {
            throw new BaseBusinessException("163039", "\u672a\u67e5\u8be2\u5230\u8bc4\u5206\u8bb0\u5f55\u4fe1\u606f");
        }
        Integer countSupplierRating = this.assessmentScoreRecordTargetMapper.countRatingStatus(targetPO);
        List<AssessmentScoreRecordTargetPO> targetPOS = this.assessmentScoreRecordTargetMapper.selectList(recordTargetPO);
        if (!CollectionUtils.isEmpty(recordTargetPOS)) {
            int check;
            Double ratingScore = 0.0;
            ArrayList<Double> ratingScores = new ArrayList<Double>();
            for (AssessmentScoreRecordTargetPO targetPO1 : targetPOS) {
                if (null != targetPO1.getIndicatorsScore()) {
                    ratingScores.add(Double.parseDouble(targetPO1.getIndicatorsWeight()) * Double.parseDouble(targetPO1.getRatingIndexWeight()) * Double.parseDouble(targetPO1.getIndicatorsScore()));
                    continue;
                }
                ratingScores.add(0.0);
            }
            if (!CollectionUtils.isEmpty(ratingScores)) {
                for (int i = 0; i < ratingScores.size(); ++i) {
                    ratingScore = ratingScore + (Double)ratingScores.get(i);
                }
            }
            ratingScorePO.setSupplierRatingId(reqBO.getSupplierRatingId());
            if (StringUtils.isBlank((CharSequence)ratingScorePO.getBreakPromiseScore())) {
                ratingScorePO.setFinalScore(df.format(Double.parseDouble(df.format(ratingScore / 10000.0))));
            } else {
                ratingScorePO.setFinalScore(df.format(Double.parseDouble(df.format(ratingScore / 10000.0)) - Double.parseDouble(ratingScorePO.getBreakPromiseScore())));
            }
            AssessmentLevelSetPO assessmentLevelSetPO = new AssessmentLevelSetPO();
            assessmentLevelSetPO.setScore(Double.parseDouble(ratingScorePO.getFinalScore()));
            AssessmentLevelSetPO levelSetPO = this.assessmentLevelSetMapper.queryScoreDetail(assessmentLevelSetPO);
            if (null != levelSetPO) {
                ratingScorePO.setScoreLevel(levelSetPO.getLevelCode());
                ratingScorePO.setScoreLevelName(levelSetPO.getLevelName());
            }
            if ((check = this.assessmentRatingScoreMapper.update(ratingScorePO)) < 1) {
                throw new BaseBusinessException("163001", "\u540c\u6b65\u4f9b\u5e94\u5546\u8bc4\u5206\u8bb0\u5f55\u5931\u8d25");
            }
        }
    }
}

