/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.ldOrganization.UmcLdOrganizationInfoQryDo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcEnterpriseInfoDetailQryBo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoPageQryBo;
import com.tydic.dyc.umc.model.ldOrganization.qrybo.UmcLdOrganizationInfoQryBo;
import com.tydic.dyc.umc.model.ldOrganization.sub.UmcEnterpriseOrgInfo;
import com.tydic.dyc.umc.model.ldOrganization.sub.UmcLdOrganizationInfo;
import com.tydic.dyc.umc.repository.UmcLdOrganizationInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcDealMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseAccountMapper;
import com.tydic.dyc.umc.repository.dao.UmcLdOrganizationMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseAccountPo;
import com.tydic.dyc.umc.repository.po.UmcLdOrganizationPo;
import com.tydic.dyc.umc.repository.po.UmcUserAndOrgPo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcBusinessException;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcLdOrganizationInfoRepositoryImpl
implements UmcLdOrganizationInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcLdOrganizationInfoRepositoryImpl.class);
    @Autowired
    private UmcDealMapper umcDealMapper;
    @Autowired
    private UmcLdOrganizationMapper umcLdOrganizationMapper;
    @Autowired
    private UmcEnterpriseAccountMapper umcEnterpriseAccountMapper;
    public static final String PROJECT_NAME = "\u9879\u76ee\u7ec4\u7ec7";
    @Value(value="${NO_LEGAL_ENTITY:00026124}")
    private String NO_LEGAL_ENTITY;
    @Value(value="305775845729763327")
    private Long deliveryCenterId;

    public int synchronizeOrg(List<UmcLdOrganizationInfo> umcLdOrganizationInfos) {
        List umcLdOrganizationPos = UmcRu.jsl(umcLdOrganizationInfos, UmcLdOrganizationPo.class);
        for (UmcLdOrganizationPo each : umcLdOrganizationPos) {
            UmcLdOrganizationPo qryUmcLdOrganizationPo = new UmcLdOrganizationPo();
            qryUmcLdOrganizationPo.setOrgDepId(each.getOrgDepId());
            UmcLdOrganizationPo umcLdOrganizationPo = this.umcLdOrganizationMapper.queryByCondition(qryUmcLdOrganizationPo);
            if (umcLdOrganizationPo == null) {
                each.setOrgId(IdUtil.nextId());
                continue;
            }
            each.setOrgId(umcLdOrganizationPo.getOrgId());
        }
        return this.umcLdOrganizationMapper.insertOrUpdateBatch(umcLdOrganizationPos);
    }

    public List<UmcLdOrganizationInfoQryDo> selectProjectInfoList(UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo) {
        UmcLdOrganizationPo umcLdOrganizationPo = (UmcLdOrganizationPo)UmcRu.js((Object)umcLdOrganizationInfoQryBo, UmcLdOrganizationPo.class);
        List<UmcLdOrganizationPo> rows = this.umcLdOrganizationMapper.selectProjectList(umcLdOrganizationPo);
        if (!CollectionUtils.isEmpty(rows)) {
            List<String> orgNoFullPaths = rows.stream().filter(each -> PROJECT_NAME.equals(each.getOrgShortName())).map(UmcLdOrganizationPo::getOrgNoFullPath).collect(Collectors.toList());
            HashSet<String> orgDepIds = new HashSet<String>();
            orgNoFullPaths.forEach(each -> {
                String[] split = each.split("-");
                orgDepIds.addAll(Arrays.asList(split));
            });
            log.debug("\u67e5\u8be2\u9879\u76ee\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u4e0a\u7ea7id{}", orgDepIds);
            UmcLdOrganizationPo qryUmcLdOrganization = new UmcLdOrganizationPo();
            qryUmcLdOrganization.setOrgDepIdSet(orgDepIds);
            List<UmcLdOrganizationPo> umcLdOrgGradingList = this.umcLdOrganizationMapper.selectInternalOrgList(qryUmcLdOrganization);
            log.debug("\u67e5\u8be2\u9879\u76ee\u7ec4\u7ec7\u673a\u6784\u7684\u6240\u6709\u4e0a\u7ea7\u6570\u636e{}", umcLdOrgGradingList);
            rows.addAll(umcLdOrgGradingList);
        }
        return ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcLdOrganizationInfoQryDo.class) : new ArrayList(0);
    }

    public BasePageRspBo<UmcLdOrganizationInfo> selectLegalEntityInfo(UmcLdOrganizationInfoPageQryBo umcLdOrganizationInfoPageQryBo) {
        Page page = new Page(umcLdOrganizationInfoPageQryBo.getPageNo(), umcLdOrganizationInfoPageQryBo.getPageSize());
        UmcLdOrganizationPo umcLdOrganization = new UmcLdOrganizationPo();
        umcLdOrganization.setOrgShortName(umcLdOrganizationInfoPageQryBo.getOrgShortName());
        umcLdOrganization.setOrgType("P2");
        umcLdOrganization.setNoOrgDepIds(Collections.singletonList(this.NO_LEGAL_ENTITY));
        umcLdOrganization.setOrgStatus("1");
        List<UmcLdOrganizationPo> umcLdOrganizationPoList = this.umcLdOrganizationMapper.queryAllByLimit(umcLdOrganization, (Page<UmcLdOrganizationPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(!CollectionUtils.isEmpty(umcLdOrganizationPoList) ? UmcRu.jsl(umcLdOrganizationPoList, UmcLdOrganizationInfo.class) : new ArrayList(0));
        return rspBo;
    }

    public BasePageRspBo<UmcLdOrganizationInfo> queryAllByLimit(UmcLdOrganizationInfoPageQryBo umcLdOrganizationInfoPageQryBo) {
        Page page = new Page(umcLdOrganizationInfoPageQryBo.getPageNo(), umcLdOrganizationInfoPageQryBo.getPageSize());
        UmcLdOrganizationPo umcLdOrganization = new UmcLdOrganizationPo();
        umcLdOrganization.setOrgDepId(umcLdOrganizationInfoPageQryBo.getOrgDepId());
        List<UmcLdOrganizationPo> umcLdOrganizationPoList = this.umcLdOrganizationMapper.queryAllByLimit(umcLdOrganization, (Page<UmcLdOrganizationPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(!CollectionUtils.isEmpty(umcLdOrganizationPoList) ? UmcRu.jsl(umcLdOrganizationPoList, UmcLdOrganizationInfo.class) : new ArrayList(0));
        return rspBo;
    }

    public UmcLdOrganizationInfoQryDo qryLdOrgInfoDetail(UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo) {
        UmcLdOrganizationPo umcLdOrganizationPo = (UmcLdOrganizationPo)UmcRu.js((Object)umcLdOrganizationInfoQryBo, UmcLdOrganizationPo.class);
        UmcLdOrganizationPo modelBy = this.umcLdOrganizationMapper.queryByCondition(umcLdOrganizationPo);
        return (UmcLdOrganizationInfoQryDo)UmcRu.js((Object)modelBy, UmcLdOrganizationInfoQryDo.class);
    }

    public List<UmcLdOrganizationInfoQryDo> selectLdOrgInfoListTree(UmcLdOrganizationInfoQryBo umcLdOrganizationInfoQryBo) {
        UmcLdOrganizationPo umcLdOrganizationPo = (UmcLdOrganizationPo)UmcRu.js((Object)umcLdOrganizationInfoQryBo, UmcLdOrganizationPo.class);
        umcLdOrganizationPo.setOrgType("E1");
        umcLdOrganizationPo.setOrgStatus("1");
        List<UmcLdOrganizationPo> rows = this.umcLdOrganizationMapper.queryAllByAll(umcLdOrganizationPo);
        return ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcLdOrganizationInfoQryDo.class) : new ArrayList(0);
    }

    public BasePageRspBo<UmcLdOrganizationInfo> qryLdOrgInfoList(UmcLdOrganizationInfoPageQryBo qryBo) {
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        UmcLdOrganizationPo umcLdOrganizationPo = (UmcLdOrganizationPo)UmcRu.js((Object)qryBo, UmcLdOrganizationPo.class);
        umcLdOrganizationPo.setOrgStatus("1");
        List<UmcLdOrganizationPo> umcLdOrganizationPoList = this.umcLdOrganizationMapper.queryAllByLimit(umcLdOrganizationPo, (Page<UmcLdOrganizationPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(!CollectionUtils.isEmpty(umcLdOrganizationPoList) ? UmcRu.jsl(umcLdOrganizationPoList, UmcLdOrganizationInfo.class) : new ArrayList(0));
        return rspBo;
    }

    public void insertEnterpriseAccount(UmcEnterpriseOrgInfo umcEnterpriseOrgInfo) {
        UmcEnterpriseAccountPo enterpriseAccountPONew = new UmcEnterpriseAccountPo();
        enterpriseAccountPONew.setAccountId(umcEnterpriseOrgInfo.getOrgId());
        enterpriseAccountPONew.setAccountStatus("1");
        enterpriseAccountPONew.setDelFlag("0");
        enterpriseAccountPONew.setCheckStatus("1");
        int checkBy = this.umcEnterpriseAccountMapper.getCheckBy(enterpriseAccountPONew);
        if (checkBy == 0) {
            Long accountId = umcEnterpriseOrgInfo.getOrgId();
            enterpriseAccountPONew.setAccountId(accountId);
            enterpriseAccountPONew.setTenantId(Long.valueOf(10000L));
            enterpriseAccountPONew.setOrgId(umcEnterpriseOrgInfo.getOrgId());
            enterpriseAccountPONew.setAccountName(umcEnterpriseOrgInfo.getOrgName());
            enterpriseAccountPONew.setAccountType("01");
            enterpriseAccountPONew.setIsShadowAccount(UmcCommConstant.EntAccIsShadow.NO.toString());
            enterpriseAccountPONew.setAccountOwner("COMPANY");
            enterpriseAccountPONew.setDeliveryCenterId(this.deliveryCenterId);
            try {
                this.umcEnterpriseAccountMapper.insert(enterpriseAccountPONew);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u9ed8\u8ba4\u8d26\u5957\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new UmcBusinessException("8888", "\u65b0\u589e\u9ed8\u8ba4\u8d26\u5957\u5931\u8d25!");
            }
        }
    }

    public BasePageRspBo<UmcEnterpriseInfoDetailQryBo> getEnterpriseInfoListPage(UmcEnterpriseInfoDetailQryBo qryBo) {
        UmcUserAndOrgPo umcUserAndOrgPo = (UmcUserAndOrgPo)UmcRu.js((Object)qryBo, UmcUserAndOrgPo.class);
        Page page = new Page(qryBo.getPageNo(), qryBo.getPageSize());
        List<UmcUserAndOrgPo> rows = this.umcDealMapper.getEnterpriseInfoListPage(umcUserAndOrgPo, (Page<UmcUserAndOrgPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcEnterpriseInfoDetailQryBo.class) : new ArrayList(0));
        return rspBo;
    }
}

