/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.orgProductCategoryRel.qrybo.UmcOrgProductCategoryApplayQryBo;
import com.tydic.dyc.umc.model.orgProductCategoryRel.qrybo.UmcOrgProductCategoryRelQryBo;
import com.tydic.dyc.umc.model.orgProductCategoryRel.sub.UmcOrgProductCategoryRelSubDo;
import com.tydic.dyc.umc.repository.UmcOrgProductCategoryRelRepository;
import com.tydic.dyc.umc.repository.dao.UmcOrgProductCategoryRelApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgProductCategoryRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcProductCategoryMapper;
import com.tydic.dyc.umc.repository.po.UmcOrgProductCategoryRelApplyPo;
import com.tydic.dyc.umc.repository.po.UmcOrgProductCategoryRelPo;
import com.tydic.dyc.umc.repository.po.UmcProductCategoryPO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcOrgProductCategoryRelRepositoryImpl
implements UmcOrgProductCategoryRelRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcOrgProductCategoryRelRepositoryImpl.class);
    @Autowired
    private UmcOrgProductCategoryRelMapper umcOrgProductCategoryRelMapper;
    @Autowired
    private UmcOrgProductCategoryRelApplyMapper umcOrgProductCategoryRelApplyMapper;
    @Autowired
    private UmcProductCategoryMapper umcProductCategoryMapper;

    public void createOrgProductCategoryRelApplyBatch(List<UmcOrgProductCategoryRelQryBo> qryBo) {
        List jsl = UmcRu.jsl(qryBo, UmcOrgProductCategoryRelApplyPo.class);
        this.umcOrgProductCategoryRelApplyMapper.insertBatch(jsl);
    }

    public UmcOrgProductCategoryRelSubDo delOrgProductCategoryRelApplyBatch(UmcOrgProductCategoryRelQryBo qryBo) {
        UmcOrgProductCategoryRelApplyPo applyPo = new UmcOrgProductCategoryRelApplyPo();
        applyPo.setRelIds(qryBo.getRelIds());
        int i = this.umcOrgProductCategoryRelApplyMapper.deleteBatch(applyPo);
        UmcOrgProductCategoryRelSubDo umcOrgProductCategoryRelSubDo = new UmcOrgProductCategoryRelSubDo();
        umcOrgProductCategoryRelSubDo.setNumber(Integer.valueOf(i));
        return umcOrgProductCategoryRelSubDo;
    }

    public BasePageRspBo<UmcOrgProductCategoryRelSubDo> qryOrgProductCategoryRelList(UmcOrgProductCategoryRelQryBo relQryBo) {
        UmcOrgProductCategoryRelPo umcOrgProductCategoryRelPo = (UmcOrgProductCategoryRelPo)UmcRu.js((Object)relQryBo, UmcOrgProductCategoryRelPo.class);
        Page page = new Page(relQryBo.getPageNo(), relQryBo.getPageSize());
        List<UmcOrgProductCategoryRelPo> rows = this.umcOrgProductCategoryRelMapper.queryAllByLimit(umcOrgProductCategoryRelPo, (Page<UmcOrgProductCategoryRelPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcOrgProductCategoryRelSubDo.class) : new ArrayList(0));
        return rspBo;
    }

    public BasePageRspBo<UmcOrgProductCategoryRelSubDo> qryOrgProductCategoryRelApplyList(UmcOrgProductCategoryRelQryBo relQryBo) {
        UmcOrgProductCategoryRelApplyPo umcOrgProductCategoryRelPo = (UmcOrgProductCategoryRelApplyPo)UmcRu.js((Object)relQryBo, UmcOrgProductCategoryRelApplyPo.class);
        Page page = new Page(relQryBo.getPageNo(), relQryBo.getPageSize());
        List<UmcOrgProductCategoryRelApplyPo> rows = this.umcOrgProductCategoryRelApplyMapper.queryAllByLimit(umcOrgProductCategoryRelPo, (Page<UmcOrgProductCategoryRelApplyPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcOrgProductCategoryRelSubDo.class) : new ArrayList(0));
        return rspBo;
    }

    public void updateProductCategoryApproval(UmcOrgProductCategoryApplayQryBo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getUmcOrgProductCategoryRelQryBos())) {
            ArrayList<Long> delRelIds = new ArrayList<Long>();
            ArrayList<UmcOrgProductCategoryRelApplyPo> addUmcOrgProductCategoryRelQryBos = new ArrayList<UmcOrgProductCategoryRelApplyPo>();
            for (UmcOrgProductCategoryRelQryBo each : reqDo.getUmcOrgProductCategoryRelQryBos()) {
                if ("1".equals(each.getChngType()) && each.getRelId() == null) {
                    UmcOrgProductCategoryRelApplyPo js = (UmcOrgProductCategoryRelApplyPo)UmcRu.js((Object)each, UmcOrgProductCategoryRelApplyPo.class);
                    js.setRelId(IdUtil.nextId());
                    js.setApplyId(reqDo.getApplyId());
                    js.setOrgId(reqDo.getOrgId());
                    js.setExtField1(reqDo.getApplyType());
                    js.setCreateTime(new Date());
                    addUmcOrgProductCategoryRelQryBos.add(js);
                    continue;
                }
                if (!"2".equals(each.getChngType()) || each.getRelId() == null) continue;
                delRelIds.add(each.getRelId());
            }
            if (!CollectionUtils.isEmpty(delRelIds)) {
                try {
                    UmcOrgProductCategoryRelApplyPo umcOrgProductCategoryRelQryBo = new UmcOrgProductCategoryRelApplyPo();
                    umcOrgProductCategoryRelQryBo.setRelIds(delRelIds);
                    this.umcOrgProductCategoryRelApplyMapper.deleteBatch(umcOrgProductCategoryRelQryBo);
                }
                catch (Exception e) {
                    log.debug("\u5220\u9664\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    throw new BaseBusinessException("200100", "\u5220\u9664\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25");
                }
            }
            if (!CollectionUtils.isEmpty(addUmcOrgProductCategoryRelQryBos)) {
                try {
                    this.umcOrgProductCategoryRelApplyMapper.insertBatch(addUmcOrgProductCategoryRelQryBos);
                }
                catch (Exception e) {
                    log.debug("\u65b0\u589e\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    throw new BaseBusinessException("200100", "\u65b0\u589e\u4ea7\u54c1\u7c7b\u578b\u5931\u8d25");
                }
            }
        }
    }

    public void updateProductCategoryApprovalEnd(UmcOrgProductCategoryApplayQryBo reqDo) {
        if (reqDo.getApplyId() == null) {
            throw new BaseBusinessException("200100", "\u7533\u8bf7\u5355ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (reqDo.getOrgId() == null) {
            throw new BaseBusinessException("200100", "\u673a\u6784id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        UmcOrgProductCategoryRelApplyPo qryApplyPo = new UmcOrgProductCategoryRelApplyPo();
        qryApplyPo.setApplyId(reqDo.getApplyId());
        qryApplyPo.setOrgId(reqDo.getOrgId());
        List<UmcOrgProductCategoryRelApplyPo> applyPos = this.umcOrgProductCategoryRelApplyMapper.queryList(qryApplyPo);
        UmcOrgProductCategoryRelPo umcOrgProductCategoryRelPo = new UmcOrgProductCategoryRelPo();
        umcOrgProductCategoryRelPo.setOrgId(reqDo.getOrgId());
        this.umcOrgProductCategoryRelMapper.deleteByCondition(umcOrgProductCategoryRelPo);
        if (!CollectionUtils.isEmpty(applyPos)) {
            List jsl = UmcRu.jsl(applyPos, UmcOrgProductCategoryRelPo.class);
            this.umcOrgProductCategoryRelMapper.insertBatch(jsl);
        }
    }

    public void updateOrgProductCategoryRelApply(UmcOrgProductCategoryRelQryBo qryBo) {
        UmcOrgProductCategoryRelApplyPo js = (UmcOrgProductCategoryRelApplyPo)UmcRu.js((Object)qryBo, UmcOrgProductCategoryRelApplyPo.class);
        this.umcOrgProductCategoryRelApplyMapper.update(js);
    }

    public void delOrgProductCategoryRel(UmcOrgProductCategoryRelQryBo relQryBo) {
        if (relQryBo.getCategoryId() == null) {
            throw new BaseBusinessException("200100", "\u4ea7\u54c1\u5206\u7c7bId\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        UmcOrgProductCategoryRelApplyPo umcOrgProductCategoryRelPo = (UmcOrgProductCategoryRelApplyPo)UmcRu.js((Object)relQryBo, UmcOrgProductCategoryRelApplyPo.class);
        this.umcOrgProductCategoryRelApplyMapper.deleteByCondition(umcOrgProductCategoryRelPo);
        UmcOrgProductCategoryRelPo orgProductCategoryRelPo = (UmcOrgProductCategoryRelPo)UmcRu.js((Object)relQryBo, UmcOrgProductCategoryRelPo.class);
        this.umcOrgProductCategoryRelMapper.deleteByCondition(orgProductCategoryRelPo);
    }

    public void addSupplierProductCategory(UmcOrgProductCategoryRelQryBo qryBo) {
        ArrayList<UmcOrgProductCategoryRelPo> rows = new ArrayList<UmcOrgProductCategoryRelPo>();
        ArrayList<UmcOrgProductCategoryRelApplyPo> applyRows = new ArrayList<UmcOrgProductCategoryRelApplyPo>();
        UmcProductCategoryPO umcProductCategoryPo = new UmcProductCategoryPO();
        umcProductCategoryPo.setCategoryStatus(1);
        List<UmcProductCategoryPO> umcProductCategoryPos = this.umcProductCategoryMapper.queryAllByLimit(umcProductCategoryPo);
        if (!CollectionUtils.isEmpty(umcProductCategoryPos)) {
            for (UmcProductCategoryPO each : umcProductCategoryPos) {
                UmcOrgProductCategoryRelPo umcOrgProductCategoryRelPo = new UmcOrgProductCategoryRelPo();
                umcOrgProductCategoryRelPo.setRelId(IdUtil.nextId());
                umcOrgProductCategoryRelPo.setCategoryId(each.getCategoryId());
                umcOrgProductCategoryRelPo.setOrgId(qryBo.getOrgId());
                umcOrgProductCategoryRelPo.setCreateTime(new Date());
                umcOrgProductCategoryRelPo.setCreateOperId(qryBo.getCreateOperId());
                umcOrgProductCategoryRelPo.setCreateOperName(qryBo.getCreateOperName());
                rows.add(umcOrgProductCategoryRelPo);
                UmcOrgProductCategoryRelApplyPo umcOrgProductCategoryRelApplyPo = (UmcOrgProductCategoryRelApplyPo)UmcRu.js((Object)umcOrgProductCategoryRelPo, UmcOrgProductCategoryRelApplyPo.class);
                umcOrgProductCategoryRelApplyPo.setApplyId(qryBo.getApplyId());
                applyRows.add(umcOrgProductCategoryRelApplyPo);
            }
        }
        if (!CollectionUtils.isEmpty(rows)) {
            this.umcOrgProductCategoryRelMapper.insertBatch(rows);
        }
        if (!CollectionUtils.isEmpty(applyRows)) {
            this.umcOrgProductCategoryRelApplyMapper.insertBatch(applyRows);
        }
    }
}

