/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.qualif.DycUmcSupplierAuditLogListBusiService;
import com.tydic.dyc.umc.model.qualif.qrybo.DycUmcSupplierAuditLogListBusiReqBO;
import com.tydic.dyc.umc.model.qualif.sub.DycUmcSupplierAuditLogListBusiRspBO;
import com.tydic.dyc.umc.repository.dao.ExtEnterpriseOrgMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrderTaskMapper;
import com.tydic.dyc.umc.repository.po.EnterpriseOrgPO;
import com.tydic.dyc.umc.repository.po.UocOrdTaskPO;
import com.tydic.dyc.umc.service.feedback.bo.UmcEnterpriseOrgBO;
import com.tydic.dyc.umc.service.qualif.bo.AgrApprovalLogBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import com.tydic.uac.po.ApprovalLogPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycUmcSupplierAuditLogListBusiServiceImpl
implements DycUmcSupplierAuditLogListBusiService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcSupplierAuditLogListBusiServiceImpl.class);
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private UmcOrderTaskMapper umcOrderTaskMapper;
    @Autowired
    private ExtEnterpriseOrgMapper extEnterpriseOrgMapper;

    public DycUmcSupplierAuditLogListBusiRspBO qrySupplierAuditLogList(DycUmcSupplierAuditLogListBusiReqBO reqBO) {
        DycUmcSupplierAuditLogListBusiRspBO rspBO = new DycUmcSupplierAuditLogListBusiRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getParamIds())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        UacQryAuditLogReqBO uacQryAuditLogReqBO = new UacQryAuditLogReqBO();
        uacQryAuditLogReqBO.setPageNo(reqBO.getPageNo());
        uacQryAuditLogReqBO.setPageSize(reqBO.getPageSize());
        uacQryAuditLogReqBO.setObjId(reqBO.getParamId());
        if (!StringUtils.isEmpty((Object)reqBO.getObjType())) {
            uacQryAuditLogReqBO.setObjType(Integer.valueOf(Integer.parseInt(reqBO.getObjType())));
        }
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacQryAuditLogReqBO));
        UacQryAuditLogRspBO uacQryAuditLogRspBO = new UacQryAuditLogRspBO();
        List<String> collect = reqBO.getParamIds().stream().map(String::valueOf).collect(Collectors.toList());
        List<Long> auditOrderIds = this.umcOrderTaskMapper.selectAuditLogIds(collect);
        if (CollectionUtils.isEmpty(auditOrderIds)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        List<ApprovalLogPO> results = this.umcOrderTaskMapper.selectAuditLogsByAuditOrderIds(auditOrderIds);
        log.debug("\u65e5\u5fd7\u67e5\u8be2\u7ed3\u679c\uff1a" + results);
        if (CollectionUtils.isEmpty(results)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        List rowList = results.stream().map(item -> {
            ApprovalLogBO approvalLogBO = new ApprovalLogBO();
            BeanUtils.copyProperties((Object)item, (Object)approvalLogBO);
            return approvalLogBO;
        }).collect(Collectors.toList());
        uacQryAuditLogRspBO.setRows(rowList);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u5ba1\u6279\u65e5\u5fd7\u67e5\u8be2\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacQryAuditLogRspBO));
        if (CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        ArrayList<AgrApprovalLogBO> rows = new ArrayList<AgrApprovalLogBO>();
        Date date = new Date();
        for (ApprovalLogBO bo : uacQryAuditLogRspBO.getRows()) {
            AgrApprovalLogBO agrApprovalLogBO = new AgrApprovalLogBO();
            BeanUtils.copyProperties((Object)bo, (Object)agrApprovalLogBO);
            if (agrApprovalLogBO.getNextStepId() != null) {
                agrApprovalLogBO.setAudit("\u63d0\u4ea4");
                agrApprovalLogBO.setDTime("");
                if (rows.size() == 1) {
                    ((AgrApprovalLogBO)rows.get(rows.size() - 1)).setDTime(DycUmcSupplierAuditLogListBusiServiceImpl.getTime(date, agrApprovalLogBO.getDealTime()));
                } else {
                    date = agrApprovalLogBO.getDealTime();
                }
            }
            if (agrApprovalLogBO.getNextStepId() == null) {
                if (rows.size() >= 1) {
                    agrApprovalLogBO.setDTime(DycUmcSupplierAuditLogListBusiServiceImpl.getTime(agrApprovalLogBO.getDealTime(), ((AgrApprovalLogBO)rows.get(rows.size() - 1)).getDealTime()));
                } else {
                    date = agrApprovalLogBO.getDealTime();
                }
            }
            if (!Integer.toString(UmcCommConstants.AuditObjType.SUP_RATING_SCORE).equals(reqBO.getObjType()) && null != agrApprovalLogBO.getAuditResult()) {
                if (agrApprovalLogBO.getAuditResult() == 2) {
                    agrApprovalLogBO.setAudit("\u9a73\u56de");
                }
                if (agrApprovalLogBO.getAuditResult() == 1) {
                    agrApprovalLogBO.setAudit("\u901a\u8fc7");
                }
            }
            rows.add(agrApprovalLogBO);
        }
        UocOrdTaskPO uocOrdTaskPO = new UocOrdTaskPO();
        uocOrdTaskPO.setOrderId(((ApprovalLogBO)uacQryAuditLogRspBO.getRows().get(0)).getOrderId());
        List<UocOrdTaskPO> taskPOS = this.umcOrderTaskMapper.selectByOrderId(uocOrdTaskPO);
        if (taskPOS != null) {
            rspBO.setProcDefId(taskPOS.get(0).getProcInstId());
            rspBO.setTacheCode(taskPOS.get(0).getTacheCode());
        }
        rspBO.setRows(rows);
        if (!CollectionUtils.isEmpty(rows)) {
            for (AgrApprovalLogBO row : rows) {
                if (!StringUtils.isEmpty((Object)row.getOperDept())) continue;
                EnterpriseOrgPO enterpriseOrgBO = new EnterpriseOrgPO();
                enterpriseOrgBO.setMemId(Long.parseLong(row.getOperid()));
                UmcEnterpriseOrgBO umcEnterpriseOrgBO = this.extEnterpriseOrgMapper.getModelBy(enterpriseOrgBO);
                if (null == umcEnterpriseOrgBO) continue;
                row.setOperDept(umcEnterpriseOrgBO.getOrgName());
            }
            ArrayList<AgrApprovalLogBO> agrApprovalLogBOS = new ArrayList<AgrApprovalLogBO>();
            AgrApprovalLogBO logBO = (AgrApprovalLogBO)rows.get(rows.size() - 1);
            UocOrdTaskPO uocOrdTaskPO1 = new UocOrdTaskPO();
            uocOrdTaskPO1.setId(logBO.getId());
            UocOrdTaskPO ordTaskPO = this.umcOrderTaskMapper.selectNextStation(uocOrdTaskPO1);
            if (null != ordTaskPO.getStationId()) {
                UocOrdTaskPO po = new UocOrdTaskPO();
                po.setStationId(ordTaskPO.getStationId());
                List<UocOrdTaskPO> ordTaskPOS = this.umcOrderTaskMapper.selectNextName(po);
                if (!CollectionUtils.isEmpty(ordTaskPOS)) {
                    for (UocOrdTaskPO taskPO : ordTaskPOS) {
                        AgrApprovalLogBO agrApprovalLogBO = new AgrApprovalLogBO();
                        agrApprovalLogBO.setOperName(taskPO.getName());
                        agrApprovalLogBO.setOperDept(taskPO.getOrgName());
                        agrApprovalLogBOS.add(agrApprovalLogBO);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(agrApprovalLogBOS)) {
                List logBOS = ListUtils.union(rows, agrApprovalLogBOS);
                rspBO.setRows(logBOS);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public static String getTime(Date currentTime, Date firstTime) {
        long diff = currentTime.getTime() - firstTime.getTime();
        Calendar currentTimes = DycUmcSupplierAuditLogListBusiServiceImpl.dataToCalendar(currentTime);
        Calendar firstTimes = DycUmcSupplierAuditLogListBusiServiceImpl.dataToCalendar(firstTime);
        int year = currentTimes.get(1) - firstTimes.get(1);
        int month = currentTimes.get(2) - firstTimes.get(2);
        int day = currentTimes.get(5) - firstTimes.get(5);
        if (day < 0) {
            --month;
            currentTimes.add(2, -1);
            day += currentTimes.getActualMaximum(5);
        }
        if (month < 0) {
            month = (month + 12) % 12;
            --year;
        }
        long days = diff / 86400000L;
        long hours = (diff - days * 86400000L) / 3600000L;
        long minutes = (diff - days * 86400000L - hours * 3600000L) / 60000L;
        long s = diff / 1000L - days * 24L * 60L * 60L - hours * 60L * 60L - minutes * 60L;
        String CountTime = year + "\u5e74" + month + "\u6708" + day + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        if (year == 0) {
            CountTime = month + "\u6708" + day + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0) {
            CountTime = day + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0 && day == 0) {
            CountTime = hours + "\u5c0f\u65f6" + minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0 && day == 0 && hours == 0L) {
            CountTime = minutes + "\u5206" + s + "\u79d2";
        }
        if (year == 0 && month == 0 && day == 0 && hours == 0L && minutes == 0L) {
            CountTime = s + "\u79d2";
        }
        return CountTime;
    }

    public static Calendar dataToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

