/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.score.DycUmcSupplierQueryWaiteRatingRulesBusiService;
import com.tydic.dyc.umc.model.score.qrybo.DycUmcSupplierQueryWaiteRatingRulesBusiReqBo;
import com.tydic.dyc.umc.model.score.qrybo.DycUmcSupplierQueryWaiteRatingRulesBusiRspBo;
import com.tydic.dyc.umc.repository.dao.AssessmentRatingRulesItemCatMapper;
import com.tydic.dyc.umc.repository.dao.SupplierAssessmentRatingRulesMapper;
import com.tydic.dyc.umc.repository.po.AssessmentRatingRulesItemCatPO;
import com.tydic.dyc.umc.repository.po.SupplierAssessmentRatingRulesPO;
import com.tydic.dyc.umc.service.score.bo.DycUmcSupplierAssessmentRatingRulesBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUmcSupplierQueryWaiteRatingRulesBusiServiceImpl
implements DycUmcSupplierQueryWaiteRatingRulesBusiService {
    @Autowired
    private SupplierAssessmentRatingRulesMapper supplierAssessmentRatingRulesMapper;
    @Autowired
    private AssessmentRatingRulesItemCatMapper assessmentRatingRulesItemCatMapper;
    @Value(value="${rating_default:false}")
    private Boolean rating_default;
    private static final String MONTH = "1";
    private static final String JIDU = "2";
    private static final String YEAR = "3";

    public DycUmcSupplierQueryWaiteRatingRulesBusiRspBo queryWaiteRatingRules(DycUmcSupplierQueryWaiteRatingRulesBusiReqBo reqBo) {
        SupplierAssessmentRatingRulesPO ratingRulesPO = new SupplierAssessmentRatingRulesPO();
        ratingRulesPO.setRatingRulesStatus(MONTH);
        ratingRulesPO.setCreateStatus(MONTH);
        Page page = new Page(-1, -1);
        List<SupplierAssessmentRatingRulesPO> list = this.supplierAssessmentRatingRulesMapper.selectRatingList(ratingRulesPO, (Page<SupplierAssessmentRatingRulesPO>)page);
        if (this.rating_default.booleanValue()) {
            ArrayList<SupplierAssessmentRatingRulesPO> supplierAssessmentRatingRulesPOS = new ArrayList<SupplierAssessmentRatingRulesPO>();
            LocalDateTime currentTime = LocalDateTime.now();
            LocalDate localDate = LocalDateTime.now().toLocalDate();
            LocalDateTime minTime = null;
            for (SupplierAssessmentRatingRulesPO supplierAssessmentRatingRulesPO : list) {
                long between;
                if (MONTH.equals(supplierAssessmentRatingRulesPO.getRatingRulesCycle())) {
                    minTime = LocalDateTime.of(localDate.with(TemporalAdjusters.lastDayOfMonth()), LocalTime.MIN);
                } else if (YEAR.equals(supplierAssessmentRatingRulesPO.getRatingRulesCycle())) {
                    minTime = LocalDateTime.of(localDate.with(TemporalAdjusters.lastDayOfYear()), LocalTime.MIN);
                } else if (JIDU.equals(supplierAssessmentRatingRulesPO.getRatingRulesCycle())) {
                    Date currentQuarterEndTime = DycUmcSupplierQueryWaiteRatingRulesBusiServiceImpl.getCurrentQuarterEndTime();
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    minTime = LocalDateTime.parse(simpleDateFormat.format(currentQuarterEndTime), df);
                }
                if (!String.valueOf(between = ChronoUnit.DAYS.between(currentTime, minTime)).equals(supplierAssessmentRatingRulesPO.getRatingRulesDay())) continue;
                supplierAssessmentRatingRulesPOS.add(supplierAssessmentRatingRulesPO);
            }
            list = null;
            list.addAll(supplierAssessmentRatingRulesPOS);
        }
        HashMap catOneMap = new HashMap();
        for (SupplierAssessmentRatingRulesPO assessmentRatingRulesPO : list) {
            AssessmentRatingRulesItemCatPO rulesItemCatPO = new AssessmentRatingRulesItemCatPO();
            rulesItemCatPO.setRatingRulesId(assessmentRatingRulesPO.getRatingRulesId());
            List<AssessmentRatingRulesItemCatPO> itemCatPOS = this.assessmentRatingRulesItemCatMapper.selectRulesItemCatList(rulesItemCatPO);
            List catOneIdList = itemCatPOS.stream().map(AssessmentRatingRulesItemCatPO::getItemCatId).collect(Collectors.toList());
            catOneMap.put(assessmentRatingRulesPO.getRatingRulesId().toString(), catOneIdList);
        }
        List assessmentRatingRulesBoList = UmcRu.jsl(list, DycUmcSupplierAssessmentRatingRulesBo.class);
        DycUmcSupplierQueryWaiteRatingRulesBusiRspBo rspBo = new DycUmcSupplierQueryWaiteRatingRulesBusiRspBo();
        rspBo.setAssessmentRatingRulesBoList(assessmentRatingRulesBoList);
        rspBo.setCatOneMap(catOneMap);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public static Date getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = null;
        try {
            if (currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth <= 9) {
                c.set(2, 6);
            } else if (currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentQuarterEndTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DycUmcSupplierQueryWaiteRatingRulesBusiServiceImpl.getCurrentQuarterStartTime());
        cal.add(2, 2);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }
}

