/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditApprovalCallBackQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcCreditBpmApprovalUpdateApplyQryBO;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcQryCreditApplyInfoApprovalListQryBo;
import com.tydic.dyc.umc.model.creditApply.qrybo.UmcQryCreditApplyInfoQryBo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditApprovalCallBackSubDo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcCreditInfoApplySubDo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcQryCreditApplyInfoApprovalListSubDo;
import com.tydic.dyc.umc.model.creditApply.sub.UmcQryCreditApplyInfoSubDo;
import com.tydic.dyc.umc.repository.UmcQryCreditApplyInfoRepository;
import com.tydic.dyc.umc.repository.dao.UmcCreditAccountPeriodApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditAccountPeriodMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditContractApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditContractMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditCustomerApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditCustomerMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditGuarantorApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditGuarantorMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditInfoApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditRelatedCustomerApplyMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditRelatedCustomerMapper;
import com.tydic.dyc.umc.repository.dao.UmcCreditTemporaryInfoMapper;
import com.tydic.dyc.umc.repository.po.UmcCreditAccountPeriodPO;
import com.tydic.dyc.umc.repository.po.UmcCreditContractPO;
import com.tydic.dyc.umc.repository.po.UmcCreditCustomerPO;
import com.tydic.dyc.umc.repository.po.UmcCreditGuarantorPO;
import com.tydic.dyc.umc.repository.po.UmcCreditInfoApplyPO;
import com.tydic.dyc.umc.repository.po.UmcCreditRelatedCustomerPO;
import com.tydic.dyc.umc.repository.po.UmcQryCreditApplyInfoPo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditAccountPeriodApplyBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditContractApplyBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditCustomerApplyBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditGuarantorApplyBo;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditInfoApplyBO;
import com.tydic.dyc.umc.service.creditApply.bo.UmcCreditRelatedCustomerApplyBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UmcQryCreditApplyInfoRepositoryImpl
implements UmcQryCreditApplyInfoRepository {
    @Autowired
    private UmcCreditInfoApplyMapper umcCreditInfoApplyMapper;
    @Autowired
    private UmcCreditContractApplyMapper umcCreditContractApplyMapper;
    @Autowired
    private UmcCreditCustomerApplyMapper umcCreditCustomerApplyMapper;
    @Autowired
    private UmcCreditGuarantorApplyMapper umcCreditGuarantorApplyMapper;
    @Autowired
    private UmcCreditAccountPeriodApplyMapper umcCreditAccountPeriodApplyMapper;
    @Autowired
    private UmcCreditRelatedCustomerApplyMapper umcCreditRelatedCustomerApplyMapper;
    @Autowired
    private UmcCreditCustomerMapper umcCreditCustomerMapper;
    @Autowired
    private UmcCreditContractMapper umcCreditContractMapper;
    @Autowired
    private UmcCreditGuarantorMapper umcCreditGuarantorMapper;
    @Autowired
    private UmcCreditTemporaryInfoMapper umcCreditTemporaryInfoMapper;
    @Autowired
    private UmcCreditAccountPeriodMapper umcCreditAccountPeriodMapper;
    @Autowired
    private UmcCreditRelatedCustomerMapper umcCreditRelatedCustomerMapper;

    public UmcQryCreditApplyInfoSubDo qryCreditApplyInfo(UmcQryCreditApplyInfoQryBo reqBo) {
        UmcQryCreditApplyInfoSubDo subDo = new UmcQryCreditApplyInfoSubDo();
        subDo.setRespCode("0000");
        UmcCreditInfoApplyPO umcCreditInfoApplyPO = new UmcCreditInfoApplyPO();
        umcCreditInfoApplyPO.setApplyId(reqBo.getApplyId());
        UmcQryCreditApplyInfoPo applyInfoPo = this.umcCreditInfoApplyMapper.qryCreditApplyInfo(umcCreditInfoApplyPO);
        if (!ObjectUtils.isEmpty((Object)applyInfoPo)) {
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getCreditContractApplyPO())) {
                UmcCreditContractApplyBo umcCreditContractApplyBo = (UmcCreditContractApplyBo)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getCreditContractApplyPO()), UmcCreditContractApplyBo.class);
                subDo.setCreditContractApplyBo(umcCreditContractApplyBo);
            }
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getCreditGuarantorApplyPO())) {
                UmcCreditGuarantorApplyBo umcCreditGuarantorApplyBo = (UmcCreditGuarantorApplyBo)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getCreditGuarantorApplyPO()), UmcCreditGuarantorApplyBo.class);
                subDo.setCreditGuarantorApplyBo(umcCreditGuarantorApplyBo);
            }
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getCreditInfoApplyPO())) {
                UmcCreditInfoApplyBO umcCreditInfoApplyBO = (UmcCreditInfoApplyBO)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getCreditInfoApplyPO()), UmcCreditInfoApplyBO.class);
                subDo.setCreditInfoApplyBO(umcCreditInfoApplyBO);
            }
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getCreditCustomerApplyPO())) {
                UmcCreditCustomerApplyBo umcCreditCustomerApplyBo = (UmcCreditCustomerApplyBo)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getCreditCustomerApplyPO()), UmcCreditCustomerApplyBo.class);
                subDo.setCreditCustomerApplyBo(umcCreditCustomerApplyBo);
            }
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getUmcCreditAccountPeriodApplyPO())) {
                UmcCreditAccountPeriodApplyBo umcCreditAccountPeriodApplyBo = (UmcCreditAccountPeriodApplyBo)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getUmcCreditAccountPeriodApplyPO()), UmcCreditAccountPeriodApplyBo.class);
                subDo.setUmcCreditAccountPeriodApplyBo(umcCreditAccountPeriodApplyBo);
            }
            if (!CollectionUtils.isEmpty(applyInfoPo.getUmcCreditRelatedCustomerApplyPOS())) {
                List umcCreditCustomerApplyBos = JSONObject.parseArray((String)JSON.toJSONString(applyInfoPo.getUmcCreditRelatedCustomerApplyPOS()), UmcCreditRelatedCustomerApplyBo.class);
                subDo.setUmcCreditRelatedCustomerApplyBos(umcCreditCustomerApplyBos);
            }
        }
        return subDo;
    }

    public UmcQryCreditApplyInfoApprovalListSubDo creditApplyApprovalList(UmcQryCreditApplyInfoApprovalListQryBo reqBo) {
        UmcQryCreditApplyInfoApprovalListSubDo subDo = new UmcQryCreditApplyInfoApprovalListSubDo();
        subDo.setRespCode("0000");
        UmcCreditInfoApplyPO po = (UmcCreditInfoApplyPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UmcCreditInfoApplyPO.class);
        po.setExcludeStatusList(Arrays.asList("1", "2", "3"));
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        po.setOrgId(null);
        List<UmcCreditInfoApplyPO> listPage = this.umcCreditInfoApplyMapper.getListPage(po, (Page<UmcCreditInfoApplyPO>)page);
        if (!CollectionUtils.isEmpty(listPage)) {
            List collect = listPage.stream().map(e -> (UmcCreditInfoApplyBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UmcCreditInfoApplyBO.class)).collect(Collectors.toList());
            subDo.setRows(collect);
        }
        subDo.setPageNo(Integer.valueOf(page.getPageNo()));
        subDo.setTotal(Integer.valueOf(page.getTotalPages()));
        subDo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return subDo;
    }

    public UmcCreditApprovalCallBackSubDo approvalCallBack(UmcCreditApprovalCallBackQryBo reqBO) {
        UmcCreditContractPO contractPO = null;
        UmcCreditGuarantorPO guarantorPO = null;
        UmcCreditCustomerPO customerPO = null;
        UmcCreditAccountPeriodPO accountPeriodPO = null;
        List<UmcCreditRelatedCustomerPO> relatedCustomerPOs = null;
        this.organizationalData(contractPO, guarantorPO, customerPO, accountPeriodPO, relatedCustomerPOs, reqBO.getApplyId());
        this.addData(contractPO, guarantorPO, customerPO, accountPeriodPO, relatedCustomerPOs, reqBO.getApplyId());
        this.dealUpdateStatus(reqBO.getApplyId(), "5");
        return (UmcCreditApprovalCallBackSubDo)UmcRu.success(UmcCreditApprovalCallBackSubDo.class);
    }

    public UmcCreditApprovalCallBackSubDo approvalCallBackReject(UmcCreditApprovalCallBackQryBo reqBO) {
        this.dealUpdateStatus(reqBO.getApplyId(), "6");
        return (UmcCreditApprovalCallBackSubDo)UmcRu.success(UmcCreditApprovalCallBackSubDo.class);
    }

    public UmcCreditInfoApplySubDo qryCreditApply(Long applyId) {
        UmcCreditInfoApplyPO infoApplyPO = new UmcCreditInfoApplyPO();
        infoApplyPO.setApplyId(applyId);
        UmcCreditInfoApplyPO model = this.umcCreditInfoApplyMapper.getModelBy(infoApplyPO);
        if (!ObjectUtils.isEmpty((Object)model)) {
            return (UmcCreditInfoApplySubDo)JSONObject.parseObject((String)JSON.toJSONString((Object)model), UmcCreditInfoApplySubDo.class);
        }
        return null;
    }

    public Long qryCreditApplyId(Long orgIdWeb) {
        UmcCreditInfoApplyPO applyPO = new UmcCreditInfoApplyPO();
        applyPO.setOrderBy("create_time desc");
        applyPO.setOrgId(orgIdWeb);
        List<UmcCreditInfoApplyPO> list = this.umcCreditInfoApplyMapper.getList(applyPO);
        if (!CollectionUtils.isEmpty(list)) {
            return list.get(0).getApplyId();
        }
        return null;
    }

    public void updateApplyInfo(UmcCreditBpmApprovalUpdateApplyQryBO qryBO) {
        UmcCreditInfoApplyPO where = new UmcCreditInfoApplyPO();
        UmcCreditInfoApplyPO set = new UmcCreditInfoApplyPO();
        where.setApplyId(qryBO.getApplyId());
        set.setExtField1(qryBO.getInstanceId());
        set.setApplyStatus(qryBO.getApplyStatus());
        set.setExtField2(qryBO.getInstaceSbumitUrl());
        set.setExtField3(qryBO.getInstanceQryLogUrl());
        try {
            this.umcCreditInfoApplyMapper.updateBy(set, where);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("201013", "\u66f4\u65b0\u5ba1\u6279\u5b9e\u4f8bid\u5f02\u5e38" + e.getMessage());
        }
    }

    public UmcCreditInfoApplySubDo qryCreditApplyInfoByInstanceId(String instanceId) {
        UmcCreditInfoApplyPO applyPO = new UmcCreditInfoApplyPO();
        applyPO.setExtField1(instanceId);
        UmcCreditInfoApplyPO modelBy = this.umcCreditInfoApplyMapper.getModelBy(applyPO);
        if (ObjectUtils.isEmpty((Object)modelBy)) {
            throw new BaseBusinessException("201013", "\u672a\u67e5\u8be2\u5230\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a" + instanceId + "\u7684\u5ba1\u6279\u6570\u636e");
        }
        return (UmcCreditInfoApplySubDo)JSONObject.parseObject((String)JSON.toJSONString((Object)modelBy), UmcCreditInfoApplySubDo.class);
    }

    private void dealUpdateStatus(Long applyId, String applyStatus) {
        UmcCreditInfoApplyPO where = new UmcCreditInfoApplyPO();
        where.setApplyId(applyId);
        UmcCreditInfoApplyPO set = new UmcCreditInfoApplyPO();
        set.setApplyStatus(applyStatus);
        try {
            this.umcCreditInfoApplyMapper.updateBy(set, where);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("201013", "\u5ba1\u6279\u901a\u8fc7\u66f4\u65b0\u5ba1\u6279\u72b6\u6001\u5931\u8d25" + e.getMessage());
        }
    }

    private void addData(UmcCreditContractPO contractPO, UmcCreditGuarantorPO guarantorPO, UmcCreditCustomerPO customerPO, UmcCreditAccountPeriodPO accountPeriodPO, List<UmcCreditRelatedCustomerPO> relatedCustomerPOs, Long applyId) {
        try {
            if (!ObjectUtils.isEmpty((Object)contractPO)) {
                this.umcCreditContractMapper.insert(contractPO);
            }
            if (!ObjectUtils.isEmpty((Object)guarantorPO)) {
                this.umcCreditGuarantorMapper.insert(guarantorPO);
            }
            if (!ObjectUtils.isEmpty((Object)customerPO)) {
                this.umcCreditCustomerMapper.insert(customerPO);
            }
            if (!ObjectUtils.isEmpty((Object)accountPeriodPO)) {
                this.umcCreditAccountPeriodMapper.insert(accountPeriodPO);
            }
            if (!CollectionUtils.isEmpty(relatedCustomerPOs)) {
                this.umcCreditRelatedCustomerMapper.insertBatch(relatedCustomerPOs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("201013", "\u5ba1\u6279\u901a\u8fc7\u65b0\u589e\u4e3b\u8868\u5931\u8d25" + e.getMessage());
        }
    }

    private void organizationalData(UmcCreditContractPO contractPO, UmcCreditGuarantorPO guarantorPO, UmcCreditCustomerPO customerPO, UmcCreditAccountPeriodPO accountPeriodPO, List<UmcCreditRelatedCustomerPO> relatedCustomerPOs, Long applyId) {
        UmcCreditInfoApplyPO applyPO = new UmcCreditInfoApplyPO();
        applyPO.setApplyId(applyId);
        UmcQryCreditApplyInfoPo applyInfoPo = this.umcCreditInfoApplyMapper.qryCreditApplyInfo(applyPO);
        if (!ObjectUtils.isEmpty((Object)applyInfoPo)) {
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getUmcCreditAccountPeriodApplyPO())) {
                accountPeriodPO = (UmcCreditAccountPeriodPO)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getUmcCreditAccountPeriodApplyPO()), UmcCreditAccountPeriodPO.class);
            }
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getCreditCustomerApplyPO())) {
                customerPO = (UmcCreditCustomerPO)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getCreditCustomerApplyPO()), UmcCreditCustomerPO.class);
            }
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getCreditGuarantorApplyPO())) {
                guarantorPO = (UmcCreditGuarantorPO)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getCreditGuarantorApplyPO()), UmcCreditGuarantorPO.class);
            }
            if (!ObjectUtils.isEmpty((Object)applyInfoPo.getCreditContractApplyPO())) {
                contractPO = (UmcCreditContractPO)JSONObject.parseObject((String)JSON.toJSONString((Object)applyInfoPo.getCreditContractApplyPO()), UmcCreditContractPO.class);
            }
            if (!CollectionUtils.isEmpty(applyInfoPo.getUmcCreditRelatedCustomerApplyPOS())) {
                relatedCustomerPOs = JSONObject.parseArray((String)JSON.toJSONString(applyInfoPo.getUmcCreditRelatedCustomerApplyPOS()), UmcCreditRelatedCustomerPO.class);
            }
        }
    }
}

