/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.bmanagement.PlatformNotifyBusiService;
import com.tydic.dyc.umc.model.bmanagement.UmcSupMisconductHandleBusiService;
import com.tydic.dyc.umc.model.bmanagement.qrybo.PlatformNotifySendBusiReqBO;
import com.tydic.dyc.umc.model.bmanagement.qrybo.UmcSupMisconductHandleBusiReqBO;
import com.tydic.dyc.umc.model.bmanagement.sub.UmcSupMisconductHandleBusiRspBO;
import com.tydic.dyc.umc.repository.dao.MemberMapper;
import com.tydic.dyc.umc.repository.dao.SupplierInfoMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductNoticeMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductNoticeTemplateMapper;
import com.tydic.dyc.umc.repository.po.MemberPO;
import com.tydic.dyc.umc.repository.po.SupplierInfoPO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductNoticePO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductNoticeTemplatePO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductPO;
import com.tydic.dyc.umc.repository.po.UmcSupMemberInfoBO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UmcSupMisconductHandleBusiServiceImpl
implements UmcSupMisconductHandleBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupMisconductHandleBusiServiceImpl.class);
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private SupplierMisconductNoticeMapper supplierMisconductNoticeMapper;
    @Autowired
    private SupplierMisconductNoticeTemplateMapper supplierMisconductNoticeTemplateMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private PlatformNotifyBusiService platformNotifyBusiService;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${SupplierOrderManagerRoleId:434395663384109056}")
    private Long SupplierOrderManagerRoleId;
    @Value(value="${SupplierGoodsManagerRoleId:434396720457768960}")
    private Long SupplierGoodsManagerRoleId;

    public UmcSupMisconductHandleBusiRspBO supMisconductHandle(UmcSupMisconductHandleBusiReqBO reqBO) {
        UmcSupMisconductHandleBusiRspBO rspBO = new UmcSupMisconductHandleBusiRspBO();
        SupplierMisconductPO supplierMisconductPO = this.supplierMisconductMapper.selectByPrimaryKey(reqBO.getMisconductId());
        SupplierMisconductPO smPO = new SupplierMisconductPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)smPO);
        String[] handleResults = reqBO.getHandleResult().split(",");
        String handleResultDesc = "";
        SupplierMisconductNoticePO smnPO = new SupplierMisconductNoticePO();
        smnPO.setHandleResult(reqBO.getHandleResult());
        for (String handleResult : handleResults) {
            if (handleResult.equals(UmcCommConstants.MisconductHandleResult.WARNING.toString())) {
                handleResultDesc = handleResultDesc + "\u8b66\u544a;";
            }
            if (handleResult.equals(UmcCommConstants.MisconductHandleResult.DEDUCT.toString())) {
                handleResultDesc = handleResultDesc + "\u6263\u5206:" + reqBO.getDeductPoints() + ";";
                smnPO.setDeductPoints(reqBO.getDeductPoints());
            }
            if (handleResult.equals(UmcCommConstants.MisconductHandleResult.PENALTY.toString())) {
                handleResultDesc = handleResultDesc + "\u7f5a\u6b3e:" + reqBO.getPenaltyAmount() + "\u5143;";
                try {
                    smnPO.setPenaltyAmount(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getPenaltyAmount()));
                }
                catch (Exception e) {
                    throw new BaseBusinessException("8888", "\u7f5a\u6b3e\u91d1\u989d\u91d1\u989d\u5904\u7406\u9519\u8bef");
                }
            }
            if (!handleResult.equals(UmcCommConstants.MisconductHandleResult.NO_ADOPT.toString())) continue;
            handleResultDesc = "\u4e0d\u4e88\u91c7\u7eb3;";
            smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.NO_ADOPT);
        }
        smPO.setHandleResultDesc(handleResultDesc);
        smPO.setHandleStatus(UmcCommConstants.MisconductHandleStatus.HANDLED);
        smPO.setHandleId(reqBO.getUserId());
        smPO.setHandleName(reqBO.getUserName());
        smPO.setHandleTime(new Date());
        SupplierMisconductNoticeTemplatePO misconductNoticeTemplatePO = this.supplierMisconductNoticeTemplateMapper.selectByPrimaryKey(reqBO.getTemplateId());
        if (misconductNoticeTemplatePO != null) {
            SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
            String now = shortSdf.format(new Date());
            Map misconductTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_TYPE_STR");
            String templateMessage = misconductNoticeTemplatePO.getTemplateDesc();
            templateMessage = templateMessage.replaceAll("#deductPoints#", null != reqBO.getDeductPoints() ? reqBO.getDeductPoints().toString() : "0");
            templateMessage = templateMessage.replaceAll("#deductPointsTime#", now);
            templateMessage = templateMessage.replaceAll("#margin#", null != reqBO.getPenaltyAmount() ? reqBO.getPenaltyAmount().toString() : "0");
            templateMessage = templateMessage.replaceAll("#misconductRuleDocUrl#", "\u300a\u4e0d\u826f\u8bb0\u5f55\u89c4\u5219\u6587\u6863\u300b");
            templateMessage = templateMessage.replaceAll("#misconductTypeStr#", (String)misconductTypeMap.get(supplierMisconductPO.getMisconductType().toString()));
            templateMessage = templateMessage.replaceAll("#supplierName#", supplierMisconductPO.getSupplierName());
            templateMessage = templateMessage.replaceAll("#systemTime#", now);
            smnPO.setTemplateMessage(templateMessage);
        }
        if (!handleResults[0].equals(UmcCommConstants.MisconductHandleResult.NO_ADOPT.toString())) {
            smPO.setMisconductStatus(Integer.parseInt(reqBO.getAuditStatus()));
            smPO.setHandleStatus(UmcCommConstants.MisconductHandleStatus.HANDLING);
            smPO.setReasonDesc(null);
        }
        smPO.setOrgId(null);
        smPO.setOrgName(null);
        this.supplierMisconductMapper.updateByPrimaryKeySelective(smPO);
        smnPO.setCreateId(reqBO.getUserId());
        smnPO.setCreateName(reqBO.getUserName());
        smnPO.setCreateTime(new Date());
        smnPO.setNoticeId(Sequence.getInstance().nextId());
        smnPO.setTemplateId(reqBO.getTemplateId());
        smnPO.setMisconductId(reqBO.getMisconductId());
        smnPO.setNoticeStatus(UmcCommConstants.DicDelFlag.YES);
        smnPO.setSupplierName(supplierMisconductPO.getSupplierName());
        this.supplierMisconductNoticeMapper.insert(smnPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendUmcSysMailSend(UmcSupMisconductHandleBusiReqBO reqBO, Long supplierId, String handleResultDesc) {
        SupplierInfoPO supplierInfoPO = this.supplierInfoMapper.selectByPrimaryKey(supplierId);
        MemberPO memberPO = new MemberPO();
        memberPO.setOrgId(supplierInfoPO.getOrgId());
        memberPO.setStopStatus("01");
        Page page = new Page(-1, -1);
        List umcSupMemberInfoBOS = this.memberMapper.getSupplierMemByPage(memberPO, page);
        if (umcSupMemberInfoBOS != null && umcSupMemberInfoBOS.size() > 0) {
            for (UmcSupMemberInfoBO userItem : umcSupMemberInfoBOS) {
                if (StringUtils.isEmpty((CharSequence)userItem.getRoleJson()) || !userItem.getRoleJson().contains(this.SupplierOrderManagerRoleId.toString())) continue;
                PlatformNotifySendBusiReqBO busiReqBO = new PlatformNotifySendBusiReqBO();
                busiReqBO.setUserId(reqBO.getUserId());
                busiReqBO.setReceiveId(userItem.getUserId());
                busiReqBO.setSendType(UmcCommConstants.PlatformNotifyType.ORDER_SEND_MESSAGE);
                busiReqBO.setTitel("\u4e0d\u826f\u8bb0\u5f55\u5904\u7f5a\u901a\u77e5\u4e66");
                busiReqBO.setText("\u5904\u7f5a\u5185\u5bb9\uff1a" + handleResultDesc);
                this.platformNotifyBusiService.sendPlatformNotify(busiReqBO);
            }
        }
    }
}

