/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.blmanagement.UmcAddSupEnterpriseBlacklistBusiService;
import com.tydic.dyc.umc.model.blmanagement.qrybo.UmcAddEnterpriseBlacklistBusiReqBO;
import com.tydic.dyc.umc.model.blmanagement.sub.UmcAddEnterpriseBlacklistBusiRspBO;
import com.tydic.dyc.umc.repository.dao.ExtEnterpriseOrgMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseBlacklistMapper;
import com.tydic.dyc.umc.repository.po.EnterpriseOrgPO;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseBlacklistPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UmcAddSupEnterpriseBlacklistBusiServiceImpl
implements UmcAddSupEnterpriseBlacklistBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcAddSupEnterpriseBlacklistBusiServiceImpl.class);
    @Autowired
    private UmcEnterpriseBlacklistMapper umcEnterpriseBlacklistMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private ExtEnterpriseOrgMapper extEnterpriseOrgMapper;

    public UmcAddEnterpriseBlacklistBusiRspBO addSupEnterpriseBlacklist(UmcAddEnterpriseBlacklistBusiReqBO reqBO) {
        Long blacklistId;
        UmcAddEnterpriseBlacklistBusiRspBO rspBO = new UmcAddEnterpriseBlacklistBusiRspBO();
        List<UmcEnterpriseBlacklistPO> tempList = this.umcEnterpriseBlacklistMapper.selectByEnterpriseId(reqBO.getEnterpriseId());
        if (!CollectionUtils.isEmpty(tempList) && tempList.size() > 0) {
            AtomicBoolean flag = new AtomicBoolean(false);
            tempList.stream().forEach(e -> {
                if (e.getStatus() == 0 || e.getStatus() == 1 || e.getStatus() == 2) {
                    flag.set(true);
                }
            });
            if (flag.get()) {
                rspBO.setRespCode("163048");
                rspBO.setRespDesc("\u8be5\u4f9b\u5e94\u5546\u5df2\u52a0\u5165\u9ed1\u540d\u5355\u6216\u5df2\u63d0\u4ea4\u5ba1\u6279\u4fe1\u606f\uff01");
                return rspBO;
            }
        }
        UmcEnterpriseBlacklistPO conditionPO = new UmcEnterpriseBlacklistPO();
        if (!ObjectUtils.isEmpty((Object)reqBO.getBlacklistId())) {
            try {
                blacklistId = reqBO.getBlacklistId();
                UmcEnterpriseBlacklistPO preBO = this.umcEnterpriseBlacklistMapper.selectByPrimaryKey(reqBO.getBlacklistId());
                this.umcEnterpriseBlacklistMapper.deleteByPrimaryKey(reqBO.getBlacklistId());
                BeanUtils.copyProperties((Object)reqBO, (Object)conditionPO);
                conditionPO.setCreateTime(new Date());
                conditionPO.setCreateNo(preBO.getCreateNo());
                conditionPO.setIsDel("0");
                conditionPO.setStatus(reqBO.getBlackStatus());
                if (UmcCommConstants.blackStatus.APPROVED.equals(reqBO.getBlackStatus())) {
                    this.stopEnterprise(reqBO);
                }
                this.umcEnterpriseBlacklistMapper.insert(conditionPO);
            }
            catch (Exception e2) {
                throw new BaseBusinessException("163049", "\u66f4\u65b0\u5931\u8d25\uff01" + e2.getMessage());
            }
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)conditionPO);
        blacklistId = Sequence.getInstance().nextId();
        conditionPO.setBlacklistId(blacklistId);
        conditionPO.setStatus(reqBO.getBlackStatus());
        conditionPO.setIsDel("0");
        conditionPO.setCreateTime(new Date());
        if (UmcCommConstants.blackStatus.APPROVED.equals(reqBO.getBlackStatus())) {
            this.stopEnterprise(reqBO);
        }
        try {
            this.umcEnterpriseBlacklistMapper.insert(conditionPO);
        }
        catch (Exception e3) {
            throw new BaseBusinessException("163050", "\u65b0\u589e\u9ed1\u540d\u5355\u4fe1\u606f\u5931\u8d25\uff01" + e3.getMessage());
        }
        if (UmcCommConstants.blackStatus.APPROVED.equals(reqBO.getBlackStatus())) {
            this.editBalckListStatus(UmcCommConstants.blackStatus.APPROVED, reqBO.getBlacklistId());
            this.stopEnterprise(reqBO);
        }
        rspBO.setBlacklistId(blacklistId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void editBalckListStatus(Integer auditType, Long mlacklistId) {
        UmcEnterpriseBlacklistPO conditionPO = new UmcEnterpriseBlacklistPO();
        conditionPO.setBlacklistId(mlacklistId);
        if (UmcCommConstants.blackStatus.APPROVED.equals(auditType)) {
            conditionPO.setStatus(UmcCommConstants.blackStatus.APPROVED);
        } else if (UmcCommConstants.blackStatus.REFUSE.equals(auditType)) {
            conditionPO.setStatus(UmcCommConstants.blackStatus.REFUSE);
        }
        try {
            System.err.println("------------\u9ed1\u540d\u5355\u66f4\u65b0\u72b6\u6001\u5165\u53c2\uff1a--------------" + conditionPO);
            this.umcEnterpriseBlacklistMapper.updateByPrimaryKeySelective(conditionPO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("163051", "\u5ba1\u6838\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void stopEnterprise(UmcAddEnterpriseBlacklistBusiReqBO reqBO) {
        EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
        enterpriseOrgPO.setOrgId(reqBO.getEnterpriseId());
        enterpriseOrgPO.setStatus("0");
        int update = this.extEnterpriseOrgMapper.updateById(enterpriseOrgPO);
        if (update < 1) {
            throw new BaseBusinessException("163001", "\u4fee\u6539\u673a\u6784\u72b6\u6001\u5931\u8d25");
        }
    }
}

