/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressAreaInfoQryBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressCityInfoQryBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressInfoQryBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressProvinceInfoQryBo;
import com.tydic.dyc.umc.model.address.qrybo.UmcAddressTownsInfoQryBo;
import com.tydic.dyc.umc.model.addrprovince.qrybo.UmcAddrBo;
import com.tydic.dyc.umc.repository.UmcAddressInfoRepository;
import com.tydic.dyc.umc.repository.dao.AddrAreaMapper;
import com.tydic.dyc.umc.repository.dao.AddrCityMapper;
import com.tydic.dyc.umc.repository.dao.AddrProvinceMapper;
import com.tydic.dyc.umc.repository.dao.AddrTownsMapper;
import com.tydic.dyc.umc.repository.dao.UmcAddressMapper;
import com.tydic.dyc.umc.repository.po.AddrAreaPo;
import com.tydic.dyc.umc.repository.po.AddrCityPo;
import com.tydic.dyc.umc.repository.po.AddrProvincePo;
import com.tydic.dyc.umc.repository.po.AddrTownsPo;
import com.tydic.dyc.umc.repository.po.UmcAddressCityPo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcAddressInfoRepositoryImpl
implements UmcAddressInfoRepository {
    @Autowired
    private UmcAddressMapper umcAddressMapper;
    @Autowired
    private AddrProvinceMapper addrProvinceMapper;
    @Autowired
    private AddrCityMapper addrCityMapper;
    @Autowired
    private AddrAreaMapper addrAreaMapper;
    @Autowired
    private AddrTownsMapper addrTownsMapper;

    public BasePageRspBo<UmcAddressCityInfoQryBo> getAddressCityInfoList(UmcAddressCityInfoQryBo umcAddressCityInfoBo) {
        UmcAddressCityPo addrCityPo = (UmcAddressCityPo)UmcRu.js((Object)umcAddressCityInfoBo, UmcAddressCityPo.class);
        Page page = new Page(umcAddressCityInfoBo.getPageNo(), umcAddressCityInfoBo.getPageSize());
        List<UmcAddressCityPo> rows = this.umcAddressMapper.getListPage(addrCityPo, (Page<UmcAddressCityPo>)page);
        BasePageRspBo rspBo = new BasePageRspBo();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(rows) ? UmcRu.jsl(rows, UmcAddressCityInfoQryBo.class) : new ArrayList(0));
        return rspBo;
    }

    public void dealAddressProvinceInfoList(List<UmcAddressProvinceInfoQryBo> qryBos) {
        AddrProvincePo addrProvincePo = new AddrProvincePo();
        List provincePos = this.addrProvinceMapper.getList(addrProvincePo);
        ArrayList<AddrProvincePo> addrProvincePos = new ArrayList<AddrProvincePo>();
        if (!CollectionUtils.isEmpty((Collection)provincePos)) {
            Map<String, List<AddrProvincePo>> map = provincePos.stream().collect(Collectors.groupingBy(AddrProvincePo::getCode));
            for (UmcAddressProvinceInfoQryBo each : qryBos) {
                AddrProvincePo js = (AddrProvincePo)UmcRu.js((Object)each, AddrProvincePo.class);
                if (map != null && map.containsKey(each.getCode())) {
                    List<AddrProvincePo> addrProvincePoList = map.get(each.getCode());
                    if (CollectionUtils.isEmpty(addrProvincePoList) || addrProvincePoList.get(0).getName().equals(each.getName())) continue;
                    AddrProvincePo whereParam = new AddrProvincePo();
                    whereParam.setCode(each.getCode());
                    this.addrProvinceMapper.updateBy(js, whereParam);
                    continue;
                }
                addrProvincePos.add(js);
            }
            if (!CollectionUtils.isEmpty(addrProvincePos)) {
                this.addrProvinceMapper.insertBatch(addrProvincePos);
            }
            Set collect = qryBos.stream().map(UmcAddressProvinceInfoQryBo::getCode).collect(Collectors.toSet());
            for (AddrProvincePo each : provincePos) {
                if (CollectionUtils.isEmpty(collect) || collect.contains(each.getCode())) continue;
                AddrProvincePo delAddrProvincePo = new AddrProvincePo();
                delAddrProvincePo.setCode(each.getCode());
                this.umcAddressMapper.deleteProvince(delAddrProvincePo);
            }
        }
    }

    public void dealAddressCityInfoList(List<UmcAddressCityInfoQryBo> qryBos) {
        AddrCityPo qryAddrCityPo = new AddrCityPo();
        List cityPos = this.addrCityMapper.getList(qryAddrCityPo);
        if (!CollectionUtils.isEmpty((Collection)cityPos)) {
            ArrayList<AddrCityPo> addrCityPos = new ArrayList<AddrCityPo>();
            Map<String, List<AddrCityPo>> map = cityPos.stream().collect(Collectors.groupingBy(AddrCityPo::getCode));
            for (UmcAddressCityInfoQryBo each : qryBos) {
                AddrCityPo js = (AddrCityPo)UmcRu.js((Object)each, AddrCityPo.class);
                if (map != null && map.containsKey(each.getCode())) {
                    AddrCityPo addrCityPo;
                    List<AddrCityPo> addrCityPoList = map.get(each.getCode());
                    if (CollectionUtils.isEmpty(addrCityPoList) || (addrCityPo = addrCityPoList.get(0)).getName().equals(each.getName()) && addrCityPo.getProvinceCode().equals(each.getProvinceCode())) continue;
                    AddrCityPo whereParam = new AddrCityPo();
                    whereParam.setCode(each.getCode());
                    this.addrCityMapper.updateBy(js, whereParam);
                    continue;
                }
                addrCityPos.add(js);
            }
            if (!CollectionUtils.isEmpty(addrCityPos)) {
                this.addrCityMapper.insertBatch(addrCityPos);
            }
            Set collect = qryBos.stream().map(UmcAddressCityInfoQryBo::getCode).collect(Collectors.toSet());
            for (AddrCityPo each : cityPos) {
                if (CollectionUtils.isEmpty(collect) || collect.contains(each.getCode())) continue;
                AddrCityPo delAddrCityPo = new AddrCityPo();
                delAddrCityPo.setCode(each.getCode());
                this.umcAddressMapper.deleteCity(delAddrCityPo);
            }
        }
    }

    public void dealAddressAreaInfoList(List<UmcAddressAreaInfoQryBo> qryBos) {
        AddrAreaPo qryAddrAreaPo = new AddrAreaPo();
        List addrAreaPos = this.addrAreaMapper.getList(qryAddrAreaPo);
        if (!CollectionUtils.isEmpty((Collection)addrAreaPos)) {
            ArrayList<AddrAreaPo> addrAreaPoList = new ArrayList<AddrAreaPo>();
            Map<String, List<AddrAreaPo>> map = addrAreaPos.stream().collect(Collectors.groupingBy(AddrAreaPo::getCode));
            for (UmcAddressAreaInfoQryBo each : qryBos) {
                AddrAreaPo js = (AddrAreaPo)UmcRu.js((Object)each, AddrAreaPo.class);
                if (map != null && map.containsKey(each.getCode())) {
                    AddrAreaPo addrAreaPo;
                    List<AddrAreaPo> areaPoList = map.get(each.getCode());
                    if (CollectionUtils.isEmpty(areaPoList) || (addrAreaPo = areaPoList.get(0)).getName().equals(each.getName()) && addrAreaPo.getCityCode().equals(each.getCityCode())) continue;
                    AddrAreaPo whereParam = new AddrAreaPo();
                    whereParam.setCode(each.getCode());
                    this.addrAreaMapper.updateBy(js, whereParam);
                    continue;
                }
                addrAreaPoList.add(js);
            }
            if (!CollectionUtils.isEmpty(addrAreaPoList)) {
                this.addrAreaMapper.insertBatch(addrAreaPoList);
            }
            Set collect = qryBos.stream().map(UmcAddressAreaInfoQryBo::getCode).collect(Collectors.toSet());
            for (AddrAreaPo each : addrAreaPos) {
                if (CollectionUtils.isEmpty(collect) || collect.contains(each.getCode())) continue;
                AddrAreaPo delAddrAreaPo = new AddrAreaPo();
                delAddrAreaPo.setCode(each.getCode());
                this.umcAddressMapper.deleteArea(delAddrAreaPo);
            }
        }
    }

    public void dealAddressTownsInfoList(List<UmcAddressTownsInfoQryBo> qryBos) {
        AddrTownsPo qryAddrTownsPo = new AddrTownsPo();
        List townsPos = this.addrTownsMapper.getList(qryAddrTownsPo);
        if (!CollectionUtils.isEmpty((Collection)townsPos)) {
            Map<String, List<AddrTownsPo>> map = townsPos.stream().collect(Collectors.groupingBy(AddrTownsPo::getCode));
            ArrayList<AddrTownsPo> addrTownsPos = new ArrayList<AddrTownsPo>();
            for (UmcAddressTownsInfoQryBo each : qryBos) {
                AddrTownsPo js = (AddrTownsPo)UmcRu.js((Object)each, AddrTownsPo.class);
                if (map != null && map.containsKey(each.getCode())) {
                    AddrTownsPo addrTownsPo;
                    List<AddrTownsPo> addrTownsPoList = map.get(each.getCode());
                    if (CollectionUtils.isEmpty(addrTownsPoList) || (addrTownsPo = addrTownsPoList.get(0)).getName().equals(each.getName()) && addrTownsPo.getAreaCode().equals(each.getAreaCode())) continue;
                    AddrTownsPo whereParam = new AddrTownsPo();
                    whereParam.setCode(each.getCode());
                    this.addrTownsMapper.updateBy(js, whereParam);
                    continue;
                }
                addrTownsPos.add(js);
            }
            if (!CollectionUtils.isEmpty(addrTownsPos)) {
                this.addrTownsMapper.insertBatch(addrTownsPos);
            }
            Set collect = qryBos.stream().map(UmcAddressTownsInfoQryBo::getCode).collect(Collectors.toSet());
            for (AddrTownsPo each : townsPos) {
                if (CollectionUtils.isEmpty(collect) || collect.contains(each.getCode())) continue;
                AddrTownsPo delAddrTownsPo = new AddrTownsPo();
                delAddrTownsPo.setCode(each.getCode());
                this.umcAddressMapper.deleteTowns(delAddrTownsPo);
            }
        }
    }

    public List<UmcAddressProvinceInfoQryBo> getProvinceInfoList(UmcAddressProvinceInfoQryBo qryBo) {
        AddrProvincePo addrProvincePo = (AddrProvincePo)UmcRu.js((Object)qryBo, AddrProvincePo.class);
        List rows = this.addrProvinceMapper.getList(addrProvincePo);
        return ObjectUtil.isNotEmpty((Object)rows) ? UmcRu.jsl((List)rows, UmcAddressProvinceInfoQryBo.class) : new ArrayList(0);
    }

    public List<UmcAddressCityInfoQryBo> getCityInfoList(UmcAddressCityInfoQryBo qryBo) {
        AddrCityPo addrCityPo = (AddrCityPo)UmcRu.js((Object)qryBo, AddrCityPo.class);
        List rows = this.addrCityMapper.getList(addrCityPo);
        return ObjectUtil.isNotEmpty((Object)rows) ? UmcRu.jsl((List)rows, UmcAddressCityInfoQryBo.class) : new ArrayList(0);
    }

    public List<UmcAddressAreaInfoQryBo> getAreaInfoList(UmcAddressAreaInfoQryBo qryBo) {
        AddrAreaPo addrAreaPo = (AddrAreaPo)UmcRu.js((Object)qryBo, AddrAreaPo.class);
        List rows = this.addrAreaMapper.getList(addrAreaPo);
        return ObjectUtil.isNotEmpty((Object)rows) ? UmcRu.jsl((List)rows, UmcAddressAreaInfoQryBo.class) : new ArrayList(0);
    }

    public List<UmcAddressTownsInfoQryBo> getTownInfoList(UmcAddressTownsInfoQryBo qryBo) {
        AddrTownsPo addrAreaPo = (AddrTownsPo)UmcRu.js((Object)qryBo, AddrTownsPo.class);
        List rows = this.addrTownsMapper.getList(addrAreaPo);
        return ObjectUtil.isNotEmpty((Object)rows) ? UmcRu.jsl((List)rows, UmcAddressTownsInfoQryBo.class) : new ArrayList(0);
    }

    public UmcAddrBo getAddressInfo(UmcAddressInfoQryBo qryBo) {
        UmcAddrBo umcAddrBo = new UmcAddrBo();
        if (null != qryBo) {
            if (!StringUtils.isBlank((CharSequence)qryBo.getProvinceName())) {
                AddrProvincePo addrProvincePo = new AddrProvincePo();
                addrProvincePo.setName(qryBo.getProvinceName());
                addrProvincePo = this.addrProvinceMapper.getModelBy(addrProvincePo);
                if (null != addrProvincePo) {
                    umcAddrBo.setProvinceCode(addrProvincePo.getCode());
                    umcAddrBo.setProvinceName(addrProvincePo.getName());
                }
            }
            if (!StringUtils.isBlank((CharSequence)qryBo.getCityName())) {
                AddrCityPo addrCityPo = new AddrCityPo();
                addrCityPo.setProvinceCode(qryBo.getProvinceCode());
                addrCityPo.setName(qryBo.getCityName());
                addrCityPo = this.addrCityMapper.getModelBy(addrCityPo);
                if (null != addrCityPo) {
                    umcAddrBo.setCityCode(addrCityPo.getCode());
                    umcAddrBo.setCityName(addrCityPo.getName());
                }
            }
            if (!StringUtils.isBlank((CharSequence)qryBo.getAreaName())) {
                AddrAreaPo addrAreaPo = new AddrAreaPo();
                addrAreaPo.setCityCode(qryBo.getCityCode());
                addrAreaPo.setName(qryBo.getAreaName());
                addrAreaPo = this.addrAreaMapper.getModelBy(addrAreaPo);
                if (null != addrAreaPo) {
                    umcAddrBo.setAreaCode(addrAreaPo.getCode());
                    umcAddrBo.setAreaName(addrAreaPo.getName());
                }
            }
            if (!StringUtils.isBlank((CharSequence)qryBo.getTownName())) {
                AddrTownsPo addrTownsPo = new AddrTownsPo();
                addrTownsPo.setName(qryBo.getTownName());
                addrTownsPo.setAreaCode(qryBo.getAreaCode());
                addrTownsPo = this.addrTownsMapper.getModelBy(addrTownsPo);
                if (null != addrTownsPo) {
                    umcAddrBo.setTownsCode(addrTownsPo.getCode());
                    umcAddrBo.setTownName(addrTownsPo.getName());
                }
            }
        }
        return umcAddrBo;
    }
}

