/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.brecord.UmcSupMisconductApplyBusiService;
import com.tydic.dyc.umc.model.brecord.qrybo.UmcSupMisconductApplyBusiReqBO;
import com.tydic.dyc.umc.model.brecord.sub.UmcSupMisconductApplyBusiRspBO;
import com.tydic.dyc.umc.repository.dao.OhaotianOrderSequenceMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductDescMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.po.OhaotianOrderSequencePO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductDescPO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductPO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcSupMisconductApplyBusiServiceImpl
implements UmcSupMisconductApplyBusiService {
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private SupplierMisconductDescMapper supplierMisconductDescMapper;
    @Autowired
    private OhaotianOrderSequenceMapper ohaotianOrderSequenceMapper;
    @Resource(name="supplierMisconductSequencePager")
    private OrderSequence supplierMisconductSequencePager;

    public UmcSupMisconductApplyBusiRspBO supMisconductApply(UmcSupMisconductApplyBusiReqBO reqBO) {
        UmcSupMisconductApplyBusiRspBO rspBO = new UmcSupMisconductApplyBusiRspBO();
        Long misconductId = Sequence.getInstance().nextId();
        SupplierMisconductPO smPO = new SupplierMisconductPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)smPO);
        smPO.setMisconductId(misconductId);
        smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.APPLYING);
        Long serialNumber = this.getRegAccountSequencePager();
        if (serialNumber >= 99L) {
            OhaotianOrderSequencePO ohaotianOrderSequencePO = new OhaotianOrderSequencePO();
            ohaotianOrderSequencePO.setId(7L);
            ohaotianOrderSequencePO.setCurrentValue(1L);
            int update = this.ohaotianOrderSequenceMapper.updateByCondition(ohaotianOrderSequencePO);
            if (update < 1) {
                throw new BaseBusinessException("161000", "\u5e8f\u5217\u5316\u8868\u4fee\u6539\u5931\u8d25\uff01");
            }
            serialNumber = 1L;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHH");
        String misconductCode = "SX" + df.format(LocalDateTime.now()) + String.format("%02d", serialNumber);
        smPO.setMisconductCode(misconductCode);
        smPO.setCreateTime(new Date());
        smPO.setCreateId(reqBO.getUserId());
        smPO.setCreateName(reqBO.getUserName());
        smPO.setOrgId(reqBO.getOrgId());
        smPO.setOrgName(reqBO.getOrgName());
        smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.APPLYING);
        smPO.setHandleStatus(UmcCommConstants.MisconductHandleStatus.HANDL_WAIT);
        this.supplierMisconductMapper.insert(smPO);
        SupplierMisconductDescPO smdPO = new SupplierMisconductDescPO();
        smdPO.setMisconductId(misconductId);
        smdPO.setMisconductDesc(reqBO.getMisconductDesc());
        this.supplierMisconductDescMapper.insert(smdPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private long getRegAccountSequencePager() {
        try {
            return this.supplierMisconductSequencePager.nextId();
        }
        catch (Exception e) {
            throw new BaseBusinessException("163069", "\u83b7\u53d6\u4e0d\u826f\u8bb0\u5f55\u7f16\u7801\u5f02\u5e38", (Throwable)e);
        }
    }
}

